/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.Value;
import org.structr.core.ViewTransformation;
import org.structr.core.app.StructrApp;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NoResultsException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.TransformationResource;
import org.structr.rest.resource.ViewFilterResource;

public class ResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)ResourceHelper.class.getName());

    public static List<Resource> parsePath(SecurityContext securityContext, HttpServletRequest request, Map<Pattern, Class<? extends Resource>> resourceMap, Value<String> propertyView) throws FrameworkException {
        String path = request.getPathInfo();
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new NoResultsException("No content");
        }
        String[] pathParts = path.split("[/]+");
        Set propertyViews = Services.getInstance().getConfigurationProvider().getPropertyViews();
        ArrayList<Resource> resourceChain = new ArrayList<Resource>(pathParts.length);
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i].trim();
            if (part.length() <= 0) continue;
            boolean found = false;
            if (propertyViews.contains(part)) {
                ViewFilterResource resource = new ViewFilterResource();
                ((Resource)resource).checkAndConfigure(part, securityContext, request);
                ((Resource)resource).configurePropertyView(propertyView);
                resourceChain.add(resource);
                found = true;
            } else {
                for (Map.Entry<Pattern, Class<? extends Resource>> entry : resourceMap.entrySet()) {
                    Pattern pattern = entry.getKey();
                    Matcher matcher = pattern.matcher(pathParts[i]);
                    if (!matcher.matches()) continue;
                    Class<? extends Resource> type = entry.getValue();
                    Resource resource = null;
                    try {
                        resource = type.newInstance();
                    }
                    catch (Throwable t) {
                        logger.warn("Error instantiating resource class", t);
                    }
                    if (resource == null) continue;
                    resource.setSecurityContext(securityContext);
                    if (!resource.checkAndConfigure(part, securityContext, request)) continue;
                    logger.debug("{} matched, adding resource of type {} for part {}", new Object[]{matcher.pattern(), type.getName(), part});
                    resource.configurePropertyView(propertyView);
                    resourceChain.add(resource);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            throw new NotFoundException("Cannot resolve URL path");
        }
        return resourceChain;
    }

    public static Resource optimizeNestedResourceChain(SecurityContext securityContext, HttpServletRequest request, Map<Pattern, Class<? extends Resource>> resourceMap, Value<String> propertyView) throws FrameworkException {
        List<Resource> resourceChain = ResourceHelper.parsePath(securityContext, request, resourceMap, propertyView);
        ViewFilterResource view = null;
        int num = resourceChain.size();
        boolean found = false;
        do {
            Iterator<Resource> it = resourceChain.iterator();
            while (it.hasNext()) {
                Resource constr = it.next();
                if (!(constr instanceof ViewFilterResource)) continue;
                view = (ViewFilterResource)constr;
                it.remove();
            }
            found = false;
            try {
                for (int i = 0; i < num; ++i) {
                    Resource secondElement;
                    Resource firstElement = resourceChain.get(i);
                    Resource combinedConstraint = firstElement.tryCombineWith(secondElement = resourceChain.get(i + 1));
                    if (combinedConstraint == null) continue;
                    resourceChain.remove(firstElement);
                    resourceChain.remove(secondElement);
                    resourceChain.add(i, combinedConstraint);
                    found = true;
                }
            }
            catch (Throwable i) {
                // empty catch block
            }
        } while (found);
        if (resourceChain.size() == 1) {
            Resource finalResource = resourceChain.get(0);
            if (view != null) {
                finalResource = finalResource.tryCombineWith(view);
            }
            if (finalResource == null) {
                finalResource = resourceChain.get(0);
            }
            return finalResource;
        }
        logger.warn("Resource chain evaluation for path {} resulted in {} entries, returning status code 400.", new Object[]{request.getPathInfo(), resourceChain.size()});
        throw new IllegalPathException("Cannot resolve URL path");
    }

    public static Resource applyViewTransformation(HttpServletRequest request, SecurityContext securityContext, Resource finalResource, Value<String> propertyView) throws FrameworkException {
        ViewTransformation transformation;
        Resource transformedResource = finalResource;
        Class<? extends GraphObject> type = finalResource.getEntityClass();
        if (type != null && (transformation = StructrApp.getConfiguration().getViewTransformation(type, (String)propertyView.get(securityContext))) != null) {
            transformedResource = transformedResource.tryCombineWith(new TransformationResource(securityContext, transformation));
        }
        return transformedResource;
    }
}

