/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.structr.api.config.Settings;
import org.structr.common.error.FrameworkException;
import org.structr.core.IJsonInput;
import org.structr.core.Result;
import org.structr.core.Value;
import org.structr.core.rest.JsonInputGSONAdapter;
import org.structr.rest.adapter.FrameworkExceptionGSONAdapter;
import org.structr.rest.adapter.ResultGSONAdapter;

public class ThreadLocalGson
extends ThreadLocal<Gson> {
    private int outputNestingDepth = 3;
    private Value<String> propertyView = null;

    public ThreadLocalGson(Value<String> propertyView, int outputNestingDepth) {
        this.propertyView = propertyView;
        this.outputNestingDepth = outputNestingDepth;
    }

    @Override
    protected Gson initialValue() {
        ResultGSONAdapter resultGsonAdapter = new ResultGSONAdapter(this.propertyView, this.outputNestingDepth);
        JsonInputGSONAdapter jsonInputAdapter = new JsonInputGSONAdapter();
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeHierarchyAdapter(FrameworkException.class, (Object)new FrameworkExceptionGSONAdapter()).registerTypeAdapter(IJsonInput.class, (Object)jsonInputAdapter).registerTypeAdapter(Result.class, (Object)resultGsonAdapter);
        boolean lenient = (Boolean)Settings.JsonLenient.getValue();
        if (lenient) {
            gsonBuilder.serializeSpecialFloatingPointValues();
        }
        return gsonBuilder.create();
    }
}

