/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.common.fulltext.FulltextIndexer;
import org.structr.common.fulltext.Indexable;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.IntProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.rest.common.HttpHelper;

public class RemoteDocument
extends AbstractNode
implements Indexable {
    private static final Logger logger = LoggerFactory.getLogger((String)RemoteDocument.class.getName());
    public static final Property<String> url = new StringProperty("url");
    public static final Property<Long> checksum = new LongProperty("checksum").indexed().unvalidated().readOnly();
    public static final Property<Integer> cacheForSeconds = new IntProperty("cacheForSeconds").cmis();
    public static final Property<Integer> version = new IntProperty("version").indexed().readOnly();
    public static final View publicView = new View(RemoteDocument.class, "public", new Property[]{type, name, contentType, url, owner});
    public static final View uiView = new View(RemoteDocument.class, "ui", new Property[]{type, contentType, url, checksum, version, cacheForSeconds, owner, extractedContent, indexedWords});

    public void afterCreation(SecurityContext securityContext) {
        this.update();
    }

    @Export
    public void update() {
        try {
            FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)this.securityContext).getFulltextIndexer(new Object[0]);
            fulltextIndexer.addToFulltextIndex((Indexable)this);
        }
        catch (FrameworkException frameworkException) {
            logger.warn("Unable to index " + (Object)((Object)this), (Throwable)frameworkException);
        }
    }

    @Export
    public GraphObject getSearchContext(String string, int n) {
        String string2 = (String)this.getProperty((PropertyKey)extractedContent);
        if (string2 != null) {
            FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)this.securityContext).getFulltextIndexer(new Object[0]);
            return fulltextIndexer.getContextObject(string, string2, n);
        }
        return null;
    }

    public void increaseVersion() throws FrameworkException {
        Integer n = (Integer)this.getProperty((PropertyKey)version);
        this.unlockSystemPropertiesOnce();
        if (n == null) {
            this.setProperty((PropertyKey)version, 1);
        } else {
            this.setProperty((PropertyKey)version, n + 1);
        }
    }

    public InputStream getInputStream() {
        String string = (String)this.getProperty((PropertyKey)url);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return HttpHelper.getAsStream((String)string);
        }
        return null;
    }
}

