/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.feed;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.fulltext.FulltextIndexer;
import org.structr.common.fulltext.Indexable;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.ISO8601DateProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.rest.common.HttpHelper;
import org.structr.schema.SchemaService;
import org.structr.web.entity.feed.DataFeed;
import org.structr.web.entity.feed.FeedItemContent;
import org.structr.web.entity.feed.FeedItemEnclosure;
import org.structr.web.entity.relation.FeedItemContents;
import org.structr.web.entity.relation.FeedItemEnclosures;
import org.structr.web.entity.relation.FeedItems;

public class FeedItem
extends AbstractNode
implements Indexable {
    private static final Logger logger = LoggerFactory.getLogger((String)FeedItem.class.getName());
    public static final Property<String> url = new StringProperty("url").unique().indexed();
    public static final Property<String> author = new StringProperty("author");
    public static final Property<String> comments = new StringProperty("comments");
    public static final Property<String> description = new StringProperty("description");
    public static final Property<List<FeedItemContent>> contents = new EndNodes("contents", FeedItemContents.class);
    public static final Property<List<FeedItemEnclosure>> enclosures = new EndNodes("enclosures", FeedItemEnclosures.class);
    public static final Property<Date> pubDate = new ISO8601DateProperty("pubDate").indexed();
    public static final Property<Long> checksum = new LongProperty("checksum").indexed().unvalidated().readOnly();
    public static final Property<Integer> cacheForSeconds = new IntProperty("cacheForSeconds").cmis();
    public static final Property<Integer> version = new IntProperty("version").indexed().readOnly();
    public static final Property<DataFeed> feed = new StartNode("feed", FeedItems.class);
    public static final View publicView = new View(FeedItem.class, "public", new Property[]{type, name, contentType, owner, url, author, comments, contents, pubDate, description, enclosures});
    public static final View uiView = new View(FeedItem.class, "ui", new Property[]{type, contentType, checksum, version, cacheForSeconds, owner, extractedContent, indexedWords, url, feed, author, comments, contents, pubDate, description, enclosures});

    public boolean isValid(ErrorBuffer errorBuffer) {
        boolean bl = super.isValid(errorBuffer);
        bl &= ValidationHelper.isValidStringNotBlank((GraphObject)this, url, (ErrorBuffer)errorBuffer);
        return bl &= ValidationHelper.isValidUniqueProperty((GraphObject)this, url, (ErrorBuffer)errorBuffer);
    }

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)securityContext).getFulltextIndexer(new Object[0]);
        fulltextIndexer.addToFulltextIndex((Indexable)this);
        return super.onCreation(securityContext, errorBuffer);
    }

    public void afterCreation(SecurityContext securityContext) {
        try {
            FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)securityContext).getFulltextIndexer(new Object[0]);
            fulltextIndexer.addToFulltextIndex((Indexable)this);
        }
        catch (FrameworkException frameworkException) {
            logger.warn("Unable to index " + (Object)((Object)this), (Throwable)frameworkException);
        }
    }

    @Export
    public GraphObject getSearchContext(String string, int n) {
        String string2 = (String)this.getProperty((PropertyKey)extractedContent);
        if (string2 != null) {
            FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)this.securityContext).getFulltextIndexer(new Object[0]);
            return fulltextIndexer.getContextObject(string, string2, n);
        }
        return null;
    }

    public void increaseVersion() throws FrameworkException {
        Integer n = (Integer)this.getProperty((PropertyKey)version);
        this.unlockSystemPropertiesOnce();
        if (n == null) {
            this.setProperty((PropertyKey)version, 1);
        } else {
            this.setProperty((PropertyKey)version, n + 1);
        }
    }

    public InputStream getInputStream() {
        String string = (String)this.getProperty((PropertyKey)url);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return HttpHelper.getAsStream((String)string);
        }
        return null;
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"FeedItem", (String)FeedItem.class.getName());
    }
}

