/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBind;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Map<String, BeanField> fieldMap = null;
    protected Class<? extends T> type;
    protected boolean annotationDriven;
    private static final String CANNOT_INSTANTIATE = "There was a problem instantiating the custom converter ";

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
        this.header = reader.readNext();
    }

    @Override
    public String[] generateHeader() {
        if (this.header == null) {
            if (this.fieldMap == null) {
                this.loadFields(this.type);
            }
            TreeSet<String> set = new TreeSet<String>(this.fieldMap.keySet());
            this.header = set.toArray(new String[this.fieldMap.size()]);
        }
        return (String[])ArrayUtils.clone((Object[])this.header);
    }

    protected void createIndexLookup(String[] values) {
        if (this.indexLookup.isEmpty()) {
            for (int i = 0; i < values.length; ++i) {
                this.indexLookup.put(values[i], i);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (null == this.header) {
            throw new IllegalStateException("The header row hasn't been read yet.");
        }
        this.createIndexLookup(this.header);
        return this.indexLookup.get(name);
    }

    @Override
    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return StringUtils.isNotBlank((CharSequence)columnName) ? this.findDescriptor(columnName) : null;
    }

    @Override
    public BeanField findField(int col) throws CsvBadConverterException {
        String columnName = this.getColumnName(col);
        return StringUtils.isNotBlank((CharSequence)columnName) ? this.fieldMap.get(columnName.toUpperCase().trim()) : null;
    }

    @Override
    public int findMaxFieldIndex() {
        return this.header == null ? -1 : this.header.length - 1;
    }

    public String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap();
        }
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors = this.loadDescriptors(this.getType())) {
            map.put(descriptor.getName().toUpperCase(), descriptor);
        }
        return map;
    }

    protected BeanField instantiateCustomConverter(Class<? extends AbstractBeanField> converter) throws CsvBadConverterException {
        try {
            return converter.newInstance();
        }
        catch (IllegalAccessException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, CANNOT_INSTANTIATE + converter.getCanonicalName());
            newEx.initCause(oldEx);
            throw newEx;
        }
        catch (InstantiationException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, CANNOT_INSTANTIATE + converter.getCanonicalName());
            newEx.initCause(oldEx);
            throw newEx;
        }
    }

    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap<String, BeanField>();
        for (Field field : this.loadFields(this.getType())) {
            String columnName;
            if (field.isAnnotationPresent(CsvCustomBindByName.class)) {
                columnName = field.getAnnotation(CsvCustomBindByName.class).column().toUpperCase().trim();
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    columnName = field.getName().toUpperCase();
                }
                Class<? extends AbstractBeanField> converter = field.getAnnotation(CsvCustomBindByName.class).converter();
                BeanField bean = this.instantiateCustomConverter(converter);
                bean.setField(field);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            if (field.isAnnotationPresent(CsvBindByName.class)) {
                boolean required = field.getAnnotation(CsvBindByName.class).required();
                columnName = field.getAnnotation(CsvBindByName.class).column().toUpperCase().trim();
                String locale = field.getAnnotation(CsvBindByName.class).locale();
                if (field.isAnnotationPresent(CsvDate.class)) {
                    String formatString = field.getAnnotation(CsvDate.class).value();
                    if (StringUtils.isEmpty((CharSequence)columnName)) {
                        this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldDate(field, required, formatString, locale));
                        continue;
                    }
                    this.fieldMap.put(columnName, new BeanFieldDate(field, required, formatString, locale));
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldPrimitiveTypes(field, required, locale));
                    continue;
                }
                this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, locale));
                continue;
            }
            boolean required = field.getAnnotation(CsvBind.class).required();
            this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldPrimitiveTypes(field, required, null));
        }
    }

    private PropertyDescriptor[] loadDescriptors(Class<? extends T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : FieldUtils.getAllFields(cls)) {
            if (!field.isAnnotationPresent(CsvBind.class) && !field.isAnnotationPresent(CsvBindByName.class) && !field.isAnnotationPresent(CsvCustomBindByName.class)) continue;
            fields.add(field);
        }
        this.annotationDriven = !fields.isEmpty();
        return fields;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException, IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException("The type has not been set in the MappingStrategy.");
        }
        return this.type.newInstance();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
    }

    @Override
    public boolean isAnnotationDriven() {
        return this.annotationDriven;
    }
}

