/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.JavaClass;
import com.caucho.util.ByteBuffer;
import com.caucho.util.IntArray;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeEnhancer
extends CodeVisitor {
    private static final Logger log = Logger.getLogger(CodeEnhancer.class.getName());
    private ByteBuffer _code;
    private ArrayList<Jump> _jumps;
    private ArrayList<Switch> _switches;
    private boolean _changeLength;
    private IntArray _pendingTargets;
    private IntArray _completedTargets;

    public CodeEnhancer() {
    }

    public CodeEnhancer(JavaClass javaClass, CodeAttribute code) {
        this.init(javaClass, code);
    }

    public void init(JavaClass javaClass, CodeAttribute codeAttr) {
        super.init(javaClass, codeAttr);
        this._code = new ByteBuffer();
        byte[] codeBuffer = codeAttr.getCode();
        this._code.add(codeBuffer, 0, codeBuffer.length);
        this._changeLength = false;
    }

    public void analyze(Analyzer analyzer, boolean allowFlow) throws Exception {
        this._pendingTargets = new IntArray();
        this._completedTargets = new IntArray();
        this.analyzeImpl(analyzer, allowFlow, this._pendingTargets, this._completedTargets);
    }

    public byte[] getCode() {
        return this._code.getBuffer();
    }

    public int getLength() {
        return this._code.getLength();
    }

    public void addByte(int offset, int value) {
        this.insertCode(offset, 1);
        this._code.set(offset, value);
    }

    public void setByte(int offset, int value) {
        this._code.set(offset, value);
    }

    public void addShort(int offset, int value) {
        this.insertCode(offset, 2);
        this._code.set(offset + 0, value >> 8);
        this._code.set(offset + 1, value);
    }

    public void add(int offset, byte[] buffer, int bufOffset, int length) {
        this.insertCode(offset, length);
        this._code.set(offset, buffer, bufOffset, length);
    }

    public void remove(int offset, int count) {
        this.removeCode(offset, count);
    }

    public void addNulls(int offset, int count) {
        this.insertCode(offset, count);
    }

    protected void insertCode(int offset, int count) {
        int i;
        if (this._jumps == null) {
            this.analyzeJumps();
        }
        if (offset <= this._offset) {
            this._offset += count;
        }
        for (int i2 = 0; i2 < this._jumps.size(); ++i2) {
            Jump jump = this._jumps.get(i2);
            jump.insert(this, offset, count);
        }
        ArrayList<CodeAttribute.ExceptionItem> exns = this.getExceptions();
        for (i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            if (offset <= exn.getStart()) {
                exn.setStart(exn.getStart() + count);
            }
            if (offset <= exn.getEnd()) {
                exn.setEnd(exn.getEnd() + count);
            }
            if (offset > exn.getHandler()) continue;
            exn.setHandler(exn.getHandler() + count);
        }
        if (this._pendingTargets != null) {
            for (i = this._pendingTargets.size() - 1; i >= 0; --i) {
                int target = this._pendingTargets.get(i);
                if (offset > target) continue;
                this._pendingTargets.set(i, target + count);
            }
            for (i = this._completedTargets.size() - 1; i >= 0; --i) {
                int target = this._completedTargets.get(i);
                if (offset > target) continue;
                this._completedTargets.set(i, target + count);
            }
        }
        for (i = 0; i < this._switches.size(); ++i) {
            Branch branch = this._switches.get(i);
            branch.insert(this, offset, count);
        }
        for (i = 0; i < count; ++i) {
            this._code.add(offset, 0);
        }
        for (i = 0; i < this._switches.size(); ++i) {
            Switch branch = this._switches.get(i);
            branch.insertPad(this, offset, count);
        }
    }

    protected void removeCode(int offset, int count) {
        int i;
        if (this._jumps == null) {
            this.analyzeJumps();
        }
        if (offset + count < this._offset) {
            this._offset -= count;
        } else if (offset <= this._offset) {
            this._offset = offset;
        }
        for (int i2 = 0; i2 < this._jumps.size(); ++i2) {
            Branch jump = this._jumps.get(i2);
            jump.remove(this, offset, count);
        }
        ArrayList<CodeAttribute.ExceptionItem> exns = this.getExceptions();
        for (i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            exn.setStart(this.remove(exn.getStart(), offset, count));
            exn.setEnd(this.remove(exn.getEnd(), offset, count));
            exn.setHandler(this.remove(exn.getHandler(), offset, count));
        }
        if (this._pendingTargets != null) {
            for (i = this._pendingTargets.size() - 1; i >= 0; --i) {
                int target = this._pendingTargets.get(i);
                this._pendingTargets.set(i, this.remove(target, offset, count));
            }
            for (i = this._completedTargets.size() - 1; i >= 0; --i) {
                int target = this._completedTargets.get(i);
                this._completedTargets.set(i, this.remove(target, offset, count));
            }
        }
        for (i = 0; i < this._switches.size(); ++i) {
            Branch branch = this._switches.get(i);
            branch.remove(this, offset, count);
        }
        this._code.remove(offset, count);
        for (i = 0; i < this._switches.size(); ++i) {
            Switch branch = this._switches.get(i);
            branch.removePad(this, offset, count);
        }
    }

    protected void analyzeJumps() {
        this._jumps = new ArrayList();
        this._switches = new ArrayList();
        this._changeLength = true;
        JumpAnalyzer analyzer = new JumpAnalyzer();
        CodeVisitor visitor = new CodeVisitor(this.getJavaClass(), this.getCodeAttribute());
        try {
            visitor.analyze(analyzer);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void update() {
        byte[] code = new byte[this._code.size()];
        System.arraycopy(this._code.getBuffer(), 0, code, 0, this._code.size());
        this._codeAttr.setCode(code);
        if (this._changeLength) {
            ArrayList<Attribute> attrList = this.getCodeAttribute().getAttributes();
            for (int i = attrList.size() - 1; i >= 0; --i) {
                Attribute attr = attrList.get(i);
                if (!attr.getName().equals("LineNumberTable")) continue;
                attrList.remove(i);
            }
        }
    }

    private int remove(int pc, int offset, int count) {
        if (pc < offset) {
            return pc;
        }
        if (pc < offset + count) {
            return offset;
        }
        return pc - count;
    }

    class JumpAnalyzer
    extends Analyzer {
        JumpAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (visitor.isSwitch()) {
                int src = visitor.getOffset();
                switch (visitor.getOpcode()) {
                    case 170: {
                        TableSwitch branch = new TableSwitch(src, visitor);
                        if (CodeEnhancer.this._switches.contains(branch)) break;
                        CodeEnhancer.this._switches.add(branch);
                        break;
                    }
                    case 171: {
                        LookupSwitch branch = new LookupSwitch(src, visitor);
                        if (CodeEnhancer.this._switches.contains(branch)) break;
                        CodeEnhancer.this._switches.add(branch);
                        break;
                    }
                }
            } else if (visitor.isBranch()) {
                int src = visitor.getOffset();
                int offset = visitor.getShortArg(1);
                CodeEnhancer.this._jumps.add(new Jump(src, offset));
            }
        }
    }

    static class LookupSwitch
    extends Switch {
        LookupSwitch(int src, CodeVisitor visitor) {
            super(src);
            int arg = src + 1;
            arg += (4 - arg % 4) % 4;
            int n = visitor.getInt(arg + 4);
            int[] offsets = new int[n + 1];
            offsets[0] = arg;
            for (int i = 0; i < n; ++i) {
                offsets[i + 1] = arg + 8 + i * 8 + 4;
            }
            this.setOffsets(offsets);
        }
    }

    static class TableSwitch
    extends Switch {
        TableSwitch(int src, CodeVisitor visitor) {
            super(src);
            int arg = src + 1;
            arg += (4 - arg % 4) % 4;
            int low = visitor.getInt(arg + 4);
            int high = visitor.getInt(arg + 8);
            int[] offsets = new int[high - low + 2];
            offsets[0] = arg;
            for (int i = 0; i <= high - low; ++i) {
                offsets[i + 1] = arg + 12 + i * 4;
            }
            this.setOffsets(offsets);
        }
    }

    static class Switch
    extends Branch {
        private int _oldSrc;
        private int _src;
        private int[] _offsets;

        Switch(int src) {
            this._src = src;
            this._oldSrc = src;
        }

        protected void setOffsets(int[] offsets) {
            this._offsets = offsets;
        }

        void insert(CodeEnhancer enhancer, int offset, int count) {
            for (int i = 0; i < this._offsets.length; ++i) {
                int delta = enhancer.getInt(this._offsets[i]);
                if (offset <= this._src && this._src + delta <= offset) {
                    enhancer.setInt(this._offsets[i], delta - count);
                } else if (this._src < offset && offset < this._src + delta) {
                    enhancer.setInt(this._offsets[i], delta + count);
                }
                if (offset > this._src + 1) continue;
                int n = i;
                this._offsets[n] = this._offsets[n] + count;
            }
            if (offset < this._src) {
                this._src += count;
            }
        }

        void remove(CodeEnhancer enhancer, int offset, int count) {
            for (int i = 0; i < this._offsets.length; ++i) {
                int delta = enhancer.getInt(this._offsets[i]);
                if (offset <= this._src && this._src + delta <= offset) {
                    enhancer.setInt(this._offsets[i], delta + count);
                } else if (this._src < offset && offset < this._src + delta) {
                    enhancer.setInt(this._offsets[i], delta - count);
                }
                if (offset > this._src + 1) continue;
                int n = i;
                this._offsets[n] = this._offsets[n] - count;
            }
            if (offset < this._src) {
                this._src -= count;
            }
        }

        void insertPad(CodeEnhancer enhancer, int offset, int count) {
            if (this._oldSrc != this._src) {
                int oldPad = (4 - (this._oldSrc + 1) % 4) % 4;
                int newPad = (4 - (this._src + 1) % 4) % 4;
                this._oldSrc = this._src;
                if (newPad < oldPad) {
                    enhancer.remove(this._src + 1, oldPad - newPad);
                } else if (oldPad < newPad) {
                    enhancer.addNulls(this._src + 1, newPad - oldPad);
                }
            }
        }

        void removePad(CodeEnhancer enhancer, int offset, int count) {
            if (this._oldSrc != this._src) {
                int oldPad = (4 - (this._oldSrc + 1) % 4) % 4;
                int newPad = (4 - (this._src + 1) % 4) % 4;
                this._oldSrc = this._src;
                if (newPad < oldPad) {
                    enhancer.remove(this._src + 1, oldPad - newPad);
                } else if (oldPad < newPad) {
                    enhancer.addNulls(this._src + 1, newPad - oldPad);
                }
            }
        }

        public boolean equals(Object v) {
            if (!(v instanceof Switch)) {
                return false;
            }
            Switch s = (Switch)v;
            return this._src == s._src;
        }
    }

    static class Jump
    extends Branch {
        private int _src;
        private int _delta;

        Jump(int src, int delta) {
            this._src = src;
            this._delta = delta;
        }

        void insert(CodeEnhancer enhancer, int offset, int count) {
            if (offset <= this._src && offset <= this._src + this._delta) {
                this._src += count;
            } else if (this._src < offset && offset < this._src + this._delta) {
                this._delta += count;
                enhancer.setShort(this._src + 1, this._delta);
            } else if (this._src + this._delta <= offset && offset <= this._src) {
                this._delta -= count;
                enhancer.setShort(this._src + 1, this._delta);
                this._src += count;
            }
        }

        void remove(CodeEnhancer enhancer, int offset, int count) {
            if (offset <= this._src && offset <= this._src + this._delta) {
                this._src -= count;
            } else if (this._src < offset && offset < this._src + this._delta) {
                this._delta -= count;
                enhancer.setShort(this._src + 1, this._delta);
            } else if (this._src + this._delta <= offset && offset <= this._src) {
                this._delta += count;
                enhancer.setShort(this._src + 1, this._delta);
                this._src -= count;
            }
        }
    }

    static abstract class Branch {
        Branch() {
        }

        abstract void insert(CodeEnhancer var1, int var2, int var3);

        abstract void remove(CodeEnhancer var1, int var2, int var3);
    }
}

