/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ConfigMXBean;
import com.caucho.vfs.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAdmin
extends AbstractManagedObject
implements ConfigMXBean {
    public static EnvironmentLocal<Map<Path, ConfigMXBean>> _environmentConfigs = new EnvironmentLocal();
    private Path _path;
    private String _url;
    private long _length;
    private long _lastModified;
    private long _crc64 = -1L;

    ConfigAdmin(Path path) {
        this._path = path;
        this._url = this._path.getURL();
        this._length = this._path.getLength();
        this._lastModified = this._path.getLastModified();
        this._crc64 = this._path.getCrc64();
    }

    public static void registerPath(Path path) {
        if (path.getURL().toLowerCase().endsWith(".license")) {
            return;
        }
        Map<Path, ConfigMXBean> map = _environmentConfigs.getLevel();
        if (map == null) {
            map = new HashMap<Path, ConfigMXBean>();
            _environmentConfigs.set(map);
        }
        if (!map.containsKey(path)) {
            ConfigAdmin admin = new ConfigAdmin(path);
            admin.register();
            map.put(path, admin);
        }
    }

    public static Collection<ConfigMXBean> getMBeans() {
        Map<Path, ConfigMXBean> map = _environmentConfigs.get();
        if (map == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(map.values());
    }

    public static Collection<ConfigMXBean> getMBeans(ClassLoader classLoader) {
        Map<Path, ConfigMXBean> map = _environmentConfigs.get(classLoader);
        if (map == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(map.values());
    }

    @Override
    public String getPath() {
        return this._path.getFullPath();
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    @Override
    public long getCrc64() {
        return this._crc64;
    }

    @Override
    public String getName() {
        return this._url;
    }

    void register() {
        this.registerSelf();
    }

    void unregister() {
        this.unregisterSelf();
    }
}

