/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.LockFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ejb.LockType;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class LockGenerator<X>
extends AbstractAspectGenerator<X> {
    private static final int DEFAULT_TIMEOUT = 10000;
    private boolean _isContainerManaged = true;
    private LockType _lockType;
    private long _lockTimeout;
    private TimeUnit _lockTimeoutUnit;

    public LockGenerator(LockFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next, LockType lockType, long lockTimeout, TimeUnit lockTimeoutUnit) {
        super(factory, method, next);
        this._lockType = lockType;
        if (lockTimeoutUnit != null) {
            this._lockTimeout = lockTimeout;
            this._lockTimeoutUnit = lockTimeoutUnit;
        } else {
            this._lockTimeout = 10000L;
            this._lockTimeoutUnit = TimeUnit.MILLISECONDS;
        }
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._isContainerManaged && this._lockType != null && map.get("caucho.ejb.lock") == null) {
            map.put("caucho.ejb.lock", "done");
            out.println();
            out.println("private transient final java.util.concurrent.locks.ReentrantReadWriteLock _readWriteLock");
            out.println(" = new java.util.concurrent.locks.ReentrantReadWriteLock(true);");
        }
        super.generateMethodPrologue(out, map);
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        out.println("boolean isLocked = false;");
        if (this._isContainerManaged && this._lockType != null) {
            out.println();
            switch (this._lockType) {
                case READ: {
                    if (this._lockTimeout != -1L) {
                        out.println("com.caucho.config.util.LockUtil.lockRead(_readWriteLock.readLock()," + this._lockTimeoutUnit.toMillis(this._lockTimeout) + "L" + ");");
                        break;
                    }
                    out.println("_readWriteLock.readLock().lock();");
                    break;
                }
                case WRITE: {
                    if (this._lockTimeout != -1L) {
                        out.println("com.caucho.config.util.LockUtil.lockWrite(_readWriteLock," + this._lockTimeoutUnit.toMillis(this._lockTimeout) + "L" + ");");
                        break;
                    }
                    out.println("com.caucho.config.util.LockUtil.lockWrite(_readWriteLock);");
                }
            }
            out.println();
            out.println("try {");
            out.pushDepth();
        }
        out.println("isLocked = true;");
        super.generatePreTry(out);
    }

    @Override
    public void generatePostFinally(JavaWriter out) throws IOException {
        super.generatePostFinally(out);
        if (this._isContainerManaged && this._lockType != null) {
            out.popDepth();
            out.println("} finally {");
            out.pushDepth();
            switch (this._lockType) {
                case READ: {
                    out.println();
                    out.println("if (isLocked)");
                    out.println("  _readWriteLock.readLock().unlock();");
                    break;
                }
                case WRITE: {
                    out.println();
                    out.println("if (isLocked)");
                    out.println("  _readWriteLock.writeLock().unlock();");
                }
            }
            out.popDepth();
            out.println("}");
        }
    }
}

