/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectionBean;
import com.caucho.config.inject.InjectionTargetFilter;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.SingletonBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.inject.NamedLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder<T> {
    private ManagedBeanImpl<T> _managedBean;
    private Set<Type> _types;
    private AnnotatedElementImpl _annotated;
    private Set<Annotation> _qualifiers;
    private Set<Class<? extends Annotation>> _stereotypes;
    private String _name;
    private Class<? extends Annotation> _scopeType;
    private InjectionTarget<T> _injectionTarget;
    private ContainerProgram _init;

    public BeanBuilder(ManagedBeanImpl<T> managedBean) {
        this._managedBean = managedBean;
        this._injectionTarget = managedBean.getInjectionTarget();
    }

    public AnnotatedType<T> getAnnotatedType() {
        return this._managedBean.getAnnotatedType();
    }

    public Annotated getExtendedAnnotated() {
        return this._annotated;
    }

    public BeanBuilder<T> name(String name) {
        this._name = name;
        return this;
    }

    public BeanBuilder<T> qualifier(Annotation ann) {
        if (this._qualifiers == null) {
            this._qualifiers = new LinkedHashSet<Annotation>();
        }
        this._qualifiers.add(ann);
        return this;
    }

    public BeanBuilder<T> binding(Collection<Annotation> list) {
        if (this._qualifiers == null) {
            this._qualifiers = new LinkedHashSet<Annotation>();
        }
        this._qualifiers.addAll(list);
        return this;
    }

    public BeanBuilder<T> stereotype(Class<? extends Annotation> annType) {
        if (this._stereotypes == null) {
            this._stereotypes = new LinkedHashSet<Class<? extends Annotation>>();
        }
        this._stereotypes.add(annType);
        return this;
    }

    public BeanBuilder<T> stereotype(Collection<Class<? extends Annotation>> list) {
        if (this._stereotypes == null) {
            this._stereotypes = new LinkedHashSet<Class<? extends Annotation>>();
        }
        this._stereotypes.addAll(list);
        return this;
    }

    public BeanBuilder<T> annotation(Annotation ann) {
        if (this._annotated == null) {
            this._annotated = new AnnotatedElementImpl(this._managedBean.getAnnotated());
        }
        this._annotated.addAnnotation(ann);
        return this;
    }

    public BeanBuilder<T> annotation(Collection<Annotation> list) {
        if (this._annotated == null) {
            this._annotated = new AnnotatedElementImpl(this._managedBean.getAnnotated());
        }
        for (Annotation ann : list) {
            this._annotated.addAnnotation(ann);
        }
        return this;
    }

    public BeanBuilder<T> scope(Class<? extends Annotation> scopeType) {
        this._scopeType = scopeType;
        return this;
    }

    public BeanBuilder<T> type(Type ... types) {
        if (this._types == null) {
            this._types = new LinkedHashSet<Type>();
        }
        if (types != null) {
            for (Type type : types) {
                this._types.add(type);
            }
        }
        return this;
    }

    public BeanBuilder<T> type(Set<Type> types) {
        if (this._types == null) {
            this._types = new LinkedHashSet<Type>();
        }
        if (types != null) {
            this._types.addAll(types);
        }
        return this;
    }

    public BeanBuilder<T> init(ConfigProgram init) {
        if (init != null) {
            if (this._init == null) {
                this._init = new ContainerProgram();
                this._injectionTarget = new InjectionTargetFilter<T>(this._injectionTarget, this._init);
            }
            this._init.addProgram(init);
        }
        return this;
    }

    public Bean<T> singleton(Object value) {
        SingletonBean<Object> bean = new SingletonBean<Object>(this._managedBean, this._types, this._annotated, this._qualifiers, this._stereotypes, this._scopeType, this._name, value);
        bean.introspectObservers();
        return bean;
    }

    public Bean<T> injection(InjectionTarget<T> injection) {
        return new InjectionBean<T>(this._managedBean, this._types, this._annotated, this._qualifiers, this._stereotypes, this._scopeType, this._name, injection);
    }

    public Bean<T> bean() {
        if (this._name != null && this._qualifiers == null) {
            this.qualifier((Annotation)DefaultLiteral.DEFAULT);
            this.qualifier((Annotation)((Object)new NamedLiteral(this._name)));
        }
        return new InjectionBean<T>(this._managedBean, this._types, this._annotated, this._qualifiers, this._stereotypes, this._scopeType, this._name, this._injectionTarget);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._managedBean.getBeanClass() + ", " + this._qualifiers + ", " + this._name + "]";
    }
}

