/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.CauchoDeployment;
import com.caucho.config.ConfigException;
import com.caucho.config.Configured;
import com.caucho.config.ContextDependent;
import com.caucho.config.LineConfigException;
import com.caucho.config.ModulePrivate;
import com.caucho.config.ModulePrivateLiteral;
import com.caucho.config.bytecode.ScopeAdapter;
import com.caucho.config.el.CandiElResolver;
import com.caucho.config.el.CandiExpressionFactory;
import com.caucho.config.event.EventBeanImpl;
import com.caucho.config.event.EventManager;
import com.caucho.config.extension.ExtensionManager;
import com.caucho.config.inject.AbstractBean;
import com.caucho.config.inject.AbstractIntrospectedBean;
import com.caucho.config.inject.AnnotatedBean;
import com.caucho.config.inject.AnyLiteral;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.BeanWrapper;
import com.caucho.config.inject.CdiStatefulBean;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.DecoratorBean;
import com.caucho.config.inject.DecoratorEntry;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.DependentCreationalContext;
import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.InjectEnvironmentBean;
import com.caucho.config.inject.InjectScanClass;
import com.caucho.config.inject.InjectScanManager;
import com.caucho.config.inject.InjectionPointBean;
import com.caucho.config.inject.InjectionPointHandler;
import com.caucho.config.inject.InjectionPointStandardBean;
import com.caucho.config.inject.InjectionTargetBuilder;
import com.caucho.config.inject.InstanceBeanImpl;
import com.caucho.config.inject.InterceptorBean;
import com.caucho.config.inject.InterceptorEntry;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.ManagedProducesBuilder;
import com.caucho.config.inject.NewBean;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.inject.ProducesBuilder;
import com.caucho.config.inject.ProducesFieldBean;
import com.caucho.config.inject.ProducesMethodBean;
import com.caucho.config.inject.QualifierBinding;
import com.caucho.config.inject.ScanRootContext;
import com.caucho.config.inject.ScopeAdapterBean;
import com.caucho.config.inject.WebBeansJndiProxy;
import com.caucho.config.inject.WebComponent;
import com.caucho.config.j2ee.DataSourceDefinitionHandler;
import com.caucho.config.j2ee.EjbHandler;
import com.caucho.config.j2ee.PersistenceContextHandler;
import com.caucho.config.j2ee.PersistenceUnitHandler;
import com.caucho.config.j2ee.ResourceHandler;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ResourceProgramManager;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.BaseTypeFactory;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.config.scope.ApplicationContext;
import com.caucho.config.scope.DependentContext;
import com.caucho.config.scope.ErrorContext;
import com.caucho.config.scope.SingletonScope;
import com.caucho.config.xml.XmlCookie;
import com.caucho.config.xml.XmlCookieLiteral;
import com.caucho.config.xml.XmlStandardPlugin;
import com.caucho.inject.Module;
import com.caucho.inject.RequestContext;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentApply;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CurrentTime;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.sql.DataSourceDefinition;
import javax.annotation.sql.DataSourceDefinitions;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.ejb.Stateful;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.Interceptor;
import javax.interceptor.InterceptorBinding;
import javax.naming.InitialContext;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ModulePrivate
public final class InjectManager
implements BeanManager,
EnvironmentListener,
Serializable,
HandleAware {
    private static final L10N L;
    private static final Logger log;
    private static final EnvironmentLocal<InjectManager> _localContainer;
    private static final int DEFAULT_PRIORITY = 1;
    private static final Annotation[] DEFAULT_ANN;
    private static final String[] FORBIDDEN_ANNOTATIONS;
    private static final String[] FORBIDDEN_CLASSES;
    private static final Class<? extends Annotation>[] _forbiddenAnnotations;
    private static final Class<?>[] _forbiddenClasses;
    private static final ClassLoader _systemClassLoader;
    private final String _id;
    private final InjectManager _parent;
    private EnvironmentClassLoader _classLoader;
    private ClassLoader _jndiClassLoader;
    private boolean _isChildManager;
    private final InjectScanManager _scanManager;
    private final ExtensionManager _extensionManager;
    private EventManager _eventManager = new EventManager(this);
    private AtomicLong _version = new AtomicLong();
    private HashMap<Class<?>, Class<?>> _specializedMap = new HashMap();
    private HashMap<Class<?>, Integer> _deploymentMap = new HashMap();
    private BaseTypeFactory _baseTypeFactory = new BaseTypeFactory();
    private HashMap<Class<?>, InjectionPointHandler> _injectionMap = new HashMap();
    private ResourceProgramManager _resourceManager = new ResourceProgramManager();
    private ConcurrentHashMap<Class<?>, ArrayList<TypedBean>> _selfBeanMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ArrayList<Bean<?>>> _selfNamedBeanMap = new ConcurrentHashMap();
    private HashMap<String, Bean<?>> _selfPassivationBeanMap = new HashMap();
    private HashMap<String, WebComponent> _beanMap = new HashMap();
    private ConcurrentHashMap<String, ArrayList<Bean<?>>> _namedBeanMap = new ConcurrentHashMap();
    private HashMap<Type, Bean<?>> _newBeanMap = new HashMap();
    private HashSet<Class<? extends Annotation>> _qualifierSet = new HashSet();
    private HashSet<Class<? extends Annotation>> _scopeTypeSet = new HashSet();
    private HashSet<Class<? extends Annotation>> _normalScopeSet = new HashSet();
    private HashSet<Class<? extends Annotation>> _passivatingScopeSet = new HashSet();
    private HashMap<Class<? extends Annotation>, Set<Annotation>> _stereotypeMap = new HashMap();
    private HashMap<Class<?>, Context> _contextMap = new HashMap();
    private ArrayList<Class<?>> _interceptorClassList = new ArrayList();
    private ArrayList<InterceptorEntry<?>> _interceptorList = new ArrayList();
    private ArrayList<Class<?>> _decoratorClassList = new ArrayList();
    private ArrayList<DecoratorEntry<?>> _decoratorList = new ArrayList();
    private HashSet<Bean<?>> _beanSet = new HashSet();
    private boolean _isEnableAutoUpdate = true;
    private boolean _isUpdateNeeded = true;
    private boolean _isAfterValidationNeeded = true;
    private ConcurrentHashMap<Path, List<Path>> _beansXMLOverrides = new ConcurrentHashMap();
    private ArrayList<AnnotatedType<?>> _pendingAnnotatedTypes = new ArrayList();
    private ArrayList<AbstractBean<?>> _pendingBindList = new ArrayList();
    private ArrayList<Bean<?>> _pendingValidationBeans = new ArrayList();
    private ArrayList<Bean<?>> _pendingServiceList = new ArrayList();
    private ArrayList<ConfigProgram> _globalProgram = new ArrayList();
    private ConcurrentHashMap<Bean<?>, ReferenceFactory<?>> _refFactoryMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ReferenceFactory<?>> _namedRefFactoryMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Member, AtomicBoolean> _staticMemberMap = new ConcurrentHashMap();
    private ThreadLocal<CreationalContextImpl<?>> _proxyThreadLocal = new ThreadLocal();
    private ConcurrentHashMap<Class<?>, ManagedBeanImpl<?>> _transientMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, InjectionTarget<?>> _xmlTargetMap = new ConcurrentHashMap();
    private boolean _isBeforeBeanDiscoveryComplete;
    private boolean _isBeforeBeanDiscoverFired;
    private boolean _isAfterBeanDiscoveryComplete;
    private final AtomicLong _xmlCookieSequence = new AtomicLong(CurrentTime.getCurrentTime());
    private ELResolver _elResolver = new CandiElResolver(this);
    private final DependentContext _dependentContext = new DependentContext();
    private SingletonScope _singletonScope;
    private ApplicationContext _applicationScope;
    private final XmlStandardPlugin _xmlExtension;
    private RuntimeException _configException;
    private Object _serializationHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectManager(String id, InjectManager parent, EnvironmentClassLoader loader, boolean isSetLocal) {
        this._id = id;
        this._classLoader = loader;
        this._parent = parent;
        this._extensionManager = new ExtensionManager(this);
        this._scanManager = new InjectScanManager(this);
        this._xmlExtension = new XmlStandardPlugin(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            if (isSetLocal) {
                _localContainer.set(this, this._classLoader);
                if (this._parent == null) {
                    _localContainer.setGlobal(this);
                }
            }
            if (this._classLoader != null) {
                this._classLoader.getNewTempClassLoader();
            }
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean isSetLocal) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            try {
                InitialContext ic = new InitialContext();
                ic.rebind("java:comp/BeanManager", (Object)new WebBeansJndiProxy());
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            this._singletonScope = new SingletonScope();
            this._applicationScope = new ApplicationContext();
            this.addContext(new RequestContext());
            this.addContext("com.caucho.server.webbeans.SessionScopeImpl");
            this.addContext("com.caucho.server.webbeans.ConversationContext");
            this.addContext("com.caucho.server.webbeans.TransactionScope");
            this.addContext(this._applicationScope);
            this.addContext(this._singletonScope);
            this.addContext(this._dependentContext);
            this._injectionMap.put(PersistenceContext.class, new PersistenceContextHandler(this));
            this._injectionMap.put(PersistenceUnit.class, new PersistenceUnitHandler(this));
            this._injectionMap.put(Resource.class, new ResourceHandler(this));
            this._injectionMap.put(EJB.class, new EjbHandler(this));
            this._injectionMap.put(EJBs.class, new EjbHandler(this));
            this._injectionMap.put(DataSourceDefinition.class, new DataSourceDefinitionHandler(this));
            this._injectionMap.put(DataSourceDefinitions.class, new DataSourceDefinitionHandler(this));
            this._deploymentMap.put(CauchoDeployment.class, 0);
            this._deploymentMap.put(Configured.class, 2);
            BeanBuilder<InjectManager> factory = this.createBeanFactory(InjectManager.class);
            factory.type(new Type[]{InjectManager.class});
            factory.type(new Type[]{BeanManager.class});
            factory.annotation(ModulePrivateLiteral.create());
            this.addBean(factory.singleton(this));
            this.addBean(new InjectionPointStandardBean());
            this.addExtension(this._xmlExtension);
            this._extensionManager.createExtension("com.caucho.server.webbeans.ResinStandardPlugin");
            if (this._classLoader != null && isSetLocal) {
                this._classLoader.addScanListener(this._scanManager);
            }
            Environment.addEnvironmentListener(this, this._classLoader);
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public long getVersion() {
        return this._version.get();
    }

    public InjectScanManager getScanManager() {
        return this._scanManager;
    }

    public void setIsCustomExtension(boolean isCustom) {
        this.getScanManager().setIsCustomExtension(isCustom);
    }

    @Module
    public EventManager getEventManager() {
        return this._eventManager;
    }

    @Module
    public ExtensionManager getExtensionManager() {
        return this._extensionManager;
    }

    private void addContext(String contextClassName) {
        try {
            Class<?> cl = Class.forName(contextClassName);
            Context context = (Context)cl.newInstance();
            this.addContext(context);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public static InjectManager getCurrent() {
        return InjectManager.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    public static InjectManager getCurrent(ClassLoader loader) {
        return _localContainer.get(loader);
    }

    public static InjectManager create() {
        return InjectManager.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InjectManager create(ClassLoader loader) {
        if (loader == null) {
            loader = _systemClassLoader;
        }
        InjectManager manager = null;
        manager = _localContainer.getLevel(loader);
        if (manager != null) {
            return manager;
        }
        EnvironmentClassLoader envLoader = Environment.getEnvironmentClassLoader(loader);
        String id = envLoader != null ? envLoader.getId() : "";
        InjectManager parent = null;
        if (envLoader != null && envLoader != _systemClassLoader) {
            parent = InjectManager.create(envLoader.getParent());
        }
        EnvironmentLocal<InjectManager> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            manager = _localContainer.getLevel(envLoader);
            if (manager != null) {
                return manager;
            }
            manager = new InjectManager(id, parent, envLoader, true);
        }
        manager.init(true);
        return manager;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ClassLoader getJndiClassLoader() {
        return this._jndiClassLoader;
    }

    public boolean isChildManager() {
        return this._isChildManager;
    }

    public void setJndiClassLoader(ClassLoader loader) {
        if (this._parent == null) {
            throw new IllegalStateException();
        }
        this._isChildManager = true;
        this._jndiClassLoader = loader;
    }

    public InjectManager getParent() {
        return this._parent;
    }

    public ApplicationContext getApplicationScope() {
        return this._applicationScope;
    }

    public void addXmlPath(Path path) {
        this._isUpdateNeeded = true;
        this._xmlExtension.addXmlPath(path);
    }

    public void addBeansXmlOverride(Path path, Path beansXmlPath) {
        if (path == null) {
            throw new NullPointerException();
        }
        List<Path> beansXmlPaths = this._beansXMLOverrides.get(path);
        if (beansXmlPaths == null) {
            beansXmlPaths = new ArrayList<Path>();
        }
        beansXmlPaths.add(beansXmlPath);
        this._beansXMLOverrides.put(path, beansXmlPaths);
    }

    public List<Path> getBeansXmlOverride(Path path) {
        return this._beansXMLOverrides.get(path);
    }

    public void setEnableAutoUpdate(boolean isEnable) {
        this._isEnableAutoUpdate = isEnable;
    }

    public void setDeploymentTypes(ArrayList<Class<?>> deploymentList) {
        this._deploymentMap.clear();
        this._deploymentMap.put(CauchoDeployment.class, 0);
        int priority = 2;
        if (!deploymentList.contains(Configured.class)) {
            this._deploymentMap.put(Configured.class, priority);
        }
        for (int i = deploymentList.size() - 1; i >= 0; --i) {
            this._deploymentMap.put(deploymentList.get(i), priority);
        }
    }

    private void addBeanByName(String name, Bean<?> bean) {
        ArrayList<Object> beanList = this._selfNamedBeanMap.get(name);
        if (beanList == null) {
            beanList = new ArrayList();
            this._selfNamedBeanMap.put(name, beanList);
        } else if (!bean.isAlternative() && this._specializedMap.get(bean.getBeanClass()) == null) {
            for (Bean bean2 : beanList) {
                if (bean2.isAlternative() || bean.isAlternative() || bean.getBeanClass().isAnnotationPresent(Specializes.class) && bean2.getBeanClass().isAssignableFrom(bean.getBeanClass()) || bean2.getBeanClass().isAnnotationPresent(Specializes.class) && bean.getBeanClass().isAssignableFrom(bean2.getBeanClass()) || bean instanceof AbstractIntrospectedBean && ((AbstractIntrospectedBean)bean).getAnnotated().isAnnotationPresent(Specializes.class) || bean2 instanceof AbstractIntrospectedBean && ((AbstractIntrospectedBean)bean2).getAnnotated().isAnnotationPresent(Specializes.class)) continue;
                throw new ConfigException(L.l("@Named('{0}') is a duplicate name for\n  {1}\n  {2}", (Object)name, (Object)bean, (Object)bean2));
            }
        }
        beanList.add(bean);
        this._namedBeanMap.remove(name);
        int p = name.indexOf(46);
        if (p > 0) {
            this.addBeanByName(name.substring(0, p), bean);
        }
    }

    private void addBeanByType(Type type, Annotated annotated, Bean<?> bean) {
        if (type == null) {
            return;
        }
        BaseType baseType = this.createSourceBaseType(type);
        this.addBeanByType(baseType, annotated, bean);
    }

    private void addBeanByType(BaseType type, Annotated annotated, Bean<?> bean) {
        Class<?> rawType;
        ArrayList<TypedBean> beanSet;
        if (type == null) {
            return;
        }
        if (this.isSpecialized(bean.getBeanClass())) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(bean + "(" + type + ") added to " + this);
        }
        if ((beanSet = this._selfBeanMap.get(rawType = type.getRawClass())) == null) {
            beanSet = new ArrayList();
            this._selfBeanMap.put(rawType, beanSet);
        }
        this._beanMap.remove(rawType);
        TypedBean typedBean = new TypedBean(type, annotated, bean);
        if (!beanSet.contains(typedBean)) {
            beanSet.add(typedBean);
        }
    }

    protected ArrayList<Bean<?>> findByName(String name) {
        ConcurrentHashMap<String, ArrayList<Bean<?>>> namedBeanMap = this._namedBeanMap;
        if (namedBeanMap == null) {
            return null;
        }
        ArrayList<Object> beanList = this._namedBeanMap.get(name);
        if (beanList == null) {
            beanList = new ArrayList();
            if (this._classLoader != null) {
                this._classLoader.applyVisibleModules(new FillByName(name, beanList));
            }
            this._namedBeanMap.put(name, beanList);
        }
        return beanList;
    }

    private void fillByName(String name, ArrayList<Bean<?>> beanList) {
        ArrayList<Bean<?>> localBeans = this._selfNamedBeanMap.get(name);
        if (localBeans != null) {
            for (Bean<?> bean : localBeans) {
                if (bean.isAlternative() && !this.isEnabled(bean) || this._specializedMap.containsKey(bean.getBeanClass()) || beanList.contains(bean)) continue;
                beanList.add(bean);
            }
        }
    }

    public Conversation createConversation() {
        return (Conversation)this._contextMap.get(ConversationScoped.class);
    }

    public <T> T createTransientObject(Class<T> type) {
        ManagedBeanImpl<T> bean = this.createCachedManagedBean(type);
        this.validate(bean);
        InjectionTarget<T> injectionTarget = bean.getInjectionTarget();
        OwnerCreationalContext<T> env = new OwnerCreationalContext<T>(bean);
        Object instance = injectionTarget.produce(env);
        injectionTarget.inject(instance, env);
        injectionTarget.postConstruct(instance);
        return (T)instance;
    }

    private <T> ManagedBeanImpl<T> createCachedManagedBean(Class<T> type) {
        ManagedBeanImpl<Object> bean = this._transientMap.get(type);
        if (bean == null) {
            bean = this.createManagedBean(type);
            this.validate(bean);
            this._transientMap.putIfAbsent(type, bean);
            bean = this._transientMap.get(type);
        }
        return bean;
    }

    public <T> BeanBuilder<T> createBeanFactory(ManagedBeanImpl<T> managedBean) {
        return new BeanBuilder<T>(managedBean);
    }

    public <T> BeanBuilder<T> createBeanFactory(Class<T> type) {
        ManagedBeanImpl<T> managedBean = this.createManagedBean(type);
        if (managedBean != null) {
            return this.createBeanFactory(managedBean);
        }
        return null;
    }

    public <T> BeanBuilder<T> createBeanFactory(AnnotatedType<T> type) {
        return this.createBeanFactory(this.createManagedBean(type));
    }

    public <T> Bean<T> addSingleton(T obj) {
        BeanBuilder<?> builder = this.createBeanFactory(obj.getClass());
        Bean<?> bean = builder.singleton(obj);
        this.addBeanDiscover(bean);
        return bean;
    }

    @Module
    public void addScope(Class<? extends Annotation> scopeType, boolean isNormal, boolean isPassivating) {
        if (isPassivating && !isNormal) {
            throw new ConfigException(L.l("@{0} must be 'normal' because it's using 'passivating'", (Object)scopeType.getName()));
        }
        this._scopeTypeSet.add(scopeType);
        if (isNormal) {
            this._normalScopeSet.add(scopeType);
        }
        if (isPassivating) {
            this._passivatingScopeSet.add(scopeType);
        }
        if (isNormal) {
            this._scanManager.setIsCustomExtension(true);
        }
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class) || this._scopeTypeSet.contains(annotationType);
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(NormalScope.class) || this._normalScopeSet.contains(annotationType);
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        NormalScope scope = annotationType.getAnnotation(NormalScope.class);
        if (scope != null) {
            return scope.passivating();
        }
        return this._passivatingScopeSet.contains(annotationType);
    }

    @Module
    public void addQualifier(Class<? extends Annotation> qualifier) {
        this._qualifierSet.add(qualifier);
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Qualifier.class) || this._qualifierSet.contains(annotationType);
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(InterceptorBinding.class);
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> bindingType) {
        LinkedHashSet<Annotation> annSet = new LinkedHashSet<Annotation>();
        for (Annotation ann : bindingType.getAnnotations()) {
            annSet.add(ann);
        }
        return annSet;
    }

    @Module
    public void addStereotype(Class<? extends Annotation> annotationType, Annotation[] annotations) {
        LinkedHashSet<Annotation> annSet = new LinkedHashSet<Annotation>();
        for (Annotation ann : annotations) {
            annSet.add(ann);
        }
        this._stereotypeMap.put(annotationType, annSet);
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Stereotype.class) || this._stereotypeMap.get(annotationType) != null;
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        Set<Annotation> mapAnnSet = this._stereotypeMap.get(stereotype);
        if (mapAnnSet != null) {
            return mapAnnSet;
        }
        if (!stereotype.isAnnotationPresent(Stereotype.class)) {
            return null;
        }
        LinkedHashMap annMap = new LinkedHashMap();
        this.addStereotypeDefinitions(annMap, stereotype);
        mapAnnSet = new LinkedHashSet<Annotation>(annMap.values());
        this._stereotypeMap.put(stereotype, mapAnnSet);
        return mapAnnSet;
    }

    private void addStereotypeDefinitions(Map<Class<?>, Annotation> annMap, Class<? extends Annotation> stereotype) {
        for (Annotation ann : stereotype.getAnnotations()) {
            if (annMap.get(ann.annotationType()) != null) continue;
            annMap.put(ann.annotationType(), ann);
        }
        for (Annotation ann : stereotype.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (!annType.isAnnotationPresent(Stereotype.class)) continue;
            this.addStereotypeDefinitions(annMap, annType);
        }
    }

    public BaseType createTargetBaseType(Type type) {
        return this._baseTypeFactory.createForTarget(type);
    }

    public BaseType createSourceBaseType(Type type) {
        return this._baseTypeFactory.createForSource(type);
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        ReflectionAnnotatedType<T> annType = ReflectionAnnotatedFactory.introspectType(cl);
        return annType;
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        InjectionTargetBuilder<T> target = new InjectionTargetBuilder<T>(this, type);
        return target;
    }

    public <T> InjectionTarget<T> discoverInjectionTarget(AnnotatedType<T> type) {
        InjectionTarget<T> target = this.createInjectionTarget(type);
        return this.getExtensionManager().processInjectionTarget(target, type);
    }

    public <T> InjectionTarget<T> createInjectionTarget(Class<T> type) {
        try {
            ReflectionAnnotatedType<T> annType = ReflectionAnnotatedFactory.introspectType(type);
            return this.createInjectionTarget(annType);
        }
        catch (Exception e) {
            throw ConfigException.createConfig(e);
        }
    }

    public <T> InjectionTarget<T> discoverInjectionTarget(Class<T> type) {
        this.fireBeforeBeanDiscovery();
        try {
            ReflectionAnnotatedType<T> annType = ReflectionAnnotatedFactory.introspectType(type);
            AnnotatedType<T> enhAnnType = this.getExtensionManager().processAnnotatedType(annType);
            if (enhAnnType != null) {
                return this.discoverInjectionTarget(enhAnnType);
            }
            return this.discoverInjectionTarget(annType);
        }
        catch (Exception e) {
            throw ConfigException.createConfig(e);
        }
    }

    public <T, X> void addObserver(ObserverMethod<T> observer, AnnotatedMethod<X> method) {
        this._extensionManager.processObserver(observer, method);
        this.getEventManager().addObserver(observer);
    }

    public <T> ManagedBeanImpl<T> createManagedBean(AnnotatedType<T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        ManagedBeanImpl<T> bean = new ManagedBeanImpl<T>(this, type, false);
        bean.introspect();
        return bean;
    }

    public <T> ManagedBeanImpl<T> createManagedBean(Class<T> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        AnnotatedType<T> type = this.createAnnotatedType(cl);
        return this.createManagedBean(type);
    }

    public <T> ManagedBeanImpl<T> discoverManagedBean(Class<T> cl) {
        this.fireBeforeBeanDiscovery();
        if (cl == null) {
            throw new NullPointerException();
        }
        AnnotatedType<T> type = this.createAnnotatedType(cl);
        AnnotatedType<T> extType = this.getExtensionManager().processAnnotatedType(type);
        if (extType != null) {
            return this.createManagedBean(extType);
        }
        return this.createManagedBean(type);
    }

    public <T> void addBeanDiscover(Bean<T> bean) {
        if (bean == null) {
            throw new NullPointerException(L.l("null bean passed to addBean"));
        }
        this.addBeanDiscover(bean, null);
    }

    public <T> void addBean(Bean<T> bean) {
        if (bean == null) {
            throw new NullPointerException(L.l("null bean passed to addBean"));
        }
        this.addBean(bean, (Annotated)null);
    }

    @Module
    public <T> void addBeanDiscover(Bean<T> bean, Annotated ann) {
        this.fireBeforeBeanDiscovery();
        if (ann == null) {
            if (bean instanceof AbstractBean) {
                ann = ((AbstractBean)bean).getAnnotatedType();
            } else if (bean instanceof InjectionPointStandardBean) {
                ann = ((InjectionPointStandardBean)bean).getAnnotated();
            } else if (bean instanceof InterceptorBean) {
                ann = ((InterceptorBean)bean).getAnnotatedType();
            }
        }
        if (bean instanceof ManagedBeanImpl) {
            ManagedBeanImpl managedBean = (ManagedBeanImpl)bean;
            bean = this.getExtensionManager().processManagedBean(managedBean, ann);
        } else if (bean instanceof ProducesMethodBean) {
            ProducesMethodBean methodBean = (ProducesMethodBean)bean;
            bean = this.getExtensionManager().processProducerMethod(methodBean);
        } else if (bean instanceof ProducesFieldBean) {
            ProducesFieldBean fieldBean = (ProducesFieldBean)bean;
            bean = this.getExtensionManager().processProducerField(fieldBean);
        } else {
            bean = this.getExtensionManager().processBean(bean, ann);
        }
        this.addBean((Bean<T>)bean, ann);
    }

    @Module
    public <T> void addBean(Bean<T> bean, Annotated ann) {
        this.addBeanImpl(bean, ann);
    }

    public <T> void addBean(Bean<T> bean, ProcessBean<T> process) {
        bean = this.getExtensionManager().processBean(bean, process);
        if (bean != null) {
            this.addBeanImpl(bean, process.getAnnotated());
        }
    }

    public <T> void addBeanImpl(Bean<T> bean, Annotated ann) {
        PassivationCapable pass;
        if (bean == null) {
            return;
        }
        if (this._specializedMap.containsKey(bean.getBeanClass())) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " add bean " + bean);
        }
        this._isAfterValidationNeeded = true;
        this._version.incrementAndGet();
        if (bean instanceof javax.enterprise.inject.spi.Interceptor) {
            this.addInterceptor((javax.enterprise.inject.spi.Interceptor)bean);
            return;
        }
        if (bean instanceof Decorator) {
            this.addDecorator((Decorator)bean);
            return;
        }
        this._beanSet.add(bean);
        for (Type type : bean.getTypes()) {
            this.addBeanByType(type, ann, bean);
        }
        if (bean.getName() != null) {
            this.addBeanByName(bean.getName(), bean);
        }
        boolean isNullable = bean.isNullable();
        if (bean instanceof PassivationCapable && (pass = (PassivationCapable)bean).getId() != null) {
            this._selfPassivationBeanMap.put(pass.getId(), bean);
        }
        this.clearBeanCache();
        this.registerJmx(bean);
    }

    public ResourceProgramManager getResourceManager() {
        return this._resourceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJmx(Bean<?> bean) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    void addGlobalProgram(ConfigProgram program) {
        if (program != null) {
            if (this._isChildManager) {
                this._parent.addGlobalProgram(program);
            } else {
                this._globalProgram.add(program);
            }
        }
    }

    public Set<Bean<?>> getBeans(String name) {
        ArrayList<Bean<?>> beanList = this.findByName(name);
        if (beanList != null) {
            return new LinkedHashSet(beanList);
        }
        return new LinkedHashSet();
    }

    @Module
    public AtomicBoolean getStaticMemberBoolean(Member member) {
        AtomicBoolean flag = this._staticMemberMap.get(member);
        if (flag == null) {
            flag = new AtomicBoolean();
            this._staticMemberMap.putIfAbsent(member, flag);
            flag = this._staticMemberMap.get(member);
        }
        return flag;
    }

    @Module
    public ReferenceFactory<?> getReferenceFactory(String name) {
        this.update();
        ReferenceFactory refFactory = this._namedRefFactoryMap.get(name);
        if (refFactory == null) {
            Bean bean;
            Set beanSet = this.getBeans(name);
            if (beanSet != null && beanSet.size() > 0 && name.equals((bean = this.resolve(beanSet)).getName()) && (refFactory = this.getReferenceFactory(bean)) instanceof DependentReferenceFactoryImpl) {
                refFactory = new DependentElReferenceFactoryImpl((ManagedBeanImpl)bean);
            }
            if (refFactory == null) {
                refFactory = new UnresolvedReferenceFactory();
            }
            this._namedRefFactoryMap.put(name, refFactory);
        }
        return refFactory;
    }

    public Set<Bean<?>> getBeans(Type type, Annotation ... qualifiers) {
        Set<Bean<?>> set;
        if (qualifiers != null) {
            for (int i = 0; i < qualifiers.length; ++i) {
                for (int j = i + 1; j < qualifiers.length; ++j) {
                    if (qualifiers[i].annotationType() != qualifiers[j].annotationType()) continue;
                    throw new IllegalArgumentException(L.l("getBeans may not have a duplicate qualifier '{0}'", (Object)qualifiers[i]));
                }
            }
        }
        if ((set = this.resolve(type, qualifiers, null)) != null) {
            return set;
        }
        return new HashSet();
    }

    private Set<Bean<?>> getBeans(Type type, Set<Annotation> qualifierSet) {
        Annotation[] qualifiers = new Annotation[qualifierSet.size()];
        qualifierSet.toArray(qualifiers);
        return this.getBeans(type, qualifiers);
    }

    private Set<Bean<?>> resolve(Type type, Annotation[] bindings, InjectionPoint ip) {
        BaseType baseType;
        if (type == null) {
            throw new NullPointerException();
        }
        if (bindings == null || bindings.length == 0) {
            if (Object.class.equals((Object)type)) {
                return this.resolveAllBeans();
            }
            bindings = DEFAULT_ANN;
        }
        if ((baseType = this.createTargetBaseType(type)).isVariable()) {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid getBeans type because it's a type variable.", (Object)baseType));
        }
        return this.resolveRec(baseType, bindings, ip);
    }

    private Set<Bean<?>> resolveRec(BaseType baseType, Annotation[] qualifiers, InjectionPoint ip) {
        Set<Bean<?>> beans;
        WebComponent component = this.getWebComponent(baseType);
        if (component != null && (beans = component.resolve(baseType, qualifiers)) != null && beans.size() > 0) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " bind(" + baseType.getSimpleName() + "," + this.toList(qualifiers) + ") -> " + beans);
            }
            return beans;
        }
        if (New.class.equals(qualifiers[0].annotationType())) {
            New newQualifier = (New)qualifiers[0];
            HashSet set = new HashSet();
            Class<?> newClass = newQualifier.value();
            if (newClass == null || newClass.equals(Void.TYPE)) {
                newClass = baseType.getRawClass();
            }
            ReflectionAnnotatedType<?> ann = ReflectionAnnotatedFactory.introspectType(newClass);
            NewBean newBean = new NewBean(this, baseType.getRawClass(), ann);
            newBean.introspect();
            if (component != null) {
                component.addComponent(baseType, null, newBean);
            }
            set.add(newBean);
            return set;
        }
        Class<?> rawType = baseType.getRawClass();
        if (Instance.class.equals(rawType) || Provider.class.equals(rawType)) {
            BaseType[] param = baseType.getParameters();
            Class beanType = param.length > 0 ? param[0].getRawClass() : Object.class;
            HashSet set = new HashSet();
            set.add(new InstanceBeanImpl(this, (Type)((Object)beanType), qualifiers, ip));
            return set;
        }
        if (Event.class.equals(rawType)) {
            if (baseType.isGenericRaw()) {
                throw new InjectionException(L.l("Event must have parameters because a non-parameterized Event would observe no events."));
            }
            BaseType[] param = baseType.getParameters();
            Class beanType = param.length > 0 ? param[0].getRawClass() : Object.class;
            LinkedHashSet<Annotation> qualifierSet = new LinkedHashSet<Annotation>();
            for (Annotation ann : qualifiers) {
                qualifierSet.add(ann);
            }
            qualifierSet.add((Annotation)AnyLiteral.ANY);
            HashSet set = new HashSet();
            set.add(new EventBeanImpl(this, (Type)((Object)beanType), (HashSet<Annotation>)qualifierSet));
            return set;
        }
        if (this._parent != null) {
            return this._parent.resolveRec(baseType, qualifiers, ip);
        }
        for (Annotation ann : qualifiers) {
            if (ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            throw new IllegalArgumentException(L.l("'{0}' is an invalid binding annotation because it does not have a @Qualifier meta-annotation", (Object)ann));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " bind(" + baseType.getSimpleName() + "," + this.toList(qualifiers) + ") -> none");
        }
        return null;
    }

    public Set<Bean<?>> resolveAllByType(Class<?> type) {
        Annotation[] bindings = new Annotation[]{};
        WebComponent component = this.getWebComponent(this.createTargetBaseType(type));
        if (component != null) {
            Set<Bean<?>> beans = component.resolve(type, bindings);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " bind(" + InjectManager.getSimpleName(type) + "," + this.toList(bindings) + ") -> " + beans);
            }
            if (beans != null && beans.size() > 0) {
                return beans;
            }
        }
        if (this._parent != null) {
            return this._parent.resolveAllByType(type);
        }
        return null;
    }

    private WebComponent getWebComponent(BaseType baseType) {
        if (this._beanMap == null) {
            return null;
        }
        Class<?> rawClass = baseType.getRawClass();
        String className = rawClass.getName();
        WebComponent beanSet = this._beanMap.get(className);
        if (beanSet == null) {
            HashSet<TypedBean> typedBeans = new HashSet<TypedBean>();
            if (this._classLoader != null) {
                FillByType fillByType = new FillByType(baseType, typedBeans, this);
                this._classLoader.applyVisibleModules(fillByType);
            }
            beanSet = new WebComponent(this, className);
            this._beanMap.put(className, beanSet);
            for (TypedBean typedBean : typedBeans) {
                if (this.getDeploymentPriority(typedBean.getBean()) < 0) continue;
                this._pendingValidationBeans.add(typedBean.getBean());
                beanSet.addComponent(typedBean.getType(), typedBean.getAnnotated(), typedBean.getBean());
            }
        }
        return beanSet;
    }

    private void clearBeanCache() {
        this._namedRefFactoryMap.clear();
        this._beanMap.clear();
    }

    private void fillByType(BaseType baseType, HashSet<TypedBean> beanSet, InjectManager beanManager) {
        ArrayList<TypedBean> localBeans;
        Class<?> rawClass = baseType.getRawClass();
        InjectScanClass scanClass = this._scanManager.getScanClass(rawClass.getName());
        if (scanClass != null && !scanClass.isRegistered()) {
            this.discoverScanClass(scanClass);
            this.processPendingAnnotatedTypes();
        }
        if ((localBeans = this._selfBeanMap.get(rawClass)) != null) {
            for (TypedBean bean : localBeans) {
                if (this.getDeploymentPriority(bean.getBean()) < 0 || bean.isModulePrivate() && this != beanManager) continue;
                beanSet.add(bean);
            }
        }
    }

    public <X> Bean<X> getMostSpecializedBean(Bean<X> bean) {
        throw new UnsupportedOperationException();
    }

    @Module
    public boolean isSpecialized(Class<?> beanClass) {
        return this._specializedMap.get(beanClass) != null;
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        Bean<X> bestBean = null;
        Bean<X> secondBean = null;
        int bestPriority = -1;
        boolean isSpecializes = false;
        for (Bean<X> bean : beans) {
            boolean isSecondProduces;
            int priority;
            if (this._specializedMap.get(bean.getBeanClass()) != null) continue;
            if (bean instanceof AbstractIntrospectedBean && ((AbstractIntrospectedBean)bean).getAnnotated().isAnnotationPresent(Specializes.class)) {
                if (!isSpecializes) {
                    bestPriority = -1;
                    bestBean = null;
                    secondBean = null;
                    isSpecializes = true;
                }
            } else if (isSpecializes) continue;
            if ((priority = this.getDeploymentPriority(bean)) < 0) continue;
            if (bestPriority < priority) {
                bestBean = bean;
                secondBean = null;
                bestPriority = priority;
                continue;
            }
            if (bestPriority != priority) continue;
            secondBean = bean;
            boolean isFirstProduces = bestBean instanceof ProducesMethodBean || bestBean instanceof ProducesFieldBean;
            boolean bl = isSecondProduces = secondBean instanceof ProducesMethodBean || secondBean instanceof ProducesFieldBean;
            if (isFirstProduces && !isSecondProduces) {
                secondBean = null;
                continue;
            }
            if (!isSecondProduces || isFirstProduces) continue;
            bestBean = bean;
            secondBean = null;
        }
        if (secondBean == null) {
            return bestBean;
        }
        throw this.ambiguousException(beans, bestPriority);
    }

    private void validate(Type type) {
        BaseType baseType = this.createTargetBaseType(type);
        WebComponent comp = this.getWebComponent(baseType);
    }

    private void validate(Bean<?> bean) {
        InjectEnvironmentBean envBean;
        if (bean.isAlternative() && !this.isEnabled(bean)) {
            return;
        }
        boolean isPassivating = this.isPassivatingScope(bean.getScope());
        if (bean instanceof InjectEnvironmentBean && (envBean = (InjectEnvironmentBean)bean).getCdiManager() != this) {
            envBean.getCdiManager().validate(bean);
            return;
        }
        if (bean instanceof CdiStatefulBean) {
            isPassivating = true;
        }
        if (!(bean instanceof ManagedBeanImpl) || ((ManagedBeanImpl)bean).validate()) {
            // empty if block
        }
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            ReferenceFactory<?> factory = this.validateInjectionPoint(ip);
            if (ip.isDelegate() && !(bean instanceof Decorator)) {
                throw new ConfigException(L.l("'{0}' is an invalid delegate because {1} is not a Decorator.", (Object)ip.getMember().getName(), (Object)bean));
            }
            RuntimeException exn = this.validatePassivation(ip);
            if (exn == null || factory.isProducer()) continue;
            throw exn;
        }
        if (this.isNormalScope(bean.getScope())) {
            this.validateNormal(bean);
        }
    }

    private RuntimeException validatePassivation(InjectionPoint ip) {
        Bean bean = ip.getBean();
        if (bean == null) {
            return null;
        }
        boolean isPassivating = this.isPassivatingScope(bean.getScope());
        if (bean instanceof CdiStatefulBean || bean.getBeanClass().isAnnotationPresent(Stateful.class)) {
            isPassivating = true;
        }
        if (isPassivating && !ip.isTransient()) {
            Class<?> cl = this.getRawClass(ip.getType());
            Bean prodBean = this.resolve(this.getBeans(ip.getType(), ip.getQualifiers()));
            if (!(cl.isInterface() || cl.isPrimitive() || Serializable.class.isAssignableFrom(cl) || this.isPassivationCapable(prodBean))) {
                Object exn = this.isProduct(prodBean) ? new IllegalProductException(L.l("'{0}' is an invalid injection point of type {1} because it's not serializable for {2}", (Object)ip.getMember().getName(), (Object)ip.getType(), (Object)bean)) : new ConfigException(L.l("'{0}.{1}' is an invalid injection point of type {2} ({3}) because it's not serializable for {4}", (Object)bean.getBeanClass().getName(), (Object)ip.getMember().getName(), (Object)ip.getType(), (Object)prodBean, (Object)bean));
                return exn;
            }
        }
        return null;
    }

    private boolean isPassivationCapable(Bean<?> bean) {
        if (this.isNormalScope(bean.getScope())) {
            return true;
        }
        return bean instanceof PassivationCapable && ((PassivationCapable)bean).getId() != null;
    }

    private boolean isProduct(Bean<?> bean) {
        return bean instanceof ProducesFieldBean || bean instanceof ProducesMethodBean;
    }

    private Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        BaseType baseType = this.createSourceBaseType(type);
        return baseType.getRawClass();
    }

    private void validateNormal(Bean<?> bean) {
        Annotated ann = null;
        if (bean instanceof AbstractBean) {
            AbstractBean absBean = (AbstractBean)bean;
            ann = absBean.getAnnotated();
        }
        if (ann == null) {
            return;
        }
        Type baseType = ann.getBaseType();
        Class<?> cl = this.createTargetBaseType(baseType).getRawClass();
        if (cl.isInterface()) {
            return;
        }
        int modifiers = cl.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because it's a final class, for {2}.", (Object)cl.getSimpleName(), (Object)bean.getScope().getSimpleName(), (Object)bean));
        }
        Constructor<?> ctor = null;
        for (Constructor<?> constructor : cl.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length > 0 && !constructor.isAnnotationPresent(Inject.class)) continue;
            if (Modifier.isPrivate(constructor.getModifiers())) {
                throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because its constructor is private for {2}.", (Object)cl.getSimpleName(), (Object)bean.getScope().getSimpleName(), (Object)bean));
            }
            ctor = constructor;
        }
        if (ctor == null) {
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because it doesn't have a zero-arg constructor for {2}.", (Object)cl.getName(), (Object)bean.getScope().getSimpleName(), (Object)bean));
        }
        for (Executable executable : cl.getMethods()) {
            if (((Method)executable).getDeclaringClass() == Object.class || !Modifier.isFinal(((Method)executable).getModifiers())) continue;
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because {2} is a final method for {3}.", (Object)cl.getSimpleName(), (Object)bean.getScope().getSimpleName(), (Object)((Method)executable).getName(), (Object)bean));
        }
        for (AccessibleObject accessibleObject : cl.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Modifier.isPublic(((Field)accessibleObject).getModifiers())) continue;
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because {2} is a public field for {3}.", (Object)cl.getSimpleName(), (Object)bean.getScope().getSimpleName(), (Object)((Field)accessibleObject).getName(), (Object)bean));
        }
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            if (!ip.getType().equals(InjectionPoint.class)) continue;
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because '{2}' injects an InjectionPoint for {3}.", (Object)cl.getSimpleName(), (Object)bean.getScope().getSimpleName(), (Object)ip.getMember().getName(), (Object)bean));
        }
    }

    public void validate(InjectionPoint ij) {
        this.validateInjectionPoint(ij);
    }

    public ReferenceFactory<?> validateInjectionPoint(InjectionPoint ij) {
        block7: {
            try {
                if (ij.isDelegate()) {
                    if (!(ij.getBean() instanceof Decorator)) {
                        throw new ConfigException(L.l("'{0}' is an invalid @Delegate because {1} is not a decorator", (Object)ij.getMember().getName(), (Object)ij.getBean()));
                    }
                    break block7;
                }
                return this.getReferenceFactory(ij);
            }
            catch (AmbiguousResolutionException e) {
                throw new AmbiguousResolutionException(L.l("{0}.{1}: {2}", (Object)ij.getMember().getDeclaringClass().getName(), (Object)ij.getMember().getName(), (Object)e.getMessage()), (Throwable)e);
            }
            catch (UnsatisfiedResolutionException e) {
                throw new UnsatisfiedResolutionException(L.l("{0}.{1}: {2}", (Object)ij.getMember().getDeclaringClass().getName(), (Object)ij.getMember().getName(), (Object)e.getMessage()), (Throwable)e);
            }
            catch (IllegalProductException e) {
                throw new IllegalProductException(L.l("{0}.{1}: {2}", (Object)ij.getMember().getDeclaringClass().getName(), (Object)ij.getMember().getName(), (Object)e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                throw new InjectionException(L.l("{0}.{1}: {2}", (Object)ij.getMember().getDeclaringClass().getName(), (Object)ij.getMember().getName(), (Object)e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public int getDeploymentPriority(Bean<?> bean) {
        Set stereotypes;
        int priority = 1;
        if (bean.isAlternative()) {
            priority = -1;
            Integer value = this.getPriority(bean.getBeanClass());
            if (value != null) {
                priority = value;
            }
        }
        if ((stereotypes = bean.getStereotypes()) != null) {
            for (Class annType : stereotypes) {
                Integer value = this._deploymentMap.get(annType);
                if (value != null) {
                    if (priority >= value) continue;
                    priority = value;
                    continue;
                }
                if (!annType.isAnnotationPresent(Alternative.class) || priority != 1) continue;
                priority = -1;
            }
        }
        if (priority < 0) {
            return priority;
        }
        if (bean instanceof AbstractBean) {
            AbstractBean absBean = (AbstractBean)bean;
            if (absBean.getBeanManager() == this) {
                priority += 1000000;
            }
        } else {
            priority += 1000000;
        }
        return priority;
    }

    private Integer getPriority(Class<?> cl) {
        Integer value = this._deploymentMap.get(cl);
        if (value != null) {
            return value;
        }
        if (this._parent != null) {
            return this._parent.getPriority(cl);
        }
        return null;
    }

    private Set<Bean<?>> resolveAllBeans() {
        LinkedHashSet beans = new LinkedHashSet();
        for (ArrayList<TypedBean> comp : this._selfBeanMap.values()) {
            for (TypedBean typedBean : comp) {
                beans.add(typedBean.getBean());
            }
        }
        return beans;
    }

    public <T> CreationalContext<T> createCreationalContext(Contextual<T> bean) {
        return new OwnerCreationalContext<T>(bean);
    }

    public <T> T getReference(Class<T> type, Annotation ... qualifiers) {
        Set beans = this.getBeans(type, qualifiers);
        Bean bean = this.resolve(beans);
        if (bean == null) {
            return null;
        }
        return (T)this.getReference(bean);
    }

    public <T> T getReference(Bean<T> bean) {
        ReferenceFactory factory = this.getReferenceFactory(bean);
        if (factory != null) {
            return factory.create(null, null, null);
        }
        return null;
    }

    public <T> T findReference(Bean<T> bean) {
        Context context = this.getContext(bean.getScope());
        if (context != null) {
            return (T)context.get(bean);
        }
        return null;
    }

    public <T> T getReference(Bean<T> bean, CreationalContextImpl<?> parentEnv) {
        ReferenceFactory factory = this.getReferenceFactory(bean);
        return factory.create(null, parentEnv, null);
    }

    public <T> T getReference(String name) {
        Set beans = this.getBeans(name);
        Bean bean = this.resolve(beans);
        if (bean == null) {
            return null;
        }
        ReferenceFactory factory = this.getReferenceFactory(bean);
        return (T)factory.create(null, null, null);
    }

    public <T> T getReference(String name, CreationalContextImpl parentEnv) {
        Set beans = this.getBeans(name);
        Bean bean = this.resolve(beans);
        if (bean == null) {
            return null;
        }
        ReferenceFactory factory = this.getReferenceFactory(bean);
        return (T)factory.create(null, parentEnv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReference(Bean<?> bean, Type type, CreationalContext<?> createContext) {
        ReferenceFactory<?> factory;
        ClassLoader oldLoader;
        Thread thread;
        block4: {
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.getClassLoader());
                factory = this.getReferenceFactory(bean);
                if (factory == null) {
                    throw new IllegalStateException(L.l("{0} is an uninstantiable bean", (Object)bean));
                }
                if (!(createContext instanceof CreationalContextImpl)) break block4;
                Object obj = factory.create((CreationalContextImpl)createContext, null, null);
                Object var9_9 = null;
                thread.setContextClassLoader(oldLoader);
                return obj;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        Object obj = factory.create(null, null, null);
        Object var9_10 = null;
        thread.setContextClassLoader(oldLoader);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getInstanceForProxy(Bean<T> bean) {
        Object object;
        Object value;
        CreationalContextImpl<?> oldEnv = this._proxyThreadLocal.get();
        if (oldEnv != null && (value = oldEnv.get(bean)) != null) {
            return value;
        }
        try {
            OwnerCreationalContext<T> env = new OwnerCreationalContext<T>(bean, oldEnv);
            this._proxyThreadLocal.set(env);
            object = value = bean.create(env);
            Object var7_6 = null;
            this._proxyThreadLocal.set(oldEnv);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._proxyThreadLocal.set(oldEnv);
            throw throwable;
        }
        return object;
    }

    public <T> ReferenceFactory<T> getReferenceFactory(Bean<T> bean) {
        if (bean == null) {
            return null;
        }
        ReferenceFactory<Object> factory = this._refFactoryMap.get(bean);
        if (factory == null) {
            factory = this.createReferenceFactory(bean);
            this._refFactoryMap.put(bean, factory);
            factory.validate();
        }
        return factory;
    }

    private <T> ReferenceFactory<T> createReferenceFactory(Bean<T> bean) {
        Class scopeType = bean.getScope();
        if (InjectionPoint.class.equals((Object)bean.getBeanClass())) {
            return new InjectionPointReferenceFactory();
        }
        if (Dependent.class == scopeType) {
            if (bean instanceof ManagedBeanImpl) {
                return new DependentReferenceFactoryImpl((ManagedBeanImpl)bean);
            }
            return new DependentReferenceFactory<T>(bean);
        }
        if (scopeType == null) {
            throw new IllegalStateException("Unknown scope for " + bean);
        }
        InjectManager ownerManager = bean instanceof AbstractBean ? ((AbstractBean)bean).getBeanManager() : this;
        Context context = ownerManager.getContextImpl(scopeType);
        if (context == null) {
            throw new InjectionException(L.l("Bean has an unknown scope '{0}' for bean {1}", (Object)scopeType, (Object)bean));
        }
        if (this.isNormalScope(scopeType) && bean instanceof ScopeAdapterBean) {
            ScopeAdapterBean scopeAdapterBean = (ScopeAdapterBean)bean;
            return new NormalContextReferenceFactory<T>(bean, scopeAdapterBean, context);
        }
        return new ContextReferenceFactory<T>(bean, context);
    }

    public <T> ReferenceFactory<T> createNormalInstanceFactory(Bean<T> bean) {
        Class scopeType = bean.getScope();
        if (!this.isNormalScope(scopeType)) {
            throw new IllegalStateException(L.l("{0} is an invalid normal scope for {1}", (Object)scopeType, (Object)bean));
        }
        InjectManager ownerManager = bean instanceof AbstractBean ? ((AbstractBean)bean).getBeanManager() : this;
        Context context = ownerManager.getContextImpl(scopeType);
        if (context == null) {
            throw new InjectionException(L.l("Bean has an unknown scope '{0}' for bean {1}", (Object)scopeType, (Object)bean));
        }
        return new NormalInstanceReferenceFactory<T>(bean, context);
    }

    public RuntimeException unsatisfiedException(Type type, Annotation[] qualifiers) {
        WebComponent component = this.getWebComponent(this.createTargetBaseType(type));
        if (component == null) {
            throw new UnsatisfiedResolutionException(L.l("Can't find a bean for '{0}' because no beans implementing that class have been registered with the injection manager {1}.", (Object)type, (Object)this));
        }
        ArrayList<Bean<?>> enabledList = component.getEnabledBeanList();
        if (enabledList.size() == 0) {
            throw new UnsatisfiedResolutionException(L.l("Can't find a bean for '{0}' because no beans implementing that class have been registered with the injection manager {1}.", (Object)type, (Object)this));
        }
        return new UnsatisfiedResolutionException(L.l("Can't find a bean for '{0}' because no beans match the type and qualifiers {1}.\nBeans:{2}", (Object)type, (Object)this.toList(qualifiers), (Object)this.listToLines(enabledList)));
    }

    private String listToLines(List<?> list) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            lines.add(list.get(i).toString());
        }
        Collections.sort(lines);
        for (String line : lines) {
            for (String split : line.split("\n")) {
                sb.append("\n    ").append(split);
            }
        }
        return sb.toString();
    }

    private ArrayList<Annotation> toList(Annotation[] annList) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        if (annList != null) {
            for (Annotation ann : annList) {
                list.add(ann);
            }
        }
        return list;
    }

    InjectionPointHandler getInjectionPointHandler(AnnotatedField<?> field) {
        for (Annotation ann : field.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            InjectionPointHandler handler = this._injectionMap.get(annType);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    InjectionPointHandler getInjectionPointHandler(AnnotatedMethod<?> method) {
        for (Annotation ann : method.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            InjectionPointHandler handler = this._injectionMap.get(annType);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public InjectionPointHandler getInjectionPointHandler(Class<? extends Annotation> annType) {
        return this._injectionMap.get(annType);
    }

    public Object getInjectableReference(InjectionPoint ij, CreationalContext<?> parentCxt) {
        CreationalContextImpl parentEnv = null;
        if (parentCxt instanceof CreationalContextImpl) {
            parentEnv = (CreationalContextImpl)parentCxt;
        }
        if (InjectionPoint.class.equals((Object)ij.getType()) && parentEnv != null) {
            return parentEnv.findInjectionPoint();
        }
        ReferenceFactory<?> factory = this.getReferenceFactory(ij);
        return factory.create(null, parentEnv, ij);
    }

    public ReferenceFactory<?> getReferenceFactory(InjectionPoint ij) {
        if (ij.isDelegate()) {
            return new DelegateReferenceFactory();
        }
        if (ij.getType().equals(InjectionPoint.class)) {
            return new InjectionPointReferenceFactory();
        }
        Type type = ij.getType();
        Set qualifiers = ij.getQualifiers();
        ReferenceFactory<?> factory = this.getReferenceFactory(type, qualifiers, ij);
        RuntimeException exn = this.validatePassivation(ij);
        if (exn != null) {
            if (factory.isProducer()) {
                return new ErrorReferenceFactory(exn);
            }
            throw exn;
        }
        return factory;
    }

    public ReferenceFactory<?> getReferenceFactory(Type type, Set<Annotation> qualifiers, InjectionPoint ij) {
        if (ij != null && ij.isDelegate()) {
            return new DelegateReferenceFactory();
        }
        Bean<?> bean = this.resolveByInjectionPoint(type, qualifiers, ij);
        return this.getReferenceFactory(bean);
    }

    private Bean<?> resolveByInjectionPoint(Type type, Set<Annotation> qualifierSet, InjectionPoint ij) {
        BaseType baseType;
        Annotation[] qualifiers;
        if (qualifierSet != null && qualifierSet.size() > 0) {
            qualifiers = new Annotation[qualifierSet.size()];
            qualifierSet.toArray(qualifiers);
            if (qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
                New newQualifier = (New)qualifiers[0];
                return this.createNewBean(type, newQualifier);
            }
        } else {
            qualifiers = new Annotation[]{DefaultLiteral.DEFAULT};
        }
        if ((baseType = this.createTargetBaseType(type)).isGenericVariable()) {
            throw new InjectionException(L.l("'{0}' is an invalid type for injection because it's a variable generic type.\n  {1}", (Object)baseType, (Object)ij));
        }
        Set set = this.resolveRec(baseType, qualifiers, ij);
        if (set == null || set.size() == 0) {
            if (InjectionPoint.class.equals((Object)type)) {
                return new InjectionPointBean(this, ij);
            }
            throw this.unsatisfiedException(type, qualifiers);
        }
        Bean bean = this.resolve(set);
        if (bean != null && type instanceof Class && ((Class)type).isPrimitive() && bean.isNullable()) {
            throw new InjectionException(L.l("'{0}' cannot be injected because it's a primitive with {1}", (Object)type, (Object)bean));
        }
        return bean;
    }

    private <T> Bean<?> createNewBean(Type type, New newQualifier) {
        Bean<?> bean;
        Class<?> newClass = newQualifier.value();
        if (newClass == null || Void.TYPE.equals(newClass) || New.class.equals((Object)newClass)) {
            BaseType baseType = this.createTargetBaseType(type);
            newClass = baseType.getRawClass();
        }
        if ((bean = this._newBeanMap.get(newClass)) == null) {
            ReflectionAnnotatedType<?> annType = ReflectionAnnotatedFactory.introspectType(newClass);
            BaseType newType = this.createSourceBaseType(type);
            NewBean newBean = new NewBean(this, newType.getRawClass(), annType);
            newBean.introspect();
            this._newBeanMap.put(type, bean);
            bean = newBean;
        }
        return bean;
    }

    private <X> AmbiguousResolutionException ambiguousException(Set<Bean<? extends X>> beanSet, int bestPriority) {
        ArrayList<String> matchBeans = new ArrayList<String>();
        for (Bean<X> bean : beanSet) {
            int priority = this.getDeploymentPriority(bean);
            if (priority != bestPriority) continue;
            matchBeans.add(this.toDisplayString(bean));
        }
        return new AmbiguousResolutionException(L.l("Too many beans match, because they all have equal precedence.  Beans:{0}\nfor {1}. You may need to use the @Alternative or <alternatives> to select one.", (Object)this.listToLines(matchBeans), (Object)this));
    }

    private String toDisplayString(Bean<?> bean) {
        if (bean instanceof AbstractBean) {
            AbstractBean absBean = (AbstractBean)bean;
            return absBean.toDisplayString();
        }
        return String.valueOf(bean);
    }

    public ELResolver getELResolver() {
        return this._elResolver;
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return new CandiExpressionFactory(expressionFactory);
    }

    public void addContext(Context context) {
        Class scopeType = context.getScope();
        Context oldContext = this._contextMap.get(scopeType);
        if (oldContext == null) {
            this._contextMap.put(context.getScope(), context);
        } else {
            IllegalStateException exn = new IllegalStateException(L.l("{0} is an invalid new context because @{1} is already registered as a scope", (Object)context, (Object)scopeType.getName()));
            this._contextMap.put(context.getScope(), new ErrorContext(exn, context));
        }
    }

    public void replaceContext(Context context) {
        this._contextMap.put(context.getScope(), context);
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        Context context = this._contextMap.get(scopeType);
        if (context != null && context.isActive()) {
            return context;
        }
        if (context instanceof ErrorContext) {
            ErrorContext cxt = (ErrorContext)context;
            throw cxt.getException();
        }
        throw new ContextNotActiveException(L.l("'@{0}' is not an active Java Injection context.", (Object)scopeType.getName()));
    }

    public Context getContextImpl(Class<? extends Annotation> scopeType) {
        return this._contextMap.get(scopeType);
    }

    public Bean<?> getPassivationCapableBean(String id) {
        return this._selfPassivationBeanMap.get(id);
    }

    public Annotation[] getQualifiers(Set<Annotation> annotations) {
        ArrayList<Annotation> bindingList = new ArrayList<Annotation>();
        for (Annotation ann : annotations) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            bindingList.add(ann);
        }
        Annotation[] bindings = new Annotation[bindingList.size()];
        bindingList.toArray(bindings);
        return bindings;
    }

    public Annotation[] getQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> bindingList = new ArrayList<Annotation>();
        for (Annotation ann : annotations) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            bindingList.add(ann);
        }
        Annotation[] bindings = new Annotation[bindingList.size()];
        bindingList.toArray(bindings);
        return bindings;
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " fireEvent " + event);
        }
        this.getEventManager().fireEvent(event, qualifiers);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        return this.getEventManager().resolveObserverMethods(event, qualifiers);
    }

    public <X> BeanManager addInterceptorClass(Class<?> interceptorClass) {
        this._interceptorClassList.add(interceptorClass);
        return this;
    }

    private <X> InterceptorEntry<X> addInterceptor(javax.enterprise.inject.spi.Interceptor<X> interceptor) {
        InterceptorEntry<X> entry = new InterceptorEntry<X>(interceptor);
        this._interceptorList.add(entry);
        return entry;
    }

    public List<javax.enterprise.inject.spi.Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            throw new IllegalArgumentException(L.l("resolveInterceptors requires at least one @InterceptorBinding"));
        }
        for (int i = 0; i < qualifiers.length; ++i) {
            Class<? extends Annotation> annType = qualifiers[i].annotationType();
            if (!annType.isAnnotationPresent(InterceptorBinding.class)) {
                throw new IllegalArgumentException(L.l("Annotation must be an @InterceptorBinding at '{0}' in resolveInterceptors", (Object)qualifiers[i]));
            }
            for (int j = i + 1; j < qualifiers.length; ++j) {
                if (!annType.equals(qualifiers[j].annotationType())) continue;
                throw new IllegalArgumentException(L.l("Duplicate binding '{0}' is not allowed in resolveInterceptors", (Object)qualifiers[i]));
            }
        }
        ArrayList interceptorList = new ArrayList();
        for (InterceptorEntry<?> entry : this._interceptorList) {
            javax.enterprise.inject.spi.Interceptor<?> interceptor = entry.getInterceptor();
            if (!interceptor.intercepts(type) || !entry.isMatch(qualifiers)) continue;
            interceptorList.add(interceptor);
        }
        return interceptorList;
    }

    private <X> DecoratorEntry<X> addDecorator(Decorator<X> decorator) {
        BaseType baseType = this.createTargetBaseType(decorator.getDelegateType());
        DecoratorEntry<X> entry = new DecoratorEntry<X>(this, decorator, baseType);
        this._decoratorList.add(entry);
        for (Type type : decorator.getDecoratedTypes()) {
            Class cl;
            if (!(type instanceof Class) || Object.class.equals((Object)(cl = (Class)type)) || Serializable.class.equals((Object)cl)) continue;
            String javaClassName = cl.getName();
            InjectScanClass scanClass = this.getScanManager().getScanClass(javaClassName);
            if (scanClass == null || scanClass.isRegistered()) continue;
            this.discoverScanClass(scanClass);
        }
        this.processPendingAnnotatedTypes();
        return entry;
    }

    public <X> BeanManager addDecoratorClass(Class<?> decoratorClass) {
        this._decoratorClassList.add(decoratorClass);
        return this;
    }

    public List<Decorator<?>> resolveDecorators(Class<?> type) {
        HashSet<Type> types = new HashSet<Type>();
        types.add(type);
        ArrayList<Annotation> bindingList = new ArrayList<Annotation>();
        boolean isQualifier = false;
        for (Annotation ann : type.getAnnotations()) {
            if (!this.isQualifier(ann.annotationType())) continue;
            bindingList.add(ann);
            if (Named.class.equals(ann.annotationType())) continue;
            isQualifier = true;
        }
        if (!isQualifier) {
            bindingList.add((Annotation)DefaultLiteral.DEFAULT);
        }
        bindingList.add((Annotation)AnyLiteral.ANY);
        Annotation[] bindings = new Annotation[bindingList.size()];
        bindingList.toArray(bindings);
        List<Decorator<?>> decorators = this.resolveDecorators(types, bindings);
        return decorators;
    }

    /*
     * WARNING - void declaration
     */
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        void var6_10;
        if (types.size() == 0) {
            throw new IllegalArgumentException(L.l("type set must contain at least one type"));
        }
        if (qualifiers != null) {
            for (int i = 0; i < qualifiers.length; ++i) {
                for (int j = i + 1; j < qualifiers.length; ++j) {
                    if (qualifiers[i].annotationType() != qualifiers[j].annotationType()) continue;
                    throw new IllegalArgumentException(L.l("resolveDecorators may not have a duplicate qualifier '{0}'", (Object)qualifiers[i]));
                }
            }
        }
        ArrayList decorators = new ArrayList();
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = DEFAULT_ANN;
        }
        if (this._decoratorList == null) {
            return decorators;
        }
        Annotation[] j = qualifiers;
        int n = j.length;
        boolean bl = false;
        while (var6_10 < n) {
            Annotation ann = j[var6_10];
            if (!this.isQualifier(ann.annotationType())) {
                throw new IllegalArgumentException(L.l("@{0} must be a qualifier", (Object)ann.annotationType()));
            }
            ++var6_10;
        }
        ArrayList<BaseType> targetTypes = new ArrayList<BaseType>();
        for (Type type : types) {
            targetTypes.add(this.createSourceBaseType(type));
        }
        for (DecoratorEntry decoratorEntry : this._decoratorList) {
            Decorator decorator = decoratorEntry.getDecorator();
            if (!this.isDelegateAssignableFrom(decoratorEntry.getDelegateType(), targetTypes) || !decoratorEntry.isMatch(qualifiers)) continue;
            decorators.add(decorator);
        }
        return decorators;
    }

    private boolean isDelegateAssignableFrom(BaseType delegateType, ArrayList<BaseType> sourceTypes) {
        for (BaseType sourceType : sourceTypes) {
            if (!delegateType.isAssignableFrom(sourceType)) continue;
            return true;
        }
        return false;
    }

    public void addConfiguredClass(String className) {
        this._xmlExtension.addConfiguredBean(className);
    }

    public XmlCookie generateXmlCookie() {
        return new XmlCookieLiteral(this._xmlCookieSequence.incrementAndGet());
    }

    public void addLoader() {
        this._isUpdateNeeded = true;
    }

    public void update() {
        if (!this._isEnableAutoUpdate) {
            return;
        }
        if (!(this._isUpdateNeeded || this._scanManager.isPending() || this._pendingAnnotatedTypes.size() != 0 || this._xmlExtension.isPending())) {
            return;
        }
        this._isUpdateNeeded = false;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(this._classLoader);
                this._extensionManager.updateExtensions();
                ArrayList<ScanRootContext> rootContextList = this._scanManager.getPendingScanRootList();
                for (ScanRootContext context : rootContextList) {
                    this._xmlExtension.addRoot(context.getRoot());
                }
                this._isBeforeBeanDiscoveryComplete = true;
                this.fireBeforeBeanDiscovery();
                this._xmlExtension.processRoots();
                this.processPendingAnnotatedTypes();
            }
            catch (ConfigException e) {
                if (this._configException == null) {
                    this._configException = e;
                }
                throw e;
            }
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private void fireBeforeBeanDiscovery() {
        if (this._isBeforeBeanDiscoverFired) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            block7: {
                try {
                    thread.setContextClassLoader(this._classLoader);
                    if (this._classLoader != null) {
                        this._classLoader.updateScan();
                    }
                    this._extensionManager.updateExtensions();
                    if (this._isBeforeBeanDiscoverFired) break block7;
                    this.getExtensionManager().fireBeforeBeanDiscovery();
                    this._isBeforeBeanDiscoverFired = true;
                }
                catch (ConfigException e) {
                    if (this._configException == null) {
                        this._configException = e;
                    }
                    throw e;
                }
            }
            Object var5_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void updateResources() {
    }

    private void addPendingAnnotatedType(AnnotatedType<?> annType) {
        this._pendingAnnotatedTypes.add(annType);
    }

    public void processPendingAnnotatedTypes() {
        this._scanManager.discover();
        ArrayList types = new ArrayList(this._pendingAnnotatedTypes);
        this._pendingAnnotatedTypes.clear();
        Collections.sort(types, new AnnotatedTypeComparator());
        for (AnnotatedType<?> beanType : types) {
            AnnotatedType<?> type = this.getExtensionManager().processAnnotatedType(beanType);
            if (type == null) continue;
            this.discoverBeanImpl(type);
        }
        this._extensionManager.processPendingEvents();
    }

    void discoverScanClass(InjectScanClass scanClass) {
        scanClass.register();
    }

    void discoverBean(InjectScanClass scanClass) {
        AnnotatedType<?> type = this.createDiscoveredType(scanClass.getClassName());
        if (type != null) {
            this.discoverBean(type);
        }
    }

    void discoverBean(String className) {
        AnnotatedType<?> type = this.createDiscoveredType(className);
        if (type != null) {
            this.discoverBean(type);
        }
    }

    private AnnotatedType<?> createDiscoveredType(String className) {
        try {
            Class<?> cl = Class.forName(className, false, this._classLoader);
            if (cl.getDeclaringClass() != null && !Modifier.isStatic(cl.getModifiers())) {
                return null;
            }
            for (Class<? extends Annotation> clazz : _forbiddenAnnotations) {
                if (!cl.isAnnotationPresent(clazz)) continue;
                return null;
            }
            for (Class<Annotation> clazz : _forbiddenClasses) {
                if (!clazz.isAssignableFrom(cl)) continue;
                return null;
            }
            if (cl.isInterface() && Annotation.class.isAssignableFrom(cl) && cl.isAnnotationPresent(Qualifier.class)) {
                QualifierBinding.validateQualifier(cl, null);
            }
            return this.createAnnotatedType(cl);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return null;
    }

    public <X> void discoverBean(AnnotatedType<X> beanType) {
        Class parent;
        Class cl = beanType.getJavaClass();
        if (cl.isAnnotationPresent(Specializes.class) && (parent = cl.getSuperclass()) != null) {
            this.addSpecialize(cl, parent);
        }
        this.addPendingAnnotatedType(beanType);
    }

    private void addSpecialize(Class<?> specializedType, Class<?> parentType) {
        Class<?> oldSpecialized = this._specializedMap.get(parentType);
        if (oldSpecialized != null) {
            throw new ConfigException(L.l("@Specialized on '{0}' is invalid because it conflicts with an older specialized '{1}'", (Object)specializedType.getName(), (Object)oldSpecialized.getName()));
        }
        if (!this.isValidSimpleBean(parentType)) {
            throw new ConfigException(L.l("@Specialized on '{0}' is invalid because its parent '{1}' is not a managed bean.", (Object)specializedType.getName(), (Object)parentType.getName()));
        }
        this._specializedMap.put(parentType, specializedType);
    }

    boolean isEnabled(Bean<?> bean) {
        if (!bean.isAlternative()) {
            return true;
        }
        if (this._deploymentMap.containsKey(bean.getBeanClass())) {
            return true;
        }
        for (Class stereotype : bean.getStereotypes()) {
            if (!this._deploymentMap.containsKey(stereotype)) continue;
            return true;
        }
        return false;
    }

    boolean isIntrospectObservers(AnnotatedType<?> type) {
        if (type.isAnnotationPresent(Specializes.class)) {
            return true;
        }
        String javaClassName = type.getJavaClass().getName();
        InjectScanClass scanClass = this.getScanManager().getScanClass(javaClassName);
        if (scanClass == null) {
            return true;
        }
        return scanClass.isObserves();
    }

    private boolean isValidSimpleBean(Class<?> type) {
        if (type.isInterface()) {
            return false;
        }
        if (type.isAnonymousClass()) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        return this.isValidConstructor(type);
    }

    private boolean isValidSimpleBean(AnnotatedType<?> type) {
        if (type.isAnnotationPresent(XmlCookie.class)) {
            return true;
        }
        return this.isValidSimpleBean(type.getJavaClass());
    }

    private boolean isValidConstructor(Class<?> type) {
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length == 0) {
                return true;
            }
            if (!ctor.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    private <T> void discoverBeanImpl(AnnotatedType<T> type) {
        InjectionTargetBuilder targetImpl;
        if (Throwable.class.isAssignableFrom(type.getJavaClass())) {
            return;
        }
        if (!this.isValidSimpleBean(type)) {
            return;
        }
        ManagedBeanImpl<T> bean = new ManagedBeanImpl<T>(this, type, false);
        InjectionTarget<T> target = bean.getInjectionTarget();
        if (target instanceof InjectionTargetBuilder) {
            targetImpl = (InjectionTargetBuilder)target;
            targetImpl.setGenerateInterception(true);
        }
        if ((target = this.processInjectionTarget(target, type)) == null) {
            return;
        }
        if (target instanceof InjectionTargetBuilder) {
            targetImpl = (InjectionTargetBuilder)target;
            targetImpl.setBean(bean);
        }
        bean.setInjectionTarget(target);
        bean.introspect();
        AnnotatedType<T> annType = bean.getAnnotatedType();
        if (annType.isAnnotationPresent(javax.decorator.Decorator.class)) {
            if (annType.isAnnotationPresent(Interceptor.class)) {
                throw new ConfigException(L.l("'{0}' bean may not have both a @Decorator and @Interceptor annotation.", (Object)annType.getJavaClass()));
            }
            DecoratorBean decoratorBean = new DecoratorBean(this, annType.getJavaClass());
            return;
        }
        if (annType.isAnnotationPresent(Interceptor.class)) {
            InterceptorBean interceptorBean = new InterceptorBean(this, annType.getJavaClass());
            this.addBeanDiscover((Bean<T>)interceptorBean);
            return;
        }
        this.addDiscoveredBean(bean);
        this.fillProducerBeans(bean);
    }

    public <T> InjectionTarget<T> processInjectionTarget(InjectionTarget<T> target, AnnotatedType<T> ann) {
        return this.getExtensionManager().processInjectionTarget(target, ann);
    }

    private void fillProducerBeans(ManagedBeanImpl<?> bean) {
    }

    private <X> void addDiscoveredBean(ManagedBeanImpl<X> managedBean) {
        if (!managedBean.isAlternative() || this.isEnabled(managedBean)) {
            this.addBeanDiscover(managedBean);
            if (!this._specializedMap.containsKey(managedBean.getBeanClass())) {
                managedBean.introspectObservers();
            }
        }
        if (!this._specializedMap.containsKey(managedBean.getBeanClass()) && this.isEnabled(managedBean)) {
            managedBean.introspectProduces();
        }
    }

    public <X> void addProduces(Bean<X> bean, AnnotatedType<X> beanType) {
        ProducesBuilder builder = new ProducesBuilder(this);
        builder.introspectProduces(bean, beanType);
    }

    public <X> void addManagedProduces(Bean<X> bean, AnnotatedType<X> beanType) {
        ManagedProducesBuilder builder = new ManagedProducesBuilder(this);
        builder.introspectProduces(bean, beanType);
    }

    public <X, T> void addProducesBean(ProducesMethodBean<X, T> bean) {
        AnnotatedMethod<X> producesMethod = bean.getProducesMethod();
        Producer<T> producer = bean.getProducer();
        producer = this.getExtensionManager().processProducer(producesMethod, producer);
        bean.setProducer(producer);
        this.addBeanDiscover(bean, (Annotated)producesMethod);
    }

    public <X, T> void addProducesFieldBean(ProducesFieldBean<X, T> bean) {
        AnnotatedField<X> producesField = bean.getField();
        Producer<T> producer = bean.getProducer();
        producer = this.getExtensionManager().processProducer(producesField, producer);
        bean.setProducer(producer);
        this.addBeanDiscover(bean, (Annotated)producesField);
    }

    public <X> void addManagedBeanDiscover(ManagedBeanImpl<X> managedBean) {
        this.addBeanDiscover(managedBean);
        managedBean.introspectProduces();
    }

    public <X> void addManagedBean(ManagedBeanImpl<X> managedBean) {
        this.addBean(managedBean);
        managedBean.introspectProduces();
    }

    public <T> ArrayList<T> loadServices(Class<T> serviceClass) {
        return this.loadServices(serviceClass, new HashSet<URL>(), false);
    }

    public <T> ArrayList<T> loadLocalServices(Class<T> serviceClass) {
        return this.loadServices(serviceClass, new HashSet<URL>(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> ArrayList<T> loadServices(Class<T> serviceApiClass, HashSet<URL> serviceSet, boolean isLocal) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            EnvironmentClassLoader loader = this._classLoader;
            if (loader == null) {
                return services;
            }
            String serviceName = "META-INF/services/" + serviceApiClass.getName();
            Enumeration<URL> e = isLocal ? loader.findResources(serviceName) : loader.getResources(serviceName);
            HashSet<Class<T>> classSet = new HashSet<Class<T>>();
            while (e.hasMoreElements()) {
                Object var16_21;
                InputStream inputStream;
                URL url = e.nextElement();
                if (serviceSet.contains(url)) continue;
                serviceSet.add(url);
                InputStream inputStream2 = null;
                try {
                    try {
                        String line;
                        inputStream = url.openStream();
                        ReadStream in = Vfs.openRead(inputStream);
                        while ((line = in.readLine()) != null) {
                            Class<T> cl;
                            int p = line.indexOf(35);
                            if (p >= 0) {
                                line = line.substring(0, p);
                            }
                            if ((line = line.trim()).length() <= 0 || (cl = this.loadServiceClass(serviceApiClass, line)) == null) continue;
                            classSet.add(cl);
                        }
                        in.close();
                    }
                    catch (IOException e1) {
                        log.log(Level.WARNING, e1.toString(), e1);
                        var16_21 = null;
                        IoUtil.close(inputStream2);
                        continue;
                    }
                    var16_21 = null;
                }
                catch (Throwable throwable) {
                    var16_21 = null;
                    IoUtil.close(inputStream2);
                    throw throwable;
                }
                IoUtil.close(inputStream);
            }
            for (Class clazz : classSet) {
                services.add(this.createTransientObject(clazz));
            }
            return services;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return services;
    }

    private <T> Class<T> loadServiceClass(Class<T> serviceApi, String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> serviceClass = Class.forName(className, false, loader);
            if (!serviceApi.isAssignableFrom(serviceClass)) {
                throw new InjectionException(L.l("'{0}' is not a valid servicebecause it does not implement {1}", (Object)serviceClass, (Object)serviceApi.getName()));
            }
            return serviceClass;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void addExtension(Extension extension) {
        this._extensionManager.addExtension(extension);
    }

    public void bind() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        boolean isBind = false;
        try {
            try {
                thread.setContextClassLoader(this._classLoader);
                this.processPendingAnnotatedTypes();
                if (this._pendingBindList != null) {
                    ArrayList bindList = new ArrayList(this._pendingBindList);
                    this._pendingBindList.clear();
                    if (bindList.size() > 0) {
                        isBind = true;
                    }
                }
                if (!this._isAfterBeanDiscoveryComplete) {
                    isBind = true;
                }
                if (isBind) {
                    this._isAfterBeanDiscoveryComplete = true;
                    this.getExtensionManager().fireAfterBeanDiscovery();
                }
                if (this._configException != null) {
                    throw this._configException;
                }
                this.addDecorators();
                this.addInterceptors();
                this.bindGlobals();
                this.validate();
            }
            catch (RuntimeException e) {
                if (this._configException == null) {
                    this._configException = e;
                } else {
                    log.log(Level.WARNING, e.toString(), e);
                }
                throw e;
            }
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void bindGlobals() {
        if (this._globalProgram.size() > 0) {
            ArrayList<ConfigProgram> programList = new ArrayList<ConfigProgram>(this._globalProgram);
            this._globalProgram.clear();
            for (ConfigProgram program : programList) {
                program.inject(this, null);
            }
        }
    }

    private void addInterceptors() {
        if (this._interceptorClassList.size() == 0) {
            return;
        }
        ArrayList interceptorClassList = new ArrayList(this._interceptorClassList);
        this._interceptorClassList.clear();
        for (Class<?> interceptorClass : interceptorClassList) {
            InterceptorEntry<?> entry2;
            for (InterceptorEntry<?> entry2 : this._interceptorList) {
                if (!entry2.getInterceptor().getBeanClass().equals(interceptorClass)) continue;
                entry2.setEnabled(true);
                return;
            }
            if (!interceptorClass.isAnnotationPresent(Interceptor.class)) {
                throw new ConfigException(L.l("'{0}' is an invalid interceptor because it does not have an @Interceptor.", (Object)interceptorClass.getName()));
            }
            InterceptorBean bean = new InterceptorBean(this, interceptorClass);
            entry2 = this.addInterceptor(bean);
            entry2.setEnabled(true);
        }
    }

    private void addDecorators() {
        if (this._decoratorClassList.size() == 0) {
            return;
        }
        ArrayList decoratorClassList = new ArrayList(this._decoratorClassList);
        this._decoratorClassList.clear();
        for (Class<?> clazz : decoratorClassList) {
            for (DecoratorEntry<?> entry2 : this._decoratorList) {
                if (!entry2.getDecorator().getBeanClass().equals(clazz)) continue;
                entry2.setEnabled(true);
                return;
            }
            DecoratorBean bean = new DecoratorBean(this, clazz);
            DecoratorEntry<?> entry = this.addDecorator(bean);
            entry.setEnabled(true);
        }
        for (DecoratorEntry decoratorEntry : this._decoratorList) {
            if (!decoratorEntry.isEnabled()) continue;
            for (Type type : decoratorEntry.getDelegateType().getTypeClosure(this)) {
                this.validate(type);
            }
        }
    }

    private void validate() {
        ArrayList<TypedBean> beans;
        int i;
        ArrayList<ArrayList<TypedBean>> typeValues = new ArrayList<ArrayList<TypedBean>>(this._selfBeanMap.values());
        for (i = typeValues.size() - 1; i >= 0; --i) {
            beans = typeValues.get(i);
            this.validateSpecializes(beans);
        }
        for (i = typeValues.size() - 1; i >= 0; --i) {
            beans = typeValues.get(i);
            if (beans == null) continue;
            for (int j = beans.size() - 1; j >= 0; --j) {
                TypedBean typedBean = beans.get(j);
                typedBean.validate();
            }
        }
    }

    private void validateSpecializes(ArrayList<TypedBean> beans) {
        if (beans == null) {
            return;
        }
        for (int i = beans.size() - 1; i >= 0; --i) {
            TypedBean bean = beans.get(i);
            Annotated ann = bean.getAnnotated();
            if (ann == null || !ann.isAnnotationPresent(Specializes.class)) continue;
            for (int j = beans.size() - 1; j >= 0; --j) {
                if (i == j) continue;
                TypedBean bean2 = beans.get(j);
                Annotated ann2 = bean.getAnnotated();
                if (ann2 == null || !this.isSpecializes(ann, ann2) || !this.isMatchInject(bean, bean2)) continue;
                beans.remove(j);
                i = 0;
            }
        }
    }

    private boolean isMatchInject(TypedBean typedBeanA, TypedBean typedBeanB) {
        Bean<?> beanA = typedBeanA.getBean();
        Bean<?> beanB = typedBeanB.getBean();
        return beanA.getTypes().equals(beanB.getTypes()) && beanA.getQualifiers().equals(beanB.getQualifiers());
    }

    private boolean isSpecializes(Annotated childAnn, Annotated parentAnn) {
        if (childAnn instanceof AnnotatedMethod && parentAnn instanceof AnnotatedMethod) {
            Method parentMethod;
            Method childMethod = ((AnnotatedMethod)childAnn).getJavaMember();
            if (!AnnotatedTypeUtil.isMatch(childMethod, parentMethod = ((AnnotatedMethod)parentAnn).getJavaMember())) {
                return false;
            }
            Class<?> childClass = childMethod.getDeclaringClass();
            Class<?> parentClass = parentMethod.getDeclaringClass();
            if (parentClass.isAssignableFrom(childClass)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
        this.initialize();
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
        this.initialize();
        this.bind();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    public void initialize() {
        this.update();
    }

    public void start() {
        this.initialize();
        this.bind();
        this.startServices();
        if (this._configException != null) {
            throw this._configException;
        }
        this.notifyStart();
    }

    public void notifyStart() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            block6: {
                try {
                    thread.setContextClassLoader(this._classLoader);
                    this.update();
                    if (!this._isAfterValidationNeeded) break block6;
                    this._isAfterValidationNeeded = false;
                    this.getExtensionManager().fireAfterDeploymentValidation();
                }
                catch (ConfigException e) {
                    if (this._configException == null) {
                        this._configException = e;
                    }
                    throw e;
                }
            }
            Object var5_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        if (this._configException != null) {
            throw this._configException;
        }
    }

    public void addDefinitionError(Throwable t) {
        if (this._configException != null) {
            log.log(Level.WARNING, t.toString(), t);
        } else {
            this._configException = t instanceof RuntimeException ? (RuntimeException)t : ConfigException.create(t);
        }
    }

    public RuntimeException getConfigException() {
        return this._configException;
    }

    public void addConfiguredBean(String className) {
        this._xmlExtension.addConfiguredBean(className);
    }

    public void addXmlInjectionTarget(long cookie, InjectionTarget<?> target) {
        this._xmlTargetMap.put(cookie, target);
    }

    public InjectionTarget<?> getXmlInjectionTarget(long cookie) {
        return this._xmlTargetMap.get(cookie);
    }

    void addService(Bean<?> bean) {
        this._pendingServiceList.add(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServices() {
        ArrayList services;
        ArrayList<Bean<?>> arrayList = this._pendingServiceList;
        synchronized (arrayList) {
            services = new ArrayList(this._pendingServiceList);
            this._pendingServiceList.clear();
        }
        for (Bean bean : services) {
            CreationalContext env = this.createCreationalContext((Contextual)bean);
            this.getReference(bean, bean.getBeanClass(), env);
        }
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    public void destroy() {
        this._singletonScope.closeContext();
        this._classLoader = null;
        this._deploymentMap = null;
        this._selfBeanMap = null;
        this._selfNamedBeanMap = null;
        this._beanMap = null;
        this._namedBeanMap = null;
        this._contextMap = null;
        this._interceptorList = null;
        this._decoratorList = null;
        this._pendingBindList = null;
        this._pendingServiceList = null;
        this._eventManager = null;
    }

    public static ConfigException injectError(AccessibleObject prop, String msg) {
        String location = "";
        if (prop instanceof Field) {
            Field field = (Field)prop;
            String className = field.getDeclaringClass().getName();
            location = className + "." + field.getName() + ": ";
        } else if (prop instanceof Method) {
            Method method = (Method)prop;
            String className = method.getDeclaringClass().getName();
            location = className + "." + method.getName() + ": ";
        }
        return new ConfigException(location + msg);
    }

    public static String location(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName() + ": ";
    }

    public static String location(Method method) {
        return LineConfigException.loc(method);
    }

    public static ConfigException error(Method method, String msg) {
        return new ConfigException(InjectManager.location(method) + msg);
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    public Object writeReplace() {
        return this._serializationHandle;
    }

    public void checkActive() {
    }

    public boolean isClosed() {
        return this._beanMap == null;
    }

    public String toString() {
        if (this._classLoader != null) {
            return this.getClass().getSimpleName() + "[" + this._classLoader.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    static String getSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return String.valueOf(type);
    }

    static {
        Class<?> cl;
        L = new L10N(InjectManager.class);
        log = Logger.getLogger(InjectManager.class.getName());
        _localContainer = new EnvironmentLocal();
        DEFAULT_ANN = DefaultLiteral.DEFAULT_ANN_LIST;
        FORBIDDEN_ANNOTATIONS = new String[]{"javax.persistence.Entity"};
        FORBIDDEN_CLASSES = new String[]{"javax.servlet.Servlet", "javax.servlet.Filter", "javax.servlet.ServletContextListener", "javax.servlet.http.HttpSessionListener", "javax.servlet.ServletRequestListener", "javax.ejb.EnterpriseBean", "javax.faces.component.UIComponent", "javax.enterprise.inject.spi.Extension"};
        ArrayList forbiddenAnnotations = new ArrayList();
        ArrayList forbiddenClasses = new ArrayList();
        for (String className : FORBIDDEN_ANNOTATIONS) {
            try {
                cl = Class.forName(className);
                if (cl == null) continue;
                forbiddenAnnotations.add(cl);
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        for (String className : FORBIDDEN_CLASSES) {
            try {
                cl = Class.forName(className);
                if (cl == null) continue;
                forbiddenClasses.add(cl);
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        _forbiddenAnnotations = new Class[forbiddenAnnotations.size()];
        forbiddenAnnotations.toArray(_forbiddenAnnotations);
        _forbiddenClasses = new Class[forbiddenClasses.size()];
        forbiddenClasses.toArray(_forbiddenClasses);
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        _systemClassLoader = systemClassLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedTypeComparator
    implements Comparator<AnnotatedType<?>> {
        private AnnotatedTypeComparator() {
        }

        @Override
        public int compare(AnnotatedType<?> a, AnnotatedType<?> b) {
            return a.toString().compareTo(b.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnresolvedReferenceFactory
    extends ReferenceFactory<Object> {
        private InjectionException _exn;

        UnresolvedReferenceFactory() {
            this._exn = new InjectionException("unresolved injection");
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        public Object create(CreationalContextImpl<Object> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            throw this._exn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InjectionPointReferenceFactory
    extends ReferenceFactory<InjectionPoint> {
        InjectionPointReferenceFactory() {
        }

        @Override
        public InjectionPoint create(CreationalContextImpl<InjectionPoint> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            InjectionPoint ip2 = parentEnv.findInjectionPoint();
            if (ip2 != null) {
                return ip2;
            }
            throw new InjectionException(L.l("no injection point available in this context {0}", (Object)ip));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ErrorReferenceFactory<T>
    extends ReferenceFactory<T> {
        private RuntimeException _exn;

        ErrorReferenceFactory(RuntimeException e) {
            this._exn = e;
        }

        @Override
        public boolean isProducer() {
            return true;
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            throw this._exn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegateReferenceFactory<T>
    extends ReferenceFactory<T> {
        DelegateReferenceFactory() {
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            return (T)parentEnv.getDelegate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NormalContextReferenceFactory<T>
    extends ReferenceFactory<T> {
        private Bean<T> _bean;
        private ScopeAdapterBean<T> _scopeAdapterBean;
        private Context _context;
        private T _scopeAdapter;

        NormalContextReferenceFactory(Bean<T> bean, ScopeAdapterBean<T> scopeAdapterBean, Context context) {
            this._bean = bean;
            this._scopeAdapterBean = scopeAdapterBean;
            this._context = context;
            ScopeAdapter scopeAdapter = ScopeAdapter.create(bean);
            this._scopeAdapter = scopeAdapter.wrap(InjectManager.this.createNormalInstanceFactory(bean));
        }

        @Override
        protected void validate() {
            InjectManager.this.validateNormal(this._bean);
        }

        @Override
        public Bean<T> getBean() {
            return this._bean;
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            return this._scopeAdapter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NormalInstanceReferenceFactory<T>
    extends ReferenceFactory<T> {
        private ThreadLocal<CreationalContextImpl<T>> _threadLocal;
        private Bean<T> _bean;
        private Context _context;

        NormalInstanceReferenceFactory(Bean<T> bean, Context context) {
            this._threadLocal = new ThreadLocal();
            this._bean = bean;
            this._context = context;
        }

        @Override
        public Bean<T> getBean() {
            return this._bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            Object instance;
            CreationalContextImpl<T> oldEnv;
            Bean<T> bean;
            block4: {
                T t;
                bean = this._bean;
                oldEnv = this._threadLocal.get();
                try {
                    instance = CreationalContextImpl.find(oldEnv, bean);
                    if (instance == null) break block4;
                    t = instance;
                    Object var9_9 = null;
                    this._threadLocal.set(oldEnv);
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this._threadLocal.set(oldEnv);
                    throw throwable;
                }
                return t;
            }
            env = new OwnerCreationalContext<T>(bean, oldEnv);
            this._threadLocal.set(env);
            instance = this._context.get(bean, env);
            if (instance == null) {
                throw new NullPointerException(L.l("null instance returned by '{0}' for bean '{1}'", (Object)this._context, (Object)bean));
            }
            Object object = instance;
            Object var9_10 = null;
            this._threadLocal.set(oldEnv);
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContextReferenceFactory<T>
    extends ReferenceFactory<T> {
        private Bean<T> _bean;
        private Context _context;

        ContextReferenceFactory(Bean<T> bean, Context context) {
            this._bean = bean;
            this._context = context;
        }

        @Override
        public Bean<T> getBean() {
            return this._bean;
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            Bean<T> bean = this._bean;
            Object instance = CreationalContextImpl.find(parentEnv, bean);
            if (instance != null) {
                return instance;
            }
            if (env == null) {
                env = new OwnerCreationalContext<T>(bean, parentEnv);
            }
            if ((instance = this._context.get(bean, env)) == null) {
                throw new NullPointerException(L.l("null instance returned by '{0}' for bean '{1}'", (Object)this._context, (Object)bean));
            }
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DependentElReferenceFactoryImpl<T>
    extends ReferenceFactory<T> {
        private ManagedBeanImpl<T> _bean;

        DependentElReferenceFactoryImpl(ManagedBeanImpl<T> bean) {
            this._bean = bean;
        }

        @Override
        public Bean<T> getBean() {
            return this._bean;
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            ManagedBeanImpl<T> bean = this._bean;
            T instance = CreationalContextImpl.findAny(parentEnv, bean);
            if (instance != null) {
                return instance;
            }
            if (env == null) {
                env = parentEnv != null ? new DependentCreationalContext<T>(bean, parentEnv, ip) : new OwnerCreationalContext<T>(bean);
            }
            instance = bean.createDependent(env);
            if (env.isTop() && !(bean instanceof CdiStatefulBean)) {
                bean.destroy(instance, (CreationalContext<T>)env);
            }
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DependentReferenceFactoryImpl<T>
    extends ReferenceFactory<T> {
        private ManagedBeanImpl<T> _bean;

        DependentReferenceFactoryImpl(ManagedBeanImpl<T> bean) {
            this._bean = bean;
        }

        @Override
        public Bean<T> getBean() {
            return this._bean;
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            ManagedBeanImpl<T> bean = this._bean;
            T instance = CreationalContextImpl.find(parentEnv, bean);
            if (instance != null) {
                return instance;
            }
            if (env == null) {
                env = parentEnv != null ? new DependentCreationalContext<T>(bean, parentEnv, ip) : new OwnerCreationalContext<T>(bean);
            }
            instance = bean.createDependent(env);
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DependentReferenceFactory<T>
    extends ReferenceFactory<T> {
        private Bean<T> _bean;

        DependentReferenceFactory(Bean<T> bean) {
            this._bean = bean;
        }

        @Override
        public Bean<T> getBean() {
            return this._bean;
        }

        @Override
        public T create(CreationalContextImpl<T> env, CreationalContextImpl<?> parentEnv, InjectionPoint ip) {
            Bean<T> bean = this._bean;
            Object instance = CreationalContextImpl.find(parentEnv, bean);
            if (instance != null) {
                return instance;
            }
            if (env == null) {
                if (parentEnv != null) {
                    env = new DependentCreationalContext<T>(bean, parentEnv, ip);
                } else {
                    env = new OwnerCreationalContext<T>(bean);
                    if (ip != null) {
                        env = new DependentCreationalContext<T>(bean, env, ip);
                    }
                }
            }
            instance = bean.create(env);
            env.push(instance);
            return instance;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._bean + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ReferenceFactory<T> {
        public Bean<T> getBean() {
            return null;
        }

        protected void validate() {
        }

        public final T create() {
            return this.create(null, null, null);
        }

        public boolean isResolved() {
            return true;
        }

        public boolean isProducer() {
            Bean<T> bean = this.getBean();
            return bean instanceof ProducesMethodBean || bean instanceof ProducesFieldBean;
        }

        public abstract T create(CreationalContextImpl<T> var1, CreationalContextImpl<?> var2, InjectionPoint var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InjectBean<X>
    extends BeanWrapper<X>
    implements PassivationCapable,
    ScopeAdapterBean<X> {
        private ClassLoader _loader = Thread.currentThread().getContextClassLoader();

        InjectBean(Bean<X> bean, InjectManager beanManager) {
            super(beanManager, bean);
            AbstractBean absBean;
            Annotated annotated;
            if (bean instanceof AbstractBean && (annotated = (absBean = (AbstractBean)bean).getAnnotated()) != null && annotated.isAnnotationPresent(ContextDependent.class)) {
                this._loader = null;
            }
        }

        @Override
        public String getId() {
            Bean bean = this.getBean();
            if (bean instanceof PassivationCapable) {
                return ((PassivationCapable)bean).getId();
            }
            return null;
        }

        @Override
        public X getScopeAdapter(Bean<?> topBean, CreationalContextImpl<X> cxt) {
            Bean bean = this.getBean();
            if (bean instanceof ScopeAdapterBean) {
                return ((ScopeAdapterBean)bean).getScopeAdapter(topBean, cxt);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public X create(CreationalContext<X> env) {
            Object object;
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                Object value;
                if (this._loader != null) {
                    thread.setContextClassLoader(this._loader);
                }
                object = value = this.getBean().create(env);
                Object var7_6 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            return (X)object;
        }

        public int hashCode() {
            return this.getBean().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof InjectBean)) {
                return false;
            }
            InjectBean bean = (InjectBean)o;
            return this.getBean().equals(bean.getBean());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getBean() + "]";
        }
    }

    static class FactoryBinding {
        private static final Annotation[] NULL = new Annotation[0];
        private final Type _type;
        private final Annotation[] _ann;

        FactoryBinding(Type type, Annotation[] ann) {
            this._type = type;
            this._ann = ann != null ? ann : NULL;
        }

        public int hashCode() {
            int hash = this._type.hashCode();
            for (Annotation ann : this._ann) {
                hash = 65521 * hash + ann.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FactoryBinding)) {
                return false;
            }
            FactoryBinding binding = (FactoryBinding)obj;
            if (this._type != binding._type) {
                return false;
            }
            if (this._ann.length != binding._ann.length) {
                return false;
            }
            for (int i = 0; i < this._ann.length; ++i) {
                if (this._ann[i].equals(binding._ann[i])) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FillByType
    implements EnvironmentApply {
        private BaseType _baseType;
        private HashSet<TypedBean> _beanSet;
        private InjectManager _manager;

        FillByType(BaseType baseType, HashSet<TypedBean> beanSet, InjectManager manager) {
            this._baseType = baseType;
            this._beanSet = beanSet;
            this._manager = manager;
        }

        @Override
        public void apply(EnvironmentClassLoader loader) {
            InjectManager beanManager = InjectManager.getCurrent(loader);
            beanManager.fillByType(this._baseType, this._beanSet, this._manager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FillByName
    implements EnvironmentApply {
        private String _name;
        private ArrayList<Bean<?>> _beanList;

        FillByName(String name, ArrayList<Bean<?>> beanList) {
            this._name = name;
            this._beanList = beanList;
        }

        @Override
        public void apply(EnvironmentClassLoader loader) {
            InjectManager beanManager = InjectManager.getCurrent(loader);
            beanManager.fillByName(this._name, this._beanList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypedBean {
        private final BaseType _type;
        private final Annotated _annotated;
        private final Bean<?> _bean;
        private final boolean _isModulePrivate;
        private boolean _isValidated;

        TypedBean(BaseType type, Annotated annotated, Bean<?> bean) {
            this._type = type;
            this._annotated = annotated;
            this._bean = bean;
            this._isModulePrivate = this.isModulePrivate(bean) || bean.isAlternative();
        }

        public Annotated getAnnotated() {
            return this._annotated;
        }

        public void validate() {
            if (!this._isValidated) {
                this._isValidated = true;
                InjectManager.this.validate(this._bean);
            }
        }

        boolean isModulePrivate() {
            return this._isModulePrivate;
        }

        BaseType getType() {
            return this._type;
        }

        Bean<?> getBean() {
            return this._bean;
        }

        boolean isModulePrivate(Bean<?> bean) {
            if (!(bean instanceof AnnotatedBean)) {
                return false;
            }
            Annotated annotated = ((AnnotatedBean)bean).getAnnotated();
            if (annotated == null) {
                return false;
            }
            for (Annotation ann : annotated.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (!annType.equals(ModulePrivate.class) && !annType.isAnnotationPresent(ModulePrivate.class) && !annType.equals(Module.class) && !annType.isAnnotationPresent(Module.class)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 65521 * this._type.hashCode() + this._bean.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TypedBean)) {
                return false;
            }
            TypedBean bean = (TypedBean)o;
            return this._type.equals(bean._type) && this._bean.equals(bean._bean);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._type + "," + this._bean + "]";
        }
    }
}

