/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.WebBeanMXBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeanAdmin
extends AbstractManagedObject
implements WebBeanMXBean {
    private final Bean<?> _bean;
    private int _id;

    public WebBeanAdmin(Bean<?> bean, int id) {
        this._bean = bean;
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    @Override
    public String getName() {
        String name = this._bean.getName();
        if (name != null) {
            return name;
        }
        return this.getBeanSimpleType();
    }

    public String getBeanSimpleType() {
        Set types = this._bean.getTypes();
        Iterator iter = types.iterator();
        if (iter.hasNext()) {
            return ((Class)iter.next()).getSimpleName();
        }
        return null;
    }

    @Override
    public String[] getBeanTypes() {
        Set types = this._bean.getTypes();
        String[] names = new String[types.size()];
        int i = 0;
        for (Type type : types) {
            names[i++] = ((Class)type).getName();
        }
        return names;
    }

    @Override
    public String[] getQualifiers() {
        Set types = this._bean.getQualifiers();
        ArrayList<String> nameList = new ArrayList<String>();
        for (Annotation ann : types) {
            if (ann == null) continue;
            nameList.add(ann.toString());
        }
        String[] names = new String[nameList.size()];
        nameList.toArray(names);
        return names;
    }

    @Override
    public String getScope() {
        Class annType = this._bean.getScope();
        if (annType != null) {
            return annType.getName();
        }
        return null;
    }

    @Override
    protected void addObjectNameProperties(Map<String, String> props) {
        props.put("wid", String.valueOf(this._id));
    }

    void register() {
        this.registerSelf();
    }

    void unregister() {
        this.unregisterSelf();
    }
}

