/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.ResourceGroupConfig;
import com.caucho.env.jdbc.DatabaseFactory;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceRef
extends ResourceGroupConfig {
    private static final L10N L = new L10N(DataSourceRef.class);
    private static final Logger log = Logger.getLogger(DataSourceRef.class.getName());
    private String _name;
    private Class<?> _className;
    private String _serverName;
    private String _databaseName;
    private int _portNumber;
    private String _url;
    private String _userName;
    private String _password;
    private Object _objectValue;
    private long _loginTimeout;
    private boolean _isTransactional;
    private int _isolation_level;

    @Override
    public void setId(String id) {
    }

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    @Configurable
    public void setClassName(Class<?> cl) {
        this._className = cl;
    }

    @Configurable
    public void setDatabaseName(String value) {
        this._databaseName = value;
    }

    @Configurable
    public void setServerName(String value) {
        this._serverName = value;
    }

    @Configurable
    public void setPortNumber(int value) {
        this._portNumber = value;
    }

    @Configurable
    public void setUrl(String url) {
        this._url = url;
    }

    @Configurable
    public void setUser(String userName) {
        this._userName = userName;
    }

    @Configurable
    public void setPassword(String password) {
        this._password = password;
    }

    @Configurable
    public void addProperty(Property prop) {
    }

    public void setLoginTimeout(int ms) {
        this._loginTimeout = ms;
    }

    public void setTransactional(boolean isTransactional) {
        this._isTransactional = isTransactional;
    }

    public void setIsolationLevel(String level) {
    }

    public void setInitialPoolSize(int size) {
    }

    public void setMinPoolSize(int size) {
    }

    public void setMaxPoolSize(int size) {
    }

    public void setMaxIdleTime(int time) {
    }

    public void setMaxStatements(int statements) {
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        if (this._name == null) {
            throw new ConfigException(L.l("data-sourceneeds 'name' attribute"));
        }
        super.init();
        if (!this.isProgram()) {
            this.deploy();
        }
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) {
    }

    @Override
    public Object getValue() {
        if (this.getLookupName() != null) {
            try {
                return Jndi.lookup(this.getLookupName());
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (this._objectValue == null) {
            this.deploy();
        }
        return this._objectValue;
    }

    @Override
    public void deploy() {
        if (this._objectValue != null) {
            return;
        }
        super.deploy();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                if (this.getJndiClassLoader() != null) {
                    thread.setContextClassLoader(this.getJndiClassLoader());
                }
                Jndi.bindDeepShort(this._name, this);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            Object var5_3 = null;
            thread.setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            thread.setContextClassLoader(loader);
            throw throwable;
        }
        DatabaseFactory factory = DatabaseFactory.createBuilder();
        factory.setName(this._name);
        factory.setDriverClass(this._className);
        factory.setUrl(this._url);
        factory.setUser(this._userName);
        factory.setPassword(this._password);
        factory.setDatabaseName(this._databaseName);
        this._objectValue = factory.create();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    static class Property {
        private String _name;
        private String _value;

        Property() {
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setValue(String value) {
            this._value = value;
        }
    }
}

