/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.ServiceStartup;
import com.caucho.config.bytecode.ScopeProxy;
import com.caucho.config.cfg.BeansConfig;
import com.caucho.config.extension.ProcessBeanImpl;
import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ScheduleBean;
import com.caucho.config.inject.SingletonHandle;
import com.caucho.config.xml.XmlCookie;
import com.caucho.inject.LazyExtension;
import com.caucho.inject.Module;
import com.caucho.loader.EnvironmentBean;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ejb.DependsOn;
import javax.ejb.Startup;
import javax.ejb.Stateless;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class XmlStandardPlugin
implements Extension {
    private static final L10N L = new L10N(XmlStandardPlugin.class);
    private static final String SCHEMA = "com/caucho/config/cfg/resin-beans.rnc";
    private InjectManager _cdiManager;
    private HashSet<String> _configuredBeans = new HashSet();
    private ArrayList<Path> _roots = new ArrayList();
    private ArrayList<Path> _pendingRoots = new ArrayList();
    private ArrayList<Path> _pendingXml = new ArrayList();
    private HashSet<Path> _xmlSet = new HashSet();
    private ArrayList<BeansConfig> _pendingBeans = new ArrayList();
    private ArrayList<StartupItem> _pendingService = new ArrayList();
    private Throwable _configException;

    public XmlStandardPlugin(InjectManager manager) {
        this._cdiManager = manager;
    }

    public void addRoot(Path root) {
        if (!this._roots.contains(root)) {
            this._pendingRoots.add(root);
        }
    }

    public void addXmlPath(Path xmlPath) {
        if (!this._xmlSet.contains(xmlPath)) {
            this._xmlSet.add(xmlPath);
            this._pendingXml.add(xmlPath);
        }
    }

    public void beforeDiscovery(@Observes BeforeBeanDiscovery event) {
        this.processRoots();
    }

    public boolean isPending() {
        return this._pendingRoots.size() > 0 || this._pendingXml.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void processRoots() {
        try {
            void var3_7;
            ArrayList<Path> paths = new ArrayList<Path>(this._pendingRoots);
            this._pendingRoots.clear();
            for (Path path : paths) {
                this.configureRoot(path);
            }
            ArrayList<Path> xmlPaths = new ArrayList<Path>(this._pendingXml);
            this._pendingXml.clear();
            for (Path xml : xmlPaths) {
                this.configurePath(xml);
            }
            boolean bl = false;
            while (var3_7 < this._pendingBeans.size()) {
                BeansConfig config = this._pendingBeans.get((int)var3_7);
                ArrayList<Class<?>> deployList = config.getAlternativesList();
                if (deployList != null && deployList.size() > 0) {
                    this._cdiManager.setDeploymentTypes(deployList);
                }
                ++var3_7;
            }
        }
        catch (Exception e) {
            if (this._configException == null) {
                this._configException = e;
            }
            throw ConfigException.create(e);
        }
    }

    private void configureRoot(Path root) throws IOException {
        block3: {
            List<Path> beansXmlOverride;
            block1: {
                block2: {
                    beansXmlOverride = this._cdiManager.getBeansXmlOverride(root);
                    if (beansXmlOverride != null) break block1;
                    this.addPath(root.lookup("META-INF/beans.xml"));
                    this.addPath(root.lookup("META-INF/resin-beans.xml"));
                    if (!root.getFullPath().endsWith("WEB-INF/classes/")) break block2;
                    this.addPath(root.lookup("../beans.xml"));
                    this.addPath(root.lookup("../resin-beans.xml"));
                    break block3;
                }
                if (root.lookup("META-INF/beans.xml").canRead() || root.lookup("META-INF/resin-beans.xml").canRead()) break block3;
                this.addPath(root.lookup("beans.xml"));
                this.addPath(root.lookup("resin-beans.xml"));
                break block3;
            }
            for (Path beansXMLPath : beansXmlOverride) {
                this.configureXmlOverridePath(beansXMLPath);
            }
        }
    }

    private void addPath(Path beansPath) {
        if (beansPath.canRead() && beansPath.getLength() > 0L) {
            this.addXmlPath(beansPath);
        }
    }

    private void configurePath(Path beansPath) throws IOException {
        if (beansPath.canRead() && beansPath.getLength() > 0L) {
            BeansConfig beans = new BeansConfig(this._cdiManager, beansPath);
            beansPath.setUserPath(beansPath.getURL());
            new Config().configure((Object)beans, beansPath, SCHEMA);
            this._pendingBeans.add(beans);
        }
    }

    private void configureXmlOverridePath(Path beansPath) throws IOException {
        ContextConfig context = new ContextConfig(this._cdiManager, beansPath);
        Config config = new Config();
        config.configure((Object)context, beansPath, SCHEMA);
    }

    public void addConfiguredBean(String className) {
        this._configuredBeans.add(className);
    }

    @LazyExtension
    public void processType(@Observes ProcessAnnotatedType<?> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type == null) {
            return;
        }
        if (type.isAnnotationPresent(XmlCookie.class)) {
            return;
        }
        if (this._configuredBeans.contains(type.getJavaClass().getName())) {
            event.veto();
            return;
        }
    }

    @LazyExtension
    public void processTarget(@Observes ProcessInjectionTarget<?> event) {
        AnnotatedType type = event.getAnnotatedType();
        XmlCookie cookie = (XmlCookie)type.getAnnotation(XmlCookie.class);
        if (cookie != null) {
            InjectionTarget<?> target = this._cdiManager.getXmlInjectionTarget(cookie.value());
            event.setInjectionTarget(target);
        }
    }

    public void processType(@Observes AfterBeanDiscovery event) {
        if (this._configException != null) {
            event.addDefinitionError(this._configException);
        }
    }

    @LazyExtension
    public void processBean(@Observes ProcessBean<?> event) {
        ProcessBeanImpl eventImpl = (ProcessBeanImpl)event;
        if (eventImpl.getManager() != this._cdiManager) {
            return;
        }
        Annotated annotated = event.getAnnotated();
        Bean bean = event.getBean();
        if (this.isStartup(annotated)) {
            this._pendingService.add(new StartupItem(bean, annotated));
        }
    }

    public void processAfterValidation(@Observes AfterDeploymentValidation event) {
        Bean<?> bean;
        ArrayList<StartupItem> startupBeans = new ArrayList<StartupItem>(this._pendingService);
        this._pendingService.clear();
        ArrayList runningBeans = new ArrayList();
        while ((bean = this.nextStartup(startupBeans, runningBeans)) != null) {
            CreationalContext<?> env = this._cdiManager.createCreationalContext(bean);
            Object value = this._cdiManager.getReference(bean, bean.getBeanClass(), env);
            if (value instanceof ScopeProxy) {
                ((ScopeProxy)value).__caucho_getDelegate();
            }
            if (bean instanceof ScheduleBean) {
                ((ScheduleBean)bean).scheduleTimers(value);
            }
            if (!(value instanceof HandleAware) || !(bean instanceof PassivationCapable)) continue;
            String id = ((PassivationCapable)bean).getId();
            ((HandleAware)value).setSerializationHandle(new SingletonHandle(id));
        }
    }

    private Bean<?> nextStartup(ArrayList<StartupItem> startupBeans, ArrayList<Bean<?>> runningBeans) {
        if (startupBeans.size() == 0) {
            return null;
        }
        for (StartupItem item : startupBeans) {
            Bean<?> bean = item.getBean();
            DependsOn dependsOn = (DependsOn)item.getAnnotated().getAnnotation(DependsOn.class);
            if (dependsOn != null && !this.isStarted(runningBeans, dependsOn)) continue;
            startupBeans.remove(item);
            runningBeans.add(bean);
            return bean;
        }
        StringBuilder sb = new StringBuilder();
        for (StartupItem item : startupBeans) {
            sb.append("\n  " + item.getBean());
        }
        throw new ConfigException(L.l("@DependsOn circularity {0}", (Object)sb));
    }

    private boolean isStarted(ArrayList<Bean<?>> runningBeans, DependsOn depends) {
        for (String dep : depends.value()) {
            if (this.isStarted(runningBeans, dep)) continue;
            return false;
        }
        return true;
    }

    private boolean isStarted(ArrayList<Bean<?>> runningBeans, String dep) {
        for (Bean<?> bean : runningBeans) {
            String name = bean.getName();
            String className = bean.getBeanClass().getSimpleName();
            if (!dep.equals(name) && !dep.equals(className)) continue;
            return true;
        }
        return false;
    }

    private boolean isStartup(Annotated annotated) {
        if (annotated == null) {
            return false;
        }
        for (Annotation ann : annotated.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (annType.equals(Stateless.class)) {
                return true;
            }
            if (annType.equals(Startup.class)) {
                return true;
            }
            if (annType.equals(ServiceStartup.class)) {
                return true;
            }
            if (!annType.isAnnotationPresent(Stereotype.class)) continue;
            if (annType.isAnnotationPresent(ServiceStartup.class)) {
                return true;
            }
            if (!annType.isAnnotationPresent(Startup.class)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    private class SystemContext
    implements EnvironmentBean {
        private SystemContext() {
        }

        public ClassLoader getClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    private class ContextConfig
    extends BeansConfig
    implements EnvironmentBean {
        ContextConfig(InjectManager manager, Path root) {
            super(manager, root);
        }

        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        public SystemContext createSystem() {
            return new SystemContext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StartupItem {
        private Bean<?> _bean;
        private Annotated _annotated;

        public StartupItem(Bean<?> bean, Annotated annotated) {
            this._bean = bean;
            this._annotated = annotated;
        }

        public Bean<?> getBean() {
            return this._bean;
        }

        public Annotated getAnnotated() {
            return this._annotated;
        }
    }
}

