/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.util.BeanUtil;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayExpr
extends Expr {
    private Expr _left;
    private Expr _right;
    private transient Class _lastClass;
    private transient String _lastField;
    private transient Method _lastMethod;

    public ArrayExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public Expr getExpr() {
        return this._left;
    }

    public Expr getIndex() {
        return this._right;
    }

    @Override
    public Expr createMethod(Expr[] args) {
        if (!(this._right instanceof StringLiteral)) {
            return null;
        }
        StringLiteral literal = (StringLiteral)this._right;
        return new MethodExpr(this._left, literal.getValue(), args);
    }

    @Override
    public Class<?> getType(ELContext env) {
        Object aObj = this._left.getValue(env);
        if (aObj == null) {
            return null;
        }
        Object fieldObj = this._right.getValue(env);
        if (fieldObj == null) {
            return null;
        }
        return env.getELResolver().getType(env, aObj, fieldObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(ELContext env) throws ELException {
        Class<?> aClass;
        Object aObj = this._left.getValue(env);
        if (aObj == null) {
            return null;
        }
        Object fieldObj = this._right.getValue(env);
        if (fieldObj == null) {
            return null;
        }
        if (aObj instanceof Map) {
            return ((Map)aObj).get(fieldObj);
        }
        if (aObj instanceof List) {
            int ref = (int)ArrayExpr.toLong(fieldObj, null);
            try {
                List list = (List)aObj;
                if (ref < 0 || list.size() < ref) {
                    return null;
                }
                return list.get(ref);
            }
            catch (IndexOutOfBoundsException list) {
            }
            catch (Exception e) {
                return ArrayExpr.invocationError(e);
            }
        }
        if ((aClass = aObj.getClass()).isArray()) {
            int ref = (int)ArrayExpr.toLong(fieldObj, null);
            try {
                return Array.get(aObj, ref);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception e) {
                return ArrayExpr.error(e, env);
            }
        }
        String fieldName = ArrayExpr.toString(fieldObj, env);
        Method getMethod = null;
        try {
            ArrayExpr arrayExpr = this;
            synchronized (arrayExpr) {
                if (this._lastClass == aClass && this._lastField.equals(fieldName)) {
                    getMethod = this._lastMethod;
                } else {
                    getMethod = BeanUtil.getGetMethod(aClass, fieldName);
                    this._lastClass = aClass;
                    this._lastField = fieldName;
                    this._lastMethod = getMethod;
                }
            }
            if (getMethod != null) {
                return getMethod.invoke(aObj, (Object[])null);
            }
        }
        catch (Exception e) {
            return ArrayExpr.invocationError(e);
        }
        try {
            getMethod = aClass.getMethod("get", String.class);
            if (getMethod != null) {
                return getMethod.invoke(aObj, fieldName);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            return ArrayExpr.invocationError(e);
        }
        try {
            getMethod = aClass.getMethod("get", Object.class);
            if (getMethod != null) {
                return getMethod.invoke(aObj, fieldObj);
            }
        }
        catch (Exception e) {
            return ArrayExpr.invocationError(e);
        }
        ELException e = new ELException(L.l("no get method {0} for class {1}", (Object)fieldName, (Object)aClass.getName()));
        ArrayExpr.error((Throwable)e, env);
        return null;
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.ArrayExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ArrayExpr)) {
            return false;
        }
        ArrayExpr expr = (ArrayExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    @Override
    public String toString() {
        return (Object)((Object)this._left) + "[" + (Object)((Object)this._right) + "]";
    }
}

