/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.el.PathExpr;
import com.caucho.el.StringLiteral;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;

public class IdExpr
extends Expr {
    private String _id;

    public IdExpr(String id) {
        this._id = id;
    }

    public boolean isReadOnly(ELContext env) {
        boolean result = env.getELResolver().isReadOnly(env, null, (Object)this._id);
        if (!env.isPropertyResolved()) {
            throw new PropertyNotFoundException(L.l("'{0}' not found in context '{1}'.", (Object)this._id, (Object)env));
        }
        return result;
    }

    public Expr createField(String field) {
        Expr arrayExpr = this.createField(new StringLiteral(field));
        return new PathExpr(arrayExpr, this._id + '.' + field);
    }

    public Class getType(ELContext env) throws ELException {
        return env.getELResolver().getType(env, null, (Object)this._id);
    }

    public Object getValue(ELContext env) throws ELException {
        return env.getELResolver().getValue(env, null, (Object)this._id);
    }

    public void setValue(ELContext env, Object value) throws ELException {
        ELResolver resolver = env.getELResolver();
        resolver.setValue(env, null, (Object)this._id, value);
        if (!env.isPropertyResolved()) {
            throw new PropertyNotFoundException(L.l("'{0}' not found in context '{1}'.", (Object)this._id, (Object)env));
        }
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.IdExpr(\"");
        IdExpr.printEscapedString(os, this._id);
        os.print("\")");
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(IdExpr.class)) {
            return false;
        }
        IdExpr expr = (IdExpr)((Object)o);
        return this._id.equals(expr._id);
    }

    public String toString() {
        return this._id;
    }
}

