/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.el.ELContext;
import javax.el.ELException;

public class MatchesExpr
extends AbstractBooleanExpr {
    private final Expr _left;
    private final Expr _right;

    public MatchesExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public boolean evalBoolean(ELContext env) throws ELException {
        Object aObj = this._left.getValue(env);
        Object bObj = this._right.getValue(env);
        if (aObj == null || bObj == null) {
            return false;
        }
        String a = MatchesExpr.toString(aObj, env);
        String b = MatchesExpr.toString(bObj, env);
        try {
            return Pattern.compile(b).matcher(a).find();
        }
        catch (PatternSyntaxException e) {
            throw new ELException((Throwable)e);
        }
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.MatchesExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof MatchesExpr)) {
            return false;
        }
        MatchesExpr expr = (MatchesExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    public String toString() {
        return "(" + (Object)((Object)this._left) + " matches " + (Object)((Object)this._right) + ")";
    }
}

