/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.inject;

import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class RequestContext
extends AbstractScopeContext {
    private static final L10N L = new L10N(RequestContext.class);
    private static final ThreadLocal<RequestContext> _threadLocal = new ThreadLocal();
    private ContextContainer _context;
    private int _depth;

    public static void begin() {
        RequestContext request = _threadLocal.get();
        if (request == null) {
            request = new RequestContext();
            _threadLocal.set(request);
        }
        ++request._depth;
    }

    public static void end() {
        RequestContext request = _threadLocal.get();
        if (request == null) {
            throw new IllegalStateException(L.l("end() requires a matching begin()"));
        }
        if (--request._depth == 0) {
            ContextContainer context = request._context;
            request._context = null;
            if (context != null) {
                context.close();
            }
        }
    }

    @Override
    public boolean isActive() {
        RequestContext request = _threadLocal.get();
        return request != null && request._depth > 0;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    protected ContextContainer getContextContainer() {
        RequestContext request = _threadLocal.get();
        if (request != null) {
            return request._context;
        }
        return null;
    }

    @Override
    protected ContextContainer createContextContainer() {
        RequestContext request = _threadLocal.get();
        if (request._context == null) {
            request._context = new ContextContainer();
        }
        return request._context;
    }
}

