/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.GenClass;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassGenerator {
    private static final L10N L = new L10N(JavaClassGenerator.class);
    private static final Logger log = Logger.getLogger(JavaClassGenerator.class.getName());
    private ClassLoader _parentLoader;
    private ClassLoader _loader;
    private String _encoding;
    private Path _searchPath;
    private Path _workPath;
    private ArrayList<String> _pendingFiles = new ArrayList();
    private String _initMethod = "_caucho_init";
    private String _isModifiedMethod = "_caucho_is_modified";

    public static String cleanClassName(String className) {
        StringBuilder cb = new StringBuilder();
        for (int i = 0; i < className.length(); ++i) {
            char ch = className.charAt(i);
            if (ch == '.' || ch == '/') {
                cb.append('.');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(ch);
                continue;
            }
            cb.append('_');
        }
        return cb.toString();
    }

    public static Path getDefaultSearchPath() {
        MergePath mergePath = new MergePath();
        mergePath.addMergePath(Vfs.lookup());
        mergePath.addClassPath();
        return mergePath;
    }

    public void setSearchPath(Path path) {
        this._searchPath = path;
    }

    public Path getSearchPath() {
        return this._searchPath;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setParentLoader(ClassLoader loader) {
        if (loader instanceof EnhancingClassLoader) {
            EnhancingClassLoader enhancingClassLoader = (EnhancingClassLoader)loader;
        }
        this._parentLoader = loader;
    }

    public void setLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public ClassLoader getParentLoader() {
        if (this._parentLoader == null) {
            this._parentLoader = Thread.currentThread().getContextClassLoader();
        }
        return this._parentLoader;
    }

    public ClassLoader getPreloadLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void setWorkDir(Path workPath) {
        this._workPath = workPath;
    }

    public Path getWorkDir() {
        if (this._workPath == null) {
            return CauchoSystem.getWorkPath();
        }
        return this._workPath;
    }

    public Class<?> preload(String fullClassName) {
        try {
            Class<?> cl = this.loadClass(fullClassName, true);
            if (cl != null) {
                Constructor<?>[] constructorArray = cl.getConstructors();
            }
            return cl;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
        catch (ClassFormatError e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    public Class<?> load(String fullClassName) {
        try {
            Class<?> cl = this.loadClass(fullClassName, false);
            if (cl != null) {
                Constructor<?>[] constructorArray = cl.getConstructors();
            }
            return cl;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
        catch (ClassFormatError e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    public Path getClassFilePath(String className) {
        String classPathName = className.replace('.', '/') + ".class";
        return this.getWorkDir().lookup(classPathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(GenClass javaClass) throws Exception {
        String className = javaClass.getFullClassName();
        String javaPathName = className.replace('.', '/') + ".java";
        String classPathName = className.replace('.', '/') + ".class";
        Path javaPath = this.getWorkDir().lookup(javaPathName);
        Path classPath = this.getWorkDir().lookup(classPathName);
        try {
            classPath.remove();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        javaPath.getParent().mkdirs();
        WriteStream os = javaPath.openWrite();
        try {
            if (this._encoding != null) {
                os.setEncoding(this._encoding);
            } else {
                os.setEncoding("JAVA");
            }
            JavaWriter out = new JavaWriter(os);
            javaClass.generate(out);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            os.close();
            throw throwable;
        }
        os.close();
        this._pendingFiles.add(javaPathName);
    }

    public void addPendingFile(String javaPath) {
        this._pendingFiles.add(javaPath);
    }

    public Class compile(String fullClassName) throws Exception {
        this.compileJava(fullClassName);
        return this.loadClass(fullClassName, false);
    }

    public void compileJava(String fullClassName) throws IOException, ClassNotFoundException {
        JavaCompilerUtil compiler = JavaCompilerUtil.create(this.getPreloadLoader());
        compiler.setClassLoader(this.getPreloadLoader());
        compiler.setClassDir(this.getWorkDir());
        if (this._encoding != null) {
            compiler.setEncoding(this._encoding);
        }
        compiler.compile(fullClassName.replace('.', '/') + ".java", null);
    }

    public String[] getPendingFiles() {
        String[] files = new String[this._pendingFiles.size()];
        this._pendingFiles.toArray(files);
        this._pendingFiles.clear();
        return files;
    }

    public void addPendingFiles(String[] files) {
        for (String file : files) {
            this._pendingFiles.add(file);
        }
    }

    public void compilePendingJava() throws IOException, ClassNotFoundException {
        JavaCompilerUtil compiler = JavaCompilerUtil.create(this.getPreloadLoader());
        compiler.setClassLoader(this.getPreloadLoader());
        compiler.setClassDir(this.getWorkDir());
        if (this._encoding != null) {
            compiler.setEncoding(this._encoding);
        }
        String[] files = new String[this._pendingFiles.size()];
        this._pendingFiles.toArray(files);
        this._pendingFiles.clear();
        compiler.compileBatch(files);
    }

    public Class<?> loadClass(String fullClassName) throws ClassNotFoundException {
        return this.loadClass(fullClassName, false);
    }

    public boolean preloadExists(String fullClassName) {
        Path workDir = this.getWorkDir();
        String classFile = fullClassName.replace('.', '/') + ".class";
        return workDir.lookup(classFile).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> loadClass(String fullClassName, boolean preload) throws ClassNotFoundException {
        Class<?> clazz;
        DynamicClassLoader preloadLoader;
        block19: {
            Class<?> clazz2;
            block18: {
                Class<?> clazz3;
                block17: {
                    preloadLoader = null;
                    try {
                        Class<?> clazz4;
                        block16: {
                            try {
                                ClassLoader loader;
                                if (preload) {
                                    preloadLoader = SimpleLoader.create(this.getPreloadLoader(), this.getWorkDir(), fullClassName);
                                    preloadLoader.setServletHack(true);
                                    loader = preloadLoader;
                                } else {
                                    loader = this.getClassLoader();
                                    if (loader == null) {
                                        loader = SimpleLoader.create(this.getParentLoader(), this.getWorkDir(), fullClassName);
                                    }
                                }
                                Class<?> cl = Class.forName(fullClassName, false, loader);
                                if (cl == null) {
                                    clazz4 = null;
                                    Object var8_16 = null;
                                    if (preloadLoader == null) return clazz4;
                                    break block16;
                                }
                                if (!preload) {
                                    clazz3 = cl;
                                    break block17;
                                }
                                if (this.isModified(cl)) {
                                    clazz2 = null;
                                    break block18;
                                }
                                loader = this._loader != null ? this._loader : SimpleLoader.create(this.getParentLoader(), this.getWorkDir(), fullClassName);
                                clazz = cl = Class.forName(fullClassName, false, loader);
                                break block19;
                            }
                            catch (RuntimeException e) {
                                if (!preload) {
                                    throw e;
                                }
                                log.log(Level.FINE, e.toString(), e);
                                Class<?> clazz5 = null;
                                Object var8_20 = null;
                                if (preloadLoader == null) return clazz5;
                                preloadLoader.destroy();
                                return clazz5;
                            }
                            catch (Error e) {
                                if (!preload) {
                                    throw e;
                                }
                                log.log(Level.FINE, e.toString(), e);
                                Class<?> clazz6 = null;
                                Object var8_21 = null;
                                if (preloadLoader == null) return clazz6;
                                preloadLoader.destroy();
                                return clazz6;
                            }
                            catch (ClassNotFoundException e) {
                                if (!preload) {
                                    throw e;
                                }
                                Class<?> clazz7 = null;
                                Object var8_22 = null;
                                if (preloadLoader == null) return clazz7;
                                preloadLoader.destroy();
                                return clazz7;
                            }
                        }
                        preloadLoader.destroy();
                        return clazz4;
                    }
                    catch (Throwable throwable) {
                        Object var8_23 = null;
                        if (preloadLoader == null) throw throwable;
                        preloadLoader.destroy();
                        throw throwable;
                    }
                }
                Object var8_17 = null;
                if (preloadLoader == null) return clazz3;
                preloadLoader.destroy();
                return clazz3;
            }
            Object var8_18 = null;
            if (preloadLoader == null) return clazz2;
            preloadLoader.destroy();
            return clazz2;
        }
        Object var8_19 = null;
        if (preloadLoader == null) return clazz;
        preloadLoader.destroy();
        return clazz;
    }

    public Class<?> preloadClassParentLoader(String fullClassName, Class<?> parentClass) {
        try {
            Class<?> cl = this.loadClassParentLoader(fullClassName, parentClass);
            if (!this.isModified(cl)) {
                return cl;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.ALL, e.toString(), e);
            return null;
        }
    }

    public Class<?> loadClassParentLoader(String fullClassName, Class<?> parentClass) throws ClassNotFoundException {
        ClassLoader parentLoader = parentClass.getClassLoader();
        if (!(parentLoader instanceof DynamicClassLoader)) {
            throw new IllegalStateException(parentClass + " must belong to a Resin class loader " + parentLoader);
        }
        DynamicClassLoader dynParentLoader = (DynamicClassLoader)parentLoader;
        SimpleLoader simpleLoader = new SimpleLoader(dynParentLoader, this.getWorkDir(), fullClassName);
        simpleLoader.init();
        return Class.forName(fullClassName, false, dynParentLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isModified(Class<?> cl) {
        Path searchPath = this.getSearchPath();
        if (searchPath == null) {
            searchPath = JavaClassGenerator.getDefaultSearchPath();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                if (this._parentLoader != null) {
                    thread.setContextClassLoader(this._parentLoader);
                }
                Method method = cl.getMethod(this._initMethod, Path.class);
                method.invoke(null, searchPath);
                method = cl.getMethod(this._isModifiedMethod, new Class[0]);
                Boolean value = (Boolean)method.invoke(null, new Object[0]);
                boolean bl = value;
                Object var9_12 = null;
                thread.setContextClassLoader(oldLoader);
                return bl;
            }
            catch (NoSuchMethodException e) {
                boolean bl = false;
                Object var9_13 = null;
                thread.setContextClassLoader(oldLoader);
                return bl;
            }
            catch (Throwable e) {
                log.warning(e.toString());
                boolean bl = true;
                Object var9_14 = null;
                thread.setContextClassLoader(oldLoader);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }
}

