/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.Jmx;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanAttributeResolver
extends ELResolver {
    private static final Logger log = Logger.getLogger(MBeanAttributeResolver.class.getName());
    private MBeanServer _mBeanServer;

    public MBeanAttributeResolver() {
        this._mBeanServer = Jmx.getGlobalMBeanServer();
    }

    public MBeanAttributeResolver(MBeanServer mBeanServer) {
        this._mBeanServer = mBeanServer;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof ObjectName) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        MBeanAttributeInfo[] attribs;
        ArrayList<FeatureDescriptor> featureDescriptors = new ArrayList<FeatureDescriptor>();
        if (!(base instanceof ObjectName)) {
            return featureDescriptors.iterator();
        }
        ObjectName objectName = (ObjectName)base;
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this._mBeanServer.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return featureDescriptors.iterator();
        }
        for (MBeanAttributeInfo attrib : attribs = mBeanInfo.getAttributes()) {
            String name = attrib.getName();
            FeatureDescriptor desc = new FeatureDescriptor();
            desc.setName(name);
            desc.setDisplayName(name);
            desc.setShortDescription("");
            desc.setExpert(false);
            desc.setHidden(false);
            desc.setPreferred(true);
            desc.setValue("type", String.class);
            desc.setValue("resolvableAtDesignTime", Boolean.TRUE);
            featureDescriptors.add(desc);
        }
        return featureDescriptors.iterator();
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (!(base instanceof ObjectName)) {
            return null;
        }
        context.setPropertyResolved(true);
        return Object.class;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (!(base instanceof ObjectName)) {
            return null;
        }
        context.setPropertyResolved(true);
        ObjectName objectName = (ObjectName)base;
        Object value = null;
        try {
            value = this._mBeanServer.getAttribute(objectName, String.valueOf(property));
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return value;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof ObjectName) {
            context.setPropertyResolved(true);
        }
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof ObjectName) {
            context.setPropertyResolved(true);
        }
        throw new PropertyNotWritableException(String.valueOf(base));
    }
}

