/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.JarListLoader;
import com.caucho.make.DependencyContainer;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configurable
public class TreeLoader
extends JarListLoader
implements Dependency {
    private static final L10N L = new L10N(TreeLoader.class);
    private Path _dir;
    private DependencyContainer _dependencyList = new DependencyContainer();

    public TreeLoader() {
    }

    public TreeLoader(ClassLoader loader) {
        super(loader);
    }

    public TreeLoader(ClassLoader loader, Path dir) {
        super(loader);
        this._dir = dir;
        this.init();
    }

    public void setPath(Path path) {
        this._dir = path;
    }

    public Path getPath() {
        return this._dir;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path dir) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        TreeLoader treeLoader = new TreeLoader(loader, dir);
        loader.addLoader(treeLoader);
        loader.init();
        return loader;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        if (this._dir == null) {
            throw new ConfigException(L.l("<tree-loader> requires a 'path' attribute"));
        }
        this._dir.getLastModified();
        try {
            this._dir.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fillJars();
        for (int i = 0; i < this._jarList.size(); ++i) {
            this.getClassLoader().addURL(((JarEntry)this._jarList.get(i)).getJarPath());
        }
    }

    @Override
    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._dir.getNativePath() + " has modified jar files");
            return true;
        }
        return false;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._dependencyList.isModified();
    }

    private void fillJars() {
        this.clearJars();
        this.fillJars(this._dir);
    }

    private void fillJars(Path dir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        this.fillJars(paths, dir);
        Collections.sort(paths);
        for (Path path : paths) {
            this.addJar(path);
        }
    }

    private void fillJars(ArrayList<Path> paths, Path dir) {
        try {
            this.addDependency(dir);
            String[] list = dir.list();
            for (int j = 0; list != null && j < list.length; ++j) {
                Path path = dir.lookup(list[j]);
                if (list[j].endsWith(".jar") || list[j].endsWith(".zip")) {
                    paths.add(path);
                    continue;
                }
                if (!path.isDirectory()) continue;
                this.fillJars(paths, path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addDependency(Path path) {
        this._dependencyList.add(new Depend(path));
    }

    public Path getCodePath() {
        return this._dir;
    }

    @Override
    protected void destroy() {
        super.destroy();
        this.clearJars();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._dir + "]";
    }
}

