/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LevelHandler
extends Handler {
    private final Handler[] _handlers;

    public LevelHandler(Level level, Handler[] handlers) {
        this._handlers = handlers;
        this.setLevel(level);
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int level = this.getLevel().intValue();
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            if (level > handler.getLevel().intValue()) continue;
            handler.publish(record);
        }
    }

    public void flush() {
        int level = this.getLevel().intValue();
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            if (level > handler.getLevel().intValue()) continue;
            handler.flush();
        }
    }

    public void close() {
    }
}

