/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.RotateLog;
import com.caucho.log.TimestampFilter;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.annotation.PostConstruct;

public class StdoutLog
extends RotateLog {
    private boolean _isSkipInit;
    private String _timestamp;

    public StdoutLog() {
        this(false);
    }

    public StdoutLog(boolean isSkipInit) {
        this._isSkipInit = isSkipInit;
    }

    public String getTagName() {
        return "stdout-log";
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    @PostConstruct
    public void init() throws ConfigException, IOException {
        super.init();
        if (!this._isSkipInit) {
            this.initImpl();
        }
    }

    public void initImpl() throws ConfigException, IOException {
        WriteStream out = this.getRotateStream().getStream();
        if (this._timestamp != null) {
            out = new WriteStream(new TimestampFilter(out, this._timestamp));
        }
        EnvironmentStream.setStdout(out);
    }
}

