/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.GoogleEnv;
import com.caucho.quercus.lib.db.JdbcDriverContext;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpServletResponse;
import com.caucho.vfs.GoogleMergePath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;

public class GoogleQuercus
extends QuercusContext {
    public void init() {
        String gsBucket;
        String mode = System.getProperty("com.google.appengine.tools.development.ApplicationPreparationMode");
        boolean isGsDisabled = "true".equals(mode);
        if (!isGsDisabled && (gsBucket = this.getIniString("google.cloud_storage_bucket")) != null) {
            Path stdPwd = this.getPwd();
            GoogleMergePath mergePwd = new GoogleMergePath(stdPwd, gsBucket, true);
            this.setPwd(mergePwd);
            Path webInfDir = this.getWebInfDir();
            Path gsWebInfDir = mergePwd.getGooglePath().lookup("WEB-INF");
            MergePath mergeWebInf = new MergePath(gsWebInfDir, webInfDir);
            this.setWebInfDir(mergeWebInf);
        }
        super.init();
        JdbcDriverContext jdbcDriverContext = this.getJdbcDriverContext();
        String driver = this.getIniString("google.jdbc_driver");
        if (driver == null) {
            driver = "com.google.appengine.api.rdbms.AppEngineDriver";
        }
        jdbcDriverContext.setDefaultDriver(driver);
        jdbcDriverContext.setDefaultUrlPrefix("jdbc:google:rdbms://");
        jdbcDriverContext.setDefaultEncoding(null);
        jdbcDriverContext.setProtocol("mysql", driver);
        jdbcDriverContext.setProtocol("google:rdbms", driver);
    }

    public Env createEnv(QuercusPage page, WriteStream out, QuercusHttpServletRequest request, QuercusHttpServletResponse response) {
        return new GoogleEnv(this, page, out, request, response);
    }
}

