/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderStream;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.env.UnsetUnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.Locale;

public class UnicodeBuilderValue
extends UnicodeValue {
    public static final UnicodeBuilderValue EMPTY = new UnicodeBuilderValue("");
    private static final UnicodeBuilderValue[] CHAR_STRINGS = new UnicodeBuilderValue[256];
    private char[] _buffer;
    private int _length;
    protected boolean _isCopy;
    private int _hashCode;

    public UnicodeBuilderValue() {
        this._buffer = new char[32];
    }

    public UnicodeBuilderValue(int capacity) {
        if (capacity < 32) {
            capacity = 32;
        }
        this._buffer = new char[capacity];
    }

    public UnicodeBuilderValue(String s) {
        int len = s.length();
        this._buffer = new char[len];
        this._length = len;
        s.getChars(0, len, this._buffer, 0);
    }

    public UnicodeBuilderValue(char[] buffer, int offset, int length) {
        this._buffer = new char[length];
        this._length = length;
        System.arraycopy(buffer, offset, this._buffer, 0, length);
    }

    public UnicodeBuilderValue(char[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public UnicodeBuilderValue(char[] buffer, int length) {
        this(buffer, 0, length);
    }

    public UnicodeBuilderValue(Character[] buffer) {
        int length = buffer.length;
        this._buffer = new char[length];
        this._length = length;
        for (int i = 0; i < length; ++i) {
            this._buffer[i] = buffer[i].charValue();
        }
    }

    public UnicodeBuilderValue(char ch) {
        this._buffer = new char[1];
        this._length = 1;
        this._buffer[0] = ch;
    }

    public UnicodeBuilderValue(char[] s, Value v1) {
        int bufferLength;
        int len = s.length;
        for (bufferLength = 32; bufferLength < len; bufferLength *= 2) {
        }
        this._buffer = new char[bufferLength];
        this._length = len;
        System.arraycopy(s, 0, this._buffer, 0, len);
        v1.appendTo(this);
    }

    public UnicodeBuilderValue(Value v1) {
        this._buffer = new char[32];
        v1.appendTo(this);
    }

    public UnicodeBuilderValue(UnicodeBuilderValue v) {
        if (v._isCopy) {
            this._buffer = new char[v._buffer.length];
            System.arraycopy(v._buffer, 0, this._buffer, 0, v._length);
            this._length = v._length;
        } else {
            this._buffer = v._buffer;
            this._length = v._length;
            v._isCopy = true;
        }
    }

    public UnicodeBuilderValue(StringBuilderValue v, boolean isCopy) {
        byte[] vBuffer = v.getBuffer();
        int vOffset = v.length();
        this._buffer = new char[vBuffer.length];
        System.arraycopy(vBuffer, 0, this._buffer, 0, vOffset);
        this._length = vOffset;
    }

    public static StringValue create(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new UnicodeBuilderValue(value);
    }

    public static Value create(String value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (value.length() == 0) {
            return EMPTY;
        }
        return new UnicodeBuilderValue(value);
    }

    public StringValue create(Env env, StringValue str, String charset) {
        return str;
    }

    public final StringValue convertToUnicode(Env env, String charset) {
        return this;
    }

    public final boolean isUnicode() {
        return true;
    }

    public final String getValue() {
        return this.toString();
    }

    public String getType() {
        return "string";
    }

    public ValueType getValueType() {
        return UnicodeBuilderValue.getValueType(this._buffer, 0, this._length);
    }

    public StringValue toStringBuilder() {
        return new UnicodeBuilderValue(this);
    }

    public StringValue toStringBuilder(Env env) {
        return new UnicodeBuilderValue(this);
    }

    public StringValue toStringBuilder(Env env, Value value) {
        UnicodeBuilderValue v = new UnicodeBuilderValue(this);
        value.appendTo(v);
        return v;
    }

    public StringValue copyStringBuilder() {
        return new UnicodeBuilderValue(this);
    }

    public final StringValue toUnicodeValue() {
        return this;
    }

    public final StringValue toUnicodeValue(Env env) {
        return this;
    }

    public final StringValue toUnicodeValue(Env env, String charset) {
        return this;
    }

    public final StringValue append(byte[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        char[] charBuffer = this._buffer;
        int charLength = this._length;
        for (int i = 0; i < length; ++i) {
            charBuffer[charLength + i] = (char)(buf[offset + i] & 0xFF);
        }
        this._length += length;
        return this;
    }

    public StringValue append(Value v) {
        v.appendTo(this);
        return this;
    }

    public StringValue append(String s) {
        int len = s.length();
        if (this._buffer.length < this._length + len) {
            this.ensureCapacity(this._length + len);
        }
        s.getChars(0, len, this._buffer, this._length);
        this._length += len;
        return this;
    }

    public StringValue append(String s, int start, int end) {
        int len = Math.min(s.length(), end - start);
        if (this._buffer.length < this._length + len) {
            this.ensureCapacity(this._length + len);
        }
        s.getChars(start, start + len, this._buffer, this._length);
        this._length += len;
        return this;
    }

    public StringValue append(char v) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = v;
        return this;
    }

    public StringValue append(char[] buf, int offset, int length) {
        if (this._buffer.length < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(buf, offset, this._buffer, this._length, length);
        this._length += length;
        return this;
    }

    public StringValue append(char[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public StringValue append(CharSequence buf, int head, int tail) {
        int len = tail - head;
        if (this._buffer.length < this._length + len) {
            this.ensureAppendCapacity(len);
        }
        char[] buffer = this._buffer;
        int bufferLength = this._length;
        while (head < tail) {
            buffer[bufferLength++] = buf.charAt(head);
            ++head;
        }
        this._length = bufferLength;
        return this;
    }

    public StringValue append(UnicodeBuilderValue sb, int head, int tail) {
        int len = tail - head;
        if (this._buffer.length < this._length + len) {
            this.ensureAppendCapacity(len);
        }
        System.arraycopy(sb._buffer, head, this._buffer, this._length, len);
        this._length += len;
        return this;
    }

    public StringValue append(Env env, StringValue unicodeStr, String charset) {
        return this.append(unicodeStr);
    }

    public StringValue appendTo(UnicodeBuilderValue sb) {
        sb.append(this._buffer, 0, this._length);
        return sb;
    }

    public StringValue append(Reader reader, long length) throws IOException {
        int sublen = (int)Math.min((long)this._length, length);
        try {
            while (length > 0L) {
                int count;
                if (this._buffer.length < this._length + sublen) {
                    this.ensureCapacity(this._length + sublen);
                }
                if ((count = reader.read(this._buffer, this._length, sublen)) > 0) {
                    length -= (long)count;
                    this._length += count;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        return this;
    }

    public StringValue appendByte(int v) {
        if (this._buffer.length < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (char)v;
        return this;
    }

    public final boolean isEmpty() {
        return this._length == 0 || this._length == 1 && this._buffer[0] == '0';
    }

    public Value toKey() {
        char[] buffer = this._buffer;
        int len = this._length;
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        char ch = buffer[i];
        if (ch == '-') {
            if (len == 1) {
                return this;
            }
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = buffer[i];
            if ('0' > ch || ch > '9') {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return LongValue.create((long)sign * value);
    }

    public final byte[] toBytes() {
        byte[] bytes = new byte[this._length];
        for (int i = 0; i < this._length; ++i) {
            bytes[i] = (byte)(this._buffer[i] & 0xFF);
        }
        return bytes;
    }

    public final Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    public Value put(Value index, Value value) {
        this.setCharValueAt(index.toLong(), value);
        return value;
    }

    public Value append(Value index, Value value) {
        if (this._length > 0) {
            return this.setCharValueAt(index.toLong(), value);
        }
        return new ArrayValueImpl().append(index, value);
    }

    public final char[] getBuffer() {
        return this._buffer;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getBufferLength() {
        return this._buffer.length;
    }

    public StringValue toBinaryValue() {
        return this.toBinaryValue(Env.getInstance());
    }

    public StringValue toBinaryValue(Env env) {
        return this.toBinaryValue(env.getRuntimeEncoding());
    }

    public StringValue toBinaryValue(String charset) {
        try {
            BinaryBuilderValue result = new BinaryBuilderValue();
            BinaryBuilderStream stream = new BinaryBuilderStream(result);
            WriteStream out = new WriteStream(stream);
            out.setEncoding(charset);
            out.print(this._buffer, 0, this._length);
            out.close();
            return result;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    public Value charValueAt(long index) {
        int len = this._length;
        if (index < 0L || (long)len <= index) {
            return UnsetUnicodeValue.UNSET;
        }
        char ch = this._buffer[(int)index];
        if (ch < CHAR_STRINGS.length) {
            return CHAR_STRINGS[ch];
        }
        return new UnicodeBuilderValue(ch);
    }

    public Value setCharValueAt(long indexL, Value value) {
        int len = this._length;
        if (indexL < 0L) {
            return this;
        }
        if (indexL < (long)len) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue(this._buffer, 0, len);
            StringValue str = value.toStringValue();
            int index = (int)indexL;
            sb._buffer[index] = value.length() == 0 ? (char)'\u0000' : str.charAt(0);
            return sb;
        }
        int index = (int)indexL;
        UnicodeBuilderValue sb = (UnicodeBuilderValue)this.copyStringBuilder();
        if (sb._buffer.length < index + 1) {
            sb.ensureCapacity(index + 1);
        }
        int padLen = index - len;
        for (int i = 0; i <= padLen; ++i) {
            sb._buffer[sb._length++] = 32;
        }
        StringValue str = value.toStringValue();
        sb._buffer[index] = value.length() == 0 ? (char)'\u0000' : str.charAt(0);
        return sb;
    }

    public final int length() {
        return this._length;
    }

    public char charAt(int index) {
        return this._buffer[index];
    }

    public CharSequence subSequence(int start, int end) {
        int len = end - start;
        if (len == 0) {
            return EMPTY;
        }
        UnicodeBuilderValue sb = new UnicodeBuilderValue(len);
        sb.append(this._buffer, start, len);
        return sb;
    }

    public StringValue toLowerCase(Locale locale) {
        int length = this._length;
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] srcBuffer = this._buffer;
        char[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            char ch = srcBuffer[i];
            dstBuffer[i] = 'A' <= ch && ch <= 'Z' ? (char)(ch + 97 - 65) : (ch < '\u0080' ? ch : (Character.isUpperCase(ch) ? Character.toLowerCase(ch) : ch));
        }
        string._length = length;
        return string;
    }

    public StringValue toUpperCase() {
        int length = this._length;
        UnicodeBuilderValue string = new UnicodeBuilderValue(this._length);
        char[] srcBuffer = this._buffer;
        char[] dstBuffer = string._buffer;
        for (int i = 0; i < length; ++i) {
            char ch = srcBuffer[i];
            dstBuffer[i] = 'a' <= ch && ch <= 'z' ? (char)(ch + 65 - 97) : (ch < '\u0080' ? ch : (Character.isLowerCase(ch) ? Character.toUpperCase(ch) : ch));
        }
        string._length = length;
        return string;
    }

    public char[] toCharArray() {
        char[] dest = new char[this._length];
        System.arraycopy(this._buffer, 0, dest, 0, this._length);
        return dest;
    }

    public char[] getRawCharArray() {
        return this._buffer;
    }

    public void print(Env env) {
        env.print(this._buffer, 0, this._length);
    }

    public void serialize(Env env, StringBuilder sb) {
        sb.append("U:");
        sb.append(this._length);
        sb.append(":\"");
        sb.append(this._buffer, 0, this._length);
        sb.append("\";");
    }

    public StringValue createStringBuilder() {
        return new UnicodeBuilderValue();
    }

    public StringValue createStringBuilder(int length) {
        return new UnicodeBuilderValue(length);
    }

    public static int getNumericType(char[] buffer, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int i = offset;
        char ch = '\u0000';
        if (i < len && ((ch = buffer[i]) == '+' || ch == '-')) {
            ++i;
        }
        if (len <= i) {
            return 0;
        }
        ch = buffer[i];
        if (ch == '.') {
            if (++i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
                return 2;
            }
            return 0;
        }
        if ('0' > ch || ch > '9') {
            return 0;
        }
        while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
            ++i;
        }
        if (len <= i) {
            return 1;
        }
        if (ch == '.' || ch == 'e' || ch == 'E') {
            ++i;
            while (i < len && ('0' <= (ch = buffer[i]) && ch <= '9' || ch == '+' || ch == '-' || ch == 'e' || ch == 'E')) {
                ++i;
            }
            if (i < len) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public static ValueType getValueType(char[] buffer, int offset, int len) {
        int i;
        if (len == 0) {
            return ValueType.LONG_ADD;
        }
        char ch = '\u0000';
        for (i = offset; i < len && Character.isWhitespace(buffer[i]); ++i) {
        }
        if (i < len && ((ch = buffer[i]) == '+' || ch == '-')) {
            ++i;
        }
        if (len <= i) {
            return ValueType.STRING;
        }
        ch = buffer[i];
        if (ch == '.') {
            if (++i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
                return ValueType.DOUBLE_CMP;
            }
            return ValueType.STRING;
        }
        if ('0' > ch || ch > '9') {
            return ValueType.STRING;
        }
        while (i < len && '0' <= (ch = buffer[i]) && ch <= '9') {
            ++i;
        }
        while (i < len && Character.isWhitespace(buffer[i])) {
            ++i;
        }
        if (len <= i) {
            return ValueType.LONG_EQ;
        }
        if (ch == '.' || ch == 'e' || ch == 'E') {
            ++i;
            while (i < len && ('0' <= (ch = buffer[i]) && ch <= '9' || ch == '+' || ch == '-' || ch == 'e' || ch == 'E')) {
                ++i;
            }
            while (i < len && Character.isWhitespace(buffer[i])) {
                ++i;
            }
            if (i < len) {
                return ValueType.STRING;
            }
            return ValueType.DOUBLE_CMP;
        }
        return ValueType.STRING;
    }

    public final boolean toBoolean() {
        if (this._length == 0) {
            return false;
        }
        return this._length != 1 || this._buffer[0] != '0';
    }

    public long toLong() {
        return UnicodeBuilderValue.parseLong(this._buffer, 0, this._length);
    }

    public static long toLong(char[] buffer, int offset, int len) {
        return UnicodeBuilderValue.parseLong(buffer, offset, len);
    }

    public double toDouble() {
        return UnicodeBuilderValue.toDouble(this._buffer, 0, this._length);
    }

    public static double toDouble(char[] buffer, int offset, int len) {
        int i;
        int start = offset;
        int ch = 0;
        for (i = offset; i < len && Character.isWhitespace(buffer[i]); ++i) {
            ++start;
        }
        int end = len + offset;
        if (offset + 1 < end && buffer[offset] == '0' && ((ch = buffer[offset + 1]) == 120 || ch == 88)) {
            double value = 0.0;
            offset += 2;
            while (offset < end) {
                ch = buffer[offset] & 0xFF;
                if (48 <= ch && ch <= 57) {
                    value = value * 16.0 + (double)ch - 48.0;
                } else if (97 <= ch && ch <= 122) {
                    value = value * 16.0 + (double)ch - 97.0 + 10.0;
                } else if (65 <= ch && ch <= 90) {
                    value = value * 16.0 + (double)ch - 65.0 + 10.0;
                } else {
                    return value;
                }
                ++offset;
            }
            return value;
        }
        if (i < len && ((ch = buffer[i]) == 43 || ch == 45)) {
            ++i;
        }
        while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
            ++i;
        }
        if (ch == 46) {
            ++i;
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == 1) {
                return 0.0;
            }
        }
        if (ch == 101 || ch == 69) {
            int e = i++;
            if (i < len && (ch = buffer[i]) == 43 || ch == 45) {
                ++i;
            }
            while (i < len && 48 <= (ch = buffer[i]) && ch <= 57) {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(new String(buffer, start, i - start));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public void ensureAppendCapacity(int newCapacity) {
        this.ensureCapacity(this._length + newCapacity);
    }

    protected void ensureCapacity(int newCapacity) {
        int bufferLength = this._buffer.length;
        if (newCapacity <= bufferLength) {
            return;
        }
        if (bufferLength < 32) {
            bufferLength = 32;
        }
        while (bufferLength <= newCapacity) {
            bufferLength = 2 * bufferLength;
        }
        char[] buffer = new char[bufferLength];
        System.arraycopy(this._buffer, 0, buffer, 0, this._length);
        this._buffer = buffer;
        this._isCopy = false;
    }

    public int hashCode() {
        int hash = this._hashCode;
        if (hash != 0) {
            return hash;
        }
        hash = 37;
        int length = this._length;
        char[] buffer = this._buffer;
        if (length > 256) {
            int i;
            for (i = 127; i >= 0; --i) {
                hash = 65521 * hash + buffer[i];
            }
            for (i = length - 128; i < length; ++i) {
                hash = 65521 * hash + buffer[i];
            }
            this._hashCode = hash;
            return hash;
        }
        for (int i = length - 1; i >= 0; --i) {
            hash = 65521 * hash + buffer[i];
        }
        this._hashCode = hash;
        return hash;
    }

    public boolean eq(Value rValue) {
        ValueType typeB = (rValue = rValue.toValue()).getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        ValueType typeA = this.getValueType();
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (rValue instanceof UnicodeBuilderValue) {
            UnicodeBuilderValue value = (UnicodeBuilderValue)rValue;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        if (rValue instanceof StringValue) {
            int length = this._length;
            StringValue value = (StringValue)rValue;
            if (length != value.length()) {
                return false;
            }
            char[] buffer = this._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (buffer[i] == value.charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (rValue.isObject()) {
            return super.eq(rValue);
        }
        String rString = rValue.toString();
        int len = rString.length();
        if (this._length != len) {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            if (this._buffer[i] == rString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UnicodeBuilderValue) {
            UnicodeBuilderValue value = (UnicodeBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof StringValue) {
            int len = this._length;
            StringValue str = (StringValue)o;
            if (len != str.length()) {
                return false;
            }
            char[] buffer = this._buffer;
            for (int i = len - 1; i >= 0; --i) {
                if (buffer[i] == str.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean eql(Value o) {
        if ((o = o.toValue()) == this) {
            return true;
        }
        if (o instanceof UnicodeBuilderValue) {
            UnicodeBuilderValue value = (UnicodeBuilderValue)o;
            int length = this._length;
            if (length != value._length) {
                return false;
            }
            char[] bufferA = this._buffer;
            char[] bufferB = value._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (bufferA[i] == bufferB[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof StringValue) {
            int length = this._length;
            StringValue str = (StringValue)o;
            if (length != str.length()) {
                return false;
            }
            char[] buffer = this._buffer;
            for (int i = length - 1; i >= 0; --i) {
                if (buffer[i] == str.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._length = in.readInt();
        this._buffer = new char[this._length];
        for (int i = 0; i < this._length; ++i) {
            this._buffer[i] = (char)(in.read() & 0xFF);
        }
    }

    public String toString() {
        return String.valueOf(this._buffer, 0, this._length);
    }

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            UnicodeBuilderValue.CHAR_STRINGS[i] = new UnicodeBuilderValue((char)i);
        }
    }
}

