/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarNameVirtualConstExpr
extends Expr {
    protected final Expr _name;

    public ClassVarNameVirtualConstExpr(Location location, Expr name) {
        super(location);
        this._name = name;
    }

    public ClassVarNameVirtualConstExpr(Expr name) {
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassVirtualMethodCall(location, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        StringValue name = this._name.evalStringValue(env);
        return env.getCallingClass().getConstant(env, name);
    }

    @Override
    public String toString() {
        return "static::{" + this._name + "}";
    }
}

