/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.QuercusParser;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVarVarConstExpr
extends Expr {
    protected final Expr _className;
    protected final Expr _name;

    public ClassVarVarConstExpr(Expr className, Expr name) {
        this._className = className;
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createClassMethodCall(location, this._className, this._name, args);
    }

    @Override
    public Value eval(Env env) {
        QuercusClass cls = this._className.evalQuercusClass(env);
        return cls.getConstant(env, this._name.evalStringValue(env));
    }

    @Override
    public String toString() {
        return this._className + "::{" + this._name + "}";
    }
}

