/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVirtualMethodExpr
extends Expr {
    private static final L10N L = new L10N(ClassVirtualMethodExpr.class);
    protected final StringValue _methodName;
    private final int _hash;
    protected final Expr[] _args;
    protected boolean _isMethod;

    public ClassVirtualMethodExpr(Location location, StringValue methodName, ArrayList<Expr> args) {
        super(location);
        this._methodName = methodName;
        this._hash = methodName.hashCodeCaseInsensitive();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassVirtualMethodExpr(Location location, StringValue name, Expr[] args) {
        super(location);
        this._methodName = name;
        this._hash = name.hashCodeCaseInsensitive();
        this._args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        Value qThis = env.getThis();
        QuercusClass cls = qThis.getQuercusClass();
        if (cls == null) {
            env.error(L.l("no calling class found"), this.getLocation());
            return NullValue.NULL;
        }
        Value[] values = ClassVirtualMethodExpr.evalArgs(env, this._args);
        env.pushCall(this, cls, values);
        try {
            env.checkTimeout();
            Value value = cls.callMethod(env, qThis, this._methodName, this._hash, values);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return "static::" + this._methodName + "()";
    }
}

