/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExprType {
    INIT{

        public ExprType withLong() {
            return LONG;
        }

        public ExprType withDouble() {
            return DOUBLE;
        }

        public ExprType withType(ExprType type) {
            if (type == INIT) {
                return VALUE;
            }
            return type;
        }

        public String toString() {
            return "ExprType::INIT";
        }
    }
    ,
    LONG{

        public boolean isLong() {
            return true;
        }

        public boolean isDouble() {
            return true;
        }

        public ExprType withLong() {
            return LONG;
        }

        public ExprType withDouble() {
            return DOUBLE;
        }

        public ExprType withType(ExprType type) {
            if (type == LONG) {
                return LONG;
            }
            if (type == DOUBLE) {
                return DOUBLE;
            }
            return VALUE;
        }

        public String toString() {
            return "ExprType::LONG";
        }
    }
    ,
    DOUBLE{

        public boolean isDouble() {
            return true;
        }

        public ExprType withLong() {
            return DOUBLE;
        }

        public ExprType withDouble() {
            return DOUBLE;
        }

        public ExprType withType(ExprType type) {
            if (type == LONG || type == DOUBLE) {
                return DOUBLE;
            }
            return VALUE;
        }

        public String toString() {
            return "ExprType::DOUBLE";
        }
    }
    ,
    BOOLEAN{

        public boolean isBoolean() {
            return true;
        }

        public ExprType withBoolean() {
            return BOOLEAN;
        }

        public ExprType withType(ExprType type) {
            if (type == BOOLEAN) {
                return BOOLEAN;
            }
            return VALUE;
        }

        public String toString() {
            return "ExprType::BOOLEAN";
        }
    }
    ,
    STRING{

        public boolean isString() {
            return true;
        }

        public ExprType withString() {
            return STRING;
        }

        public ExprType withType(ExprType type) {
            if (type == STRING) {
                return STRING;
            }
            return VALUE;
        }

        public String toString() {
            return "ExprType::STRING";
        }
    }
    ,
    VALUE;


    public boolean isBoolean() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public ExprType withBoolean() {
        return VALUE;
    }

    public ExprType withLong() {
        return VALUE;
    }

    public ExprType withDouble() {
        return VALUE;
    }

    public ExprType withString() {
        return VALUE;
    }

    public ExprType withType(ExprType type) {
        return VALUE;
    }
}

