/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpServletResponse;
import com.caucho.util.L10N;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;

public class ApacheModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ApacheModule.class);
    private static final Logger log = Logger.getLogger(ApacheModule.class.getName());

    public boolean apache_child_terminate() {
        return false;
    }

    public Value apache_note(Env env, String name, @Optional Value value) {
        HashMap<String, Value> map = (HashMap<String, Value>)env.getSpecialValue("_caucho_apache_note");
        if (map == null) {
            map = new HashMap<String, Value>();
            env.setSpecialValue("_caucho_apache_note", map);
        }
        Value oldValue = (Value)map.get(name);
        if (value.isset()) {
            map.put(name, value);
        }
        if (oldValue != null) {
            return oldValue.toStringValue(env);
        }
        return NullValue.NULL;
    }

    public Value apache_request_headers(Env env) {
        QuercusHttpServletRequest req = env.getRequest();
        ArrayValueImpl result = new ArrayValueImpl();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.put(env.createString(key), env.createString(req.getHeader(key)));
        }
        return result;
    }

    public boolean apache_reset_timeout() {
        return false;
    }

    public Value getallheaders(Env env) {
        return this.apache_request_headers(env);
    }

    public boolean virtual(Env env, String url) {
        try {
            QuercusHttpServletRequest req = env.getRequest();
            QuercusHttpServletResponse res = env.getResponse();
            env.getOut().flushBuffer();
            req.getRequestDispatcher(url).include(req, res);
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }
}

