/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArrayModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ArrayModule.class);
    private static final Logger log = Logger.getLogger(ArrayModule.class.getName());
    public static final int CASE_UPPER = 2;
    public static final int CASE_LOWER = 1;
    public static final int SORT_REGULAR = 0;
    public static final int SORT_NUMERIC = 1;
    public static final int SORT_STRING = 2;
    public static final int SORT_LOCALE_STRING = 5;
    public static final int SORT_NORMAL = 1;
    public static final int SORT_REVERSE = -1;
    public static final int SORT_DESC = 3;
    public static final int SORT_ASC = 4;
    public static final int EXTR_OVERWRITE = 0;
    public static final int EXTR_SKIP = 1;
    public static final int EXTR_PREFIX_SAME = 2;
    public static final int EXTR_PREFIX_ALL = 3;
    public static final int EXTR_PREFIX_INVALID = 4;
    public static final int EXTR_IF_EXISTS = 6;
    public static final int EXTR_PREFIX_IF_EXISTS = 5;
    public static final int EXTR_REFS = 256;
    public static final int COUNT_NORMAL = 0;
    public static final int COUNT_RECURSIVE = 1;
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;
    public static final boolean KEY_RESET = true;
    public static final boolean NO_KEY_RESET = false;
    public static final boolean STRICT = true;
    public static final boolean NOT_STRICT = false;
    private static final CompareString CS_VALUE_NORMAL = new CompareString(ArrayValue.GET_VALUE, 1);
    private static final CompareString CS_VALUE_REVERSE = new CompareString(ArrayValue.GET_VALUE, -1);
    private static final CompareString CS_KEY_NORMAL = new CompareString(ArrayValue.GET_KEY, 1);
    private static final CompareString CS_KEY_REVERSE = new CompareString(ArrayValue.GET_KEY, -1);
    private static final CompareNumeric CN_VALUE_NORMAL = new CompareNumeric(ArrayValue.GET_VALUE, 1);
    private static final CompareNumeric CN_VALUE_REVERSE = new CompareNumeric(ArrayValue.GET_VALUE, -1);
    private static final CompareNumeric CN_KEY_NORMAL = new CompareNumeric(ArrayValue.GET_KEY, 1);
    private static final CompareNumeric CN_KEY_REVERSE = new CompareNumeric(ArrayValue.GET_KEY, -1);
    private static final CompareNormal CNO_VALUE_NORMAL = new CompareNormal(ArrayValue.GET_VALUE, 1);
    private static final CompareNormal CNO_VALUE_REVERSE = new CompareNormal(ArrayValue.GET_VALUE, -1);
    private static final CompareNormal CNO_KEY_NORMAL = new CompareNormal(ArrayValue.GET_KEY, 1);
    private static final CompareNormal CNO_KEY_REVERSE = new CompareNormal(ArrayValue.GET_KEY, -1);
    private static final CompareNatural CNA_VALUE_NORMAL_SENSITIVE = new CompareNatural(ArrayValue.GET_VALUE, 1, true);
    private static final CompareNatural CNA_VALUE_NORMAL_INSENSITIVE = new CompareNatural(ArrayValue.GET_VALUE, 1, false);

    public String[] getLoadedExtensions() {
        return new String[]{"standard"};
    }

    public static Value array_change_key_case(Env env, ArrayValue array, @Optional(value="CASE_LOWER") int toCase) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value keyValue = entry.getKey();
            if (keyValue instanceof StringValue) {
                String key = keyValue.toString();
                key = toCase == 2 ? key.toUpperCase(Locale.ENGLISH) : key.toLowerCase(Locale.ENGLISH);
                newArray.put(env.createString(key), entry.getValue());
                continue;
            }
            newArray.put(keyValue, entry.getValue());
        }
        return newArray;
    }

    public static Value array_chunk(Env env, ArrayValue array, int size, @Optional boolean preserveKeys) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        ArrayValueImpl currentArray = null;
        if (size < 1) {
            env.warning("Size parameter expected to be greater than 0");
            return NullValue.NULL;
        }
        int i = 0;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue();
            if (i % size == 0) {
                currentArray = new ArrayValueImpl();
                ((ArrayValue)newArray).put(currentArray);
            }
            if (preserveKeys) {
                currentArray.put(key, value);
            } else {
                currentArray.put(LongValue.create(i % size), value);
            }
            ++i;
        }
        return newArray;
    }

    public static Value array_combine(Env env, ArrayValue keys, ArrayValue values) {
        if (keys == null || values == null) {
            return BooleanValue.FALSE;
        }
        if (keys.getSize() < 1 || values.getSize() < 1) {
            env.warning("Both parameters should have at least 1 element");
            return BooleanValue.FALSE;
        }
        if (keys.getSize() != values.getSize()) {
            env.warning("Both parameters should have equal number of elements");
            return BooleanValue.FALSE;
        }
        Iterator<Value> keyIter = keys.values().iterator();
        Iterator<Value> valueIter = values.values().iterator();
        ArrayValueImpl array = new ArrayValueImpl();
        while (keyIter.hasNext() && valueIter.hasNext()) {
            array.put(keyIter.next(), valueIter.next());
        }
        return array;
    }

    public Value array_copy_recursive(Value value) {
        if (!(value = value.toValue()).isArray()) {
            return value;
        }
        ArrayValue array = (ArrayValue)value;
        ArrayValueImpl copy = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            copy.put(entryKey, this.array_copy_recursive(entryValue));
        }
        return copy;
    }

    public static Value array_count_values(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl result = new ArrayValueImpl();
        for (Value value : array.values()) {
            if (!value.isLongConvertible() && !(value instanceof StringValue)) {
                env.warning("Can only count STRING and INTEGER values!");
                continue;
            }
            Value count = ((ArrayValue)result).get(value);
            count = count == null ? LongValue.create(1L) : count.add(1L);
            result.put(value, count);
        }
        return result;
    }

    public static Value array_diff_assoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length && !valueFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                valueFound = ((ArrayValue)arrays[k]).contains(entryValue).eq(entryKey);
            }
            if (valueFound) continue;
            diffArray.put(entryKey, entryValue);
        }
        return diffArray;
    }

    public static Value array_diff_key(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length && !keyFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                keyFound = ((ArrayValue)arrays[k]).containsKey(entryKey) != null;
            }
            if (keyFound) continue;
            diffArray.put(entryKey, entry.getValue());
        }
        return diffArray;
    }

    public static Value array_diff_uassoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        StringValue funName = arrays[arrays.length - 1].toStringValue(env);
        AbstractFunction func = env.findFunction(funName);
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean ValueFound = false;
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length - 1 && !ValueFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                Value searchKey = ((ArrayValue)arrays[k]).contains(entryValue);
                if (searchKey.isNull()) continue;
                ValueFound = (int)func.call(env, searchKey, entryKey).toLong() == 0;
            }
            if (ValueFound) continue;
            diffArray.put(entryKey, entryValue);
        }
        return diffArray;
    }

    public static Value array_diff_ukey(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        StringValue funName = arrays[arrays.length - 1].toStringValue(env);
        AbstractFunction func = env.findFunction(funName);
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length - 1 && !keyFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                Iterator<Value> keyItr = ((ArrayValue)arrays[k]).keySet().iterator();
                keyFound = false;
                while (keyItr.hasNext() && !keyFound) {
                    Value currentKey = keyItr.next();
                    keyFound = (int)func.call(env, entryKey, currentKey).toLong() == 0;
                }
            }
            if (keyFound) continue;
            diffArray.put(entryKey, entry.getValue());
        }
        return diffArray;
    }

    public static Value array_diff(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length && !valueFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                valueFound = !((ArrayValue)arrays[k]).contains(entryValue).isNull();
            }
            if (valueFound) continue;
            diffArray.put(entry.getKey(), entryValue);
        }
        return diffArray;
    }

    public static ArrayValue array_fill_keys(Env env, ArrayValue keyArray, Value value) {
        ArrayValueImpl array = new ArrayValueImpl();
        Iterator<Value> iter = keyArray.getValueIterator(env);
        while (iter.hasNext()) {
            array.put(iter.next(), value.copy());
        }
        return array;
    }

    public static Value array_fill(Env env, long start, long num, Value value) {
        if (num < 0L) {
            env.warning("Number of elements must be positive");
            return BooleanValue.FALSE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        for (long k = start; k < num + start; ++k) {
            array.put(LongValue.create(k), value.copy());
        }
        return array;
    }

    public static Value array_filter(Env env, ArrayValue array, @Optional Value callbackName) {
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl filteredArray = new ArrayValueImpl();
        if (!callbackName.isDefault()) {
            Callable callback = callbackName.toCallable(env, false);
            if (callback == null || !callback.isValid(env)) {
                return NullValue.NULL;
            }
            try {
                Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
                while (iter.hasNext()) {
                    Value value;
                    Map.Entry<Value, Value> entry = iter.next();
                    Value key = entry.getKey();
                    boolean isMatch = callback.callArray(env, array, key, value = entry instanceof ArrayValue.Entry ? ((ArrayValue.Entry)entry).getRawValue() : entry.getValue()).toBoolean();
                    if (!isMatch) continue;
                    filteredArray.put(key, value);
                }
            }
            catch (Exception t) {
                log.log(Level.WARNING, t.toString(), t);
                env.warning("An error occurred while invoking the filter callback");
                return NullValue.NULL;
            }
        } else {
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                if (!entry.getValue().toBoolean()) continue;
                filteredArray.put(entry.getKey(), entry.getValue());
            }
        }
        return filteredArray;
    }

    public static Value array_flip(Env env, ArrayValue array) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value entryValue = entry.getValue();
            if (entryValue.isLongConvertible() || entryValue instanceof StringValue) {
                newArray.put(entryValue, entry.getKey());
                continue;
            }
            env.warning(L.l("Can only flip string and integer values at '{0}'", (Object)entryValue));
        }
        return newArray;
    }

    public static Value array_intersect_assoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryKey = entry.getKey();
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !valueFound) break;
                Value searchValue = ((ArrayValue)arrays[k]).containsKey(entryKey);
                valueFound = searchValue != null ? searchValue.eq(entryValue) : false;
            }
            if (!valueFound) continue;
            interArray.put(entryKey, entryValue);
        }
        return interArray;
    }

    public static Value array_intersect_key(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !keyFound) break;
                keyFound = ((ArrayValue)arrays[k]).containsKey(entryKey) != null;
            }
            if (!keyFound) continue;
            interArray.put(entryKey, entry.getValue());
        }
        return interArray;
    }

    public static Value array_intersect_uassoc(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        StringValue funName = arrays[arrays.length - 1].toStringValue(env);
        AbstractFunction func = env.findFunction(funName);
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryKey = entry.getKey();
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length - 1; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !valueFound) break;
                Value searchValue = ((ArrayValue)arrays[k]).containsKey(entryKey);
                valueFound = searchValue != null ? func.call(env, searchValue, entryValue).toLong() == 0L : false;
            }
            if (!valueFound) continue;
            interArray.put(entryKey, entryValue);
        }
        return interArray;
    }

    public static Value array_intersect_ukey(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 2) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        StringValue funName = arrays[arrays.length - 1].toStringValue(env);
        AbstractFunction func = env.findFunction(funName);
        if (func == null) {
            env.warning("Invalid comparison function");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean keyFound = false;
            Value entryKey = entry.getKey();
            for (int k = 0; k < arrays.length - 1; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !keyFound) break;
                Iterator<Value> keyItr = ((ArrayValue)arrays[k]).keySet().iterator();
                keyFound = false;
                while (keyItr.hasNext() && !keyFound) {
                    Value currentKey = keyItr.next();
                    keyFound = (int)func.call(env, entryKey, currentKey).toLong() == 0;
                }
            }
            if (!keyFound) continue;
            interArray.put(entryKey, entry.getValue());
        }
        return interArray;
    }

    public static Value array_intersect(Env env, ArrayValue array, Value[] arrays) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (arrays.length < 1) {
            env.warning("Wrong parameter count for array_diff()");
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            boolean valueFound = false;
            Value entryValue = entry.getValue();
            for (int k = 0; k < arrays.length; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 2) + " is not an array");
                    return NullValue.NULL;
                }
                if (k > 0 && !valueFound) break;
                valueFound = !((ArrayValue)arrays[k]).contains(entryValue).isNull();
            }
            if (!valueFound) continue;
            interArray.put(entry.getKey(), entryValue);
        }
        return interArray;
    }

    public static boolean array_key_exists(Env env, @ReadOnly Value key, @ReadOnly Value searchArray) {
        if (!searchArray.isset() || !key.isset()) {
            return false;
        }
        if (!key.isString() && !key.isLongConvertible()) {
            env.warning(L.l("The first argument (a '{0}') should be either a string or an integer", (Object)key.getType()));
            return false;
        }
        if (searchArray.isArray()) {
            return searchArray.keyExists(key);
        }
        if (searchArray.isObject()) {
            return searchArray.isFieldExists(env, key.toStringValue(env));
        }
        env.warning(L.l("'" + searchArray.toString() + "' is an unexpected argument, expected " + "ArrayValue or ObjectValue"));
        return false;
    }

    public static Value array_keys(Env env, @ReadOnly ArrayValue array, @Optional @ReadOnly Value searchValue, @Optional boolean isStrict) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (searchValue.isDefault()) {
            return array.getKeys();
        }
        ArrayValueImpl newArray = new ArrayValueImpl(array.getSize());
        int i = 0;
        Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            Value entryKey = entry.getKey();
            Value entryValue = entry.getValue();
            if (!entryValue.eq(searchValue)) continue;
            ((ArrayValue)newArray).append(LongValue.create(i++), entryKey);
        }
        return newArray;
    }

    public static Value array_map(Env env, Callable fun, ArrayValue arg, Value[] args) {
        if (arg == null) {
            return NullValue.NULL;
        }
        Iterator<Map.Entry<Value, Value>> argIter = arg.entrySet().iterator();
        Iterator[] iters = new Iterator[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof ArrayValue)) {
                throw env.createErrorException(L.l("expected array"));
            }
            ArrayValue argArray = (ArrayValue)args[i];
            iters[i] = argArray.values().iterator();
        }
        ArrayValueImpl resultArray = new ArrayValueImpl();
        Value[] param = new Value[args.length + 1];
        while (argIter.hasNext()) {
            Map.Entry<Value, Value> entry = argIter.next();
            param[0] = entry.getValue();
            for (int i = 0; i < iters.length; ++i) {
                param[i + 1] = (Value)iters[i].next();
                if (param[i + 1] != null) continue;
                param[i + 1] = NullValue.NULL;
            }
            resultArray.put(entry.getKey(), fun.call(env, param));
        }
        return resultArray;
    }

    public static Value array_merge_recursive(Env env, Value[] args) {
        ArrayValueImpl result = new ArrayValueImpl();
        for (Value arg : args) {
            Value value = arg.toValue();
            if (!(value instanceof ArrayValue)) continue;
            ArrayModule.arrayMergeRecursiveImpl(env, result, (ArrayValue)value);
        }
        return result;
    }

    public static Value array_merge(Env env, Value[] args) {
        ArrayValueImpl result = new ArrayValueImpl();
        for (Value arg : args) {
            if (arg.isNull()) {
                return NullValue.NULL;
            }
            Value argValue = arg.toValue();
            if (!argValue.isArray()) continue;
            ArrayValue array = argValue.toArrayValue(env);
            Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
            while (iter.hasNext()) {
                Map.Entry<Value, Value> entry = iter.next();
                Value key = entry.getKey();
                Value value = entry instanceof ArrayValue.Entry ? ((ArrayValue.Entry)entry).getRawValue() : entry.getValue();
                if (!(value instanceof Var)) {
                    value = value.copy();
                }
                if (key.isNumberConvertible()) {
                    ((ArrayValue)result).put(value);
                    continue;
                }
                ((ArrayValue)result).append(key, value);
            }
        }
        return result;
    }

    private static void arrayMergeRecursiveImpl(Env env, ArrayValue result, ArrayValue array) {
        Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            Value key = entry.getKey();
            Value value = entry instanceof ArrayValue.Entry ? ((ArrayValue.Entry)entry).getRawValue() : entry.getValue();
            if (!(value instanceof Var)) {
                value = value.copy();
            }
            if (key.isNumberConvertible()) {
                result.put(value);
                continue;
            }
            Value oldValue = result.getDirty(key).toValue();
            if (oldValue != null && oldValue.isset()) {
                ArrayValueImpl newArray;
                if (oldValue.isArray() && value.isArray()) {
                    ArrayModule.arrayMergeRecursiveImpl(env, oldValue.toArrayValue(env), value.toArrayValue(env));
                    continue;
                }
                if (oldValue.isArray()) {
                    oldValue.put(value);
                    continue;
                }
                if (value.isArray()) {
                    newArray = new ArrayValueImpl();
                    newArray.put(oldValue);
                    newArray.putAll(value.toArrayValue(env));
                    result.put(key, newArray);
                    continue;
                }
                newArray = new ArrayValueImpl();
                newArray.put(oldValue);
                newArray.put(value);
                result.put(key, newArray);
                continue;
            }
            result.put(key, value);
        }
    }

    public static boolean array_multisort(Env env, Value[] arrays) {
        int i;
        boolean isNewKeys = true;
        if (arrays.length == 0 || !arrays[0].isArray()) {
            env.warning("the first argument must be an array");
            return false;
        }
        Value primary = arrays[0];
        Iterator<Value> keyIter = primary.getKeyIterator(env);
        while (keyIter.hasNext()) {
            if (keyIter.next() instanceof LongValue) continue;
            isNewKeys = false;
            break;
        }
        Value[] rows = primary.getKeyArray(env);
        int maxsize = 0;
        for (int i2 = 0; i2 < arrays.length; ++i2) {
            if (!arrays[i2].isArray()) continue;
            maxsize = Math.max(maxsize, arrays[i2].getSize());
        }
        Value[] p = new LongValue[maxsize];
        for (i = 0; i < rows.length; ++i) {
            p[i] = LongValue.create(i);
        }
        Arrays.sort(p, new MultiSortComparator(env, rows, arrays));
        for (i = 0; i < arrays.length; ++i) {
            if (!arrays[i].isArray()) continue;
            ArrayModule.permute(env, arrays[i].toArrayValue(env), p, isNewKeys);
        }
        return true;
    }

    private static void permute(Env env, ArrayValue array, Value[] permutation, boolean isNewKeys) {
        Value[] keys = array.getKeyArray(env);
        Value[] values = array.getValueArray(env);
        array.clear();
        if (isNewKeys) {
            for (int i = 0; i < permutation.length; ++i) {
                int p = permutation[i].toInt();
                Value value = values[p];
                array.put(LongValue.create(i), value.toValue().copy());
            }
        } else {
            for (int i = 0; i < permutation.length; ++i) {
                int p = permutation[i].toInt();
                Value key = keys[p];
                Value value = values[p];
                array.put(key, value.toValue().copy());
            }
        }
    }

    public static Value array_pad(Env env, ArrayValue input, long padSize, Value padValue) {
        if (input == null) {
            return NullValue.NULL;
        }
        long inputSize = input.getSize();
        long size = Math.abs(padSize);
        if ((long)input.getSize() >= size) {
            return input;
        }
        if (size - inputSize > 0x100000L) {
            env.warning("You may only pad up to 1048576 elements at a time");
            return BooleanValue.FALSE;
        }
        ArrayValueImpl paddedArray = new ArrayValueImpl();
        boolean padFront = padSize < 0L;
        Iterator<Value> keyIterator = input.keySet().iterator();
        for (long ctr = 0L; ctr < size; ++ctr) {
            Value newValue = padFront && ctr < size - inputSize ? padValue : (!padFront && ctr >= inputSize ? padValue : input.get(keyIterator.next()));
            paddedArray.put(LongValue.create(ctr), newValue);
        }
        return paddedArray;
    }

    public static Value array_pop(Env env, @Reference Value array) {
        return array.pop(env);
    }

    public static Value array_product(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (array.getSize() == 0) {
            return DoubleValue.create(0.0);
        }
        double product = 1.0;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            product *= entry.getValue().toDouble();
        }
        return DoubleValue.create(product);
    }

    public static int array_push(Env env, @Reference Value array, Value[] values) {
        for (Value value : values) {
            array.put(value);
        }
        return array.getSize();
    }

    public static Value array_rand(Env env, ArrayValue array, @Optional(value="1") long num) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (array.getSize() == 0) {
            return NullValue.NULL;
        }
        if (num < 1L || (long)array.getSize() < num) {
            env.warning("Second argument has to be between 1 and the number of elements in the array");
            return NullValue.NULL;
        }
        long arraySize = array.getSize();
        Value[] keys = new Value[(int)arraySize];
        array.keySet().toArray(keys);
        if (num == 1L) {
            int index = (int)(RandomUtil.getRandomLong() % arraySize);
            if (index < 0) {
                index *= -1;
            }
            return keys[index];
        }
        int length = keys.length;
        for (int i = 0; i < length; ++i) {
            int rand = RandomUtil.nextInt(length);
            Value temp = keys[rand];
            keys[rand] = keys[i];
            keys[i] = temp;
        }
        ArrayValueImpl randArray = new ArrayValueImpl();
        int i = 0;
        while ((long)i < num) {
            ((ArrayValue)randArray).put(keys[i]);
            ++i;
        }
        return randArray;
    }

    public static Value array_reduce(Env env, ArrayValue array, Callable callable, @Optional(value="NULL") Value initialValue) {
        if (array == null) {
            return NullValue.NULL;
        }
        if (callable == null || !callable.isValid(env)) {
            env.warning("The second argument, '" + callable + "', should be a valid callable");
            return NullValue.NULL;
        }
        Value result = initialValue;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            try {
                result = callable.call(env, result, entry.getValue());
            }
            catch (Exception t) {
                log.log(Level.WARNING, t.toString(), t);
                env.warning("An error occurred while invoking the reduction callback");
                return NullValue.NULL;
            }
        }
        return result;
    }

    public static Value array_replace_recursive(Env env, Value[] args) {
        ArrayValueImpl result = new ArrayValueImpl();
        for (int i = 0; i < args.length; ++i) {
            ArrayModule.replaceRecursive(env, result, args[i]);
        }
        return result;
    }

    private static void replaceRecursive(Env env, Value result, Value newValue) {
        Iterator<Map.Entry<Value, Value>> iter = newValue.toArray().getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            Value key = entry.getKey();
            Value value = entry.getValue();
            if (value.isArray()) {
                ArrayModule.replaceRecursive(env, result.getArray(key), value);
                continue;
            }
            result.put(key, value);
        }
    }

    public static Value array_replace(Env env, Value[] args) {
        ArrayValueImpl result = new ArrayValueImpl();
        for (int i = 0; i < args.length; ++i) {
            Iterator<Map.Entry<Value, Value>> iter = args[i].toArray().getIterator(env);
            while (iter.hasNext()) {
                Map.Entry<Value, Value> entry = iter.next();
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static Value array_reverse(Env env, @ReadOnly ArrayValue inputArray, @Optional(value="false") boolean keyed) {
        if (inputArray == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl newArray = new ArrayValueImpl();
        if (inputArray.getSize() == 0) {
            return newArray;
        }
        Map.Entry[] entryArray = new Map.Entry[inputArray.getSize()];
        inputArray.entrySet().toArray(entryArray);
        int newIndex = 0;
        for (int index = entryArray.length - 1; index > -1; --index) {
            Value currentKey = (Value)entryArray[index].getKey();
            Value currentValue = (Value)entryArray[index].getValue();
            if (keyed || currentKey instanceof StringValue) {
                newArray.put(currentKey, currentValue);
                continue;
            }
            newArray.put(LongValue.create(newIndex), currentValue);
            ++newIndex;
        }
        return newArray;
    }

    public static Value array_search(Env env, @ReadOnly Value needle, @ReadOnly ArrayValue array, @Optional(value="false") boolean strict) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        Iterator<Map.Entry<Value, Value>> iterator = array.getIterator(env);
        while (iterator.hasNext()) {
            Map.Entry<Value, Value> entry = iterator.next();
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            if (!needle.eq(entryValue)) continue;
            if (strict) {
                if (!entryValue.getType().equals(needle.getType())) continue;
                return entryKey;
            }
            return entryKey;
        }
        return BooleanValue.FALSE;
    }

    public static Value array_shift(Env env, @Reference Value value) {
        if (!value.isArray()) {
            env.warning(L.l("cannot shift a non-array"));
            return NullValue.NULL;
        }
        ArrayValue array = value.toArrayValue(env);
        if (array.getSize() < 1) {
            return NullValue.NULL;
        }
        Iterator<Value> iter = array.getKeyIterator(env);
        Value firstValue = array.remove(iter.next());
        array.keyReset(0L, false);
        return firstValue;
    }

    public static Value array_slice(Env env, @ReadOnly ArrayValue array, int offset, @Optional Value length, @Optional boolean isPreserveKeys) {
        if (array == null) {
            return NullValue.NULL;
        }
        int size = array.getSize();
        int startIndex = offset;
        if (offset < 0) {
            startIndex = size + offset;
        }
        int endIndex = size;
        if (!length.isDefault()) {
            endIndex = length.toInt();
            endIndex = endIndex < 0 ? (endIndex += size) : (endIndex += startIndex);
        }
        return array.slice(env, startIndex, endIndex, isPreserveKeys);
    }

    public static Value array_splice(Env env, @Reference Value arrayVar, int offset, @Optional(value="NULL") Value length, @Optional Value replace) {
        if (!arrayVar.isset()) {
            return NullValue.NULL;
        }
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return NullValue.NULL;
        }
        int size = array.getSize();
        int startIndex = offset;
        if (startIndex < 0) {
            startIndex += size;
        }
        int endIndex = size;
        if (!length.isNull()) {
            endIndex = length.toInt();
            endIndex = endIndex < 0 ? (endIndex += size) : (endIndex += startIndex);
        }
        return ArrayModule.spliceImpl(env, arrayVar, array, startIndex, endIndex, replace.toArray());
    }

    public static Value spliceImpl(Env env, Value var, ArrayValue array, int start, int end, ArrayValue replace) {
        int index = 0;
        ArrayValueImpl newArray = new ArrayValueImpl();
        ArrayValueImpl result = new ArrayValueImpl();
        var.set(newArray);
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue();
            if (start == index && replace != null) {
                Iterator<Value> replaceIter = replace.getValueIterator(env);
                while (replaceIter.hasNext()) {
                    ((ArrayValue)newArray).put(replaceIter.next());
                }
            }
            if (start <= index && index < end) {
                if (key.isString()) {
                    result.put(key, value);
                } else {
                    ((ArrayValue)result).put(value);
                }
            } else if (key.isString()) {
                newArray.put(key, value);
            } else {
                ((ArrayValue)newArray).put(value);
            }
            ++index;
        }
        if (index <= start && replace != null) {
            Iterator<Value> replaceIter = replace.getValueIterator(env);
            while (replaceIter.hasNext()) {
                ((ArrayValue)newArray).put(replaceIter.next());
            }
        }
        return result;
    }

    public static Value array_sum(Env env, @ReadOnly ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        double sum = 0.0;
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            sum += entry.getValue().toDouble();
        }
        return DoubleValue.create(sum);
    }

    public static Value array_udiff_assoc(Env env, Value[] arrays) {
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_udiff_assoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        Callable cmp = callbackValue.toCallable(env, false);
        if (!cmp.isValid(env)) {
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        boolean isFound = false;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block3: for (int k = 1; k < arrays.length - 1 && !isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean keyFound = entryKey.eql(entry.getKey());
                        boolean valueFound = false;
                        if (keyFound) {
                            valueFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        }
                        isFound = keyFound && valueFound;
                    }
                    catch (Exception t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block3;
                }
            }
            if (!isFound) {
                diffArray.put(entryKey, entryValue);
            }
            isFound = false;
        }
        return diffArray;
    }

    public static Value array_udiff_uassoc(Env env, Value[] arrays) {
        if (arrays.length < 4) {
            env.warning("Wrong paremeter count for array_udiff_uassoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 2];
        Callable cmpValue = callbackValue.toCallable(env, false);
        if (!cmpValue.isValid(env)) {
            return NullValue.NULL;
        }
        Value callbackKey = arrays[arrays.length - 1];
        Callable cmpKey = callbackKey.toCallable(env, false);
        if (!cmpKey.isValid(env)) {
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        boolean isFound = false;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block3: for (int k = 1; k < arrays.length - 2 && !isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean valueFound = cmpValue.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        boolean keyFound = false;
                        if (valueFound) {
                            keyFound = cmpKey.call(env, entryKey, entry.getKey()).toLong() == 0L;
                        }
                        isFound = valueFound && keyFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block3;
                }
            }
            if (!isFound) {
                diffArray.put(entryKey, entryValue);
            }
            isFound = false;
        }
        return diffArray;
    }

    public static Value array_udiff(Env env, Value[] arrays) {
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_udiff()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        Callable cmp = callbackValue.toCallable(env, false);
        if (!cmp.isValid(env)) {
            return NullValue.NULL;
        }
        ArrayValueImpl diffArray = new ArrayValueImpl();
        boolean isFound = false;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block3: for (int k = 1; k < arrays.length - 1 && !isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        isFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                    }
                    catch (Exception t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block3;
                }
            }
            if (!isFound) {
                diffArray.put(entryKey, entryValue);
            }
            isFound = false;
        }
        return diffArray;
    }

    public static Value array_uintersect_assoc(Env env, Value[] arrays) {
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_uintersect_assoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        Callable cmp = callbackValue.toCallable(env, false);
        if (!cmp.isValid(env)) {
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        boolean isFound = true;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block3: for (int k = 1; k < arrays.length - 1 && isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean keyFound = entryKey.eql(entry.getKey());
                        boolean valueFound = false;
                        if (keyFound) {
                            valueFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        }
                        isFound = keyFound && valueFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block3;
                }
            }
            if (!isFound) continue;
            interArray.put(entryKey, entryValue);
        }
        return interArray;
    }

    public static Value array_uintersect_uassoc(Env env, Value[] arrays) {
        if (arrays.length < 4) {
            env.warning("Wrong paremeter count for array_uintersect_uassoc()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 2];
        Callable cmpValue = callbackValue.toCallable(env, false);
        if (!cmpValue.isValid(env)) {
            return NullValue.NULL;
        }
        Value callbackKey = arrays[arrays.length - 1];
        Callable cmpKey = callbackKey.toCallable(env, false);
        if (!cmpKey.isValid(env)) {
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        boolean isFound = true;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block3: for (int k = 1; k < arrays.length - 2 && isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        boolean valueFound = cmpValue.call(env, entryValue, entry.getValue()).toLong() == 0L;
                        boolean keyFound = false;
                        if (valueFound) {
                            keyFound = cmpKey.call(env, entryKey, entry.getKey()).toLong() == 0L;
                        }
                        isFound = valueFound && keyFound;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block3;
                }
            }
            if (!isFound) continue;
            interArray.put(entryKey, entryValue);
        }
        return interArray;
    }

    public static Value array_uintersect(Env env, Value[] arrays) {
        if (arrays.length < 3) {
            env.warning("Wrong paremeter count for array_uintersect()");
            return NullValue.NULL;
        }
        if (!(arrays[0] instanceof ArrayValue)) {
            env.warning("Argument #1 is not an array");
            return NullValue.NULL;
        }
        ArrayValue array = (ArrayValue)arrays[0];
        Value callbackValue = arrays[arrays.length - 1];
        Callable cmp = callbackValue.toCallable(env, false);
        if (!cmp.isValid(env)) {
            return NullValue.NULL;
        }
        ArrayValueImpl interArray = new ArrayValueImpl();
        boolean isFound = true;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            block3: for (int k = 1; k < arrays.length - 1 && isFound; ++k) {
                if (!(arrays[k] instanceof ArrayValue)) {
                    env.warning("Argument #" + (k + 1) + " is not an array");
                    return NullValue.NULL;
                }
                ArrayValue checkArray = (ArrayValue)arrays[k];
                for (Map.Entry<Value, Value> entry : checkArray.entrySet()) {
                    try {
                        isFound = cmp.call(env, entryValue, entry.getValue()).toLong() == 0L;
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.toString(), t);
                        env.warning("An error occurred while invoking the filter callback");
                        return NullValue.NULL;
                    }
                    if (!isFound) continue;
                    continue block3;
                }
            }
            if (!isFound) continue;
            interArray.put(entryKey, entryValue);
        }
        return interArray;
    }

    public static Value array_unique(Env env, ArrayValue array) {
        if (array == null) {
            return BooleanValue.FALSE;
        }
        array.sort(CNO_VALUE_NORMAL, false, false);
        Map.Entry<Value, Value> lastEntry = null;
        ArrayValueImpl uniqueArray = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            Value entryValue = entry.getValue();
            if (lastEntry == null) {
                uniqueArray.put(entry.getKey(), entryValue);
                lastEntry = entry;
                continue;
            }
            Value lastEntryValue = (Value)lastEntry.getValue();
            if (!entryValue.toString().equals(lastEntryValue.toString())) {
                uniqueArray.put(entry.getKey(), entryValue);
            }
            lastEntry = entry;
        }
        uniqueArray.sort(CNO_KEY_NORMAL, false, false);
        return uniqueArray;
    }

    public static Value array_unshift(Env env, @Reference Value value, Value[] values) {
        ArrayValue array = value.toArrayValue(env);
        if (array == null) {
            return BooleanValue.FALSE;
        }
        for (int i = values.length - 1; i >= 0; --i) {
            array.unshift(values[i]);
        }
        array.keyReset(0L, false);
        return LongValue.create(array.getSize());
    }

    public static Value array_values(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        return array.getValues();
    }

    public static boolean array_walk_recursive(Env env, @Reference Value arrayVar, Callable callback, @Optional(value="NULL") Value extra) {
        if (callback == null || !callback.isValid(env)) {
            env.error(L.l("'{0}' is an unknown function.", (Object)callback.getCallbackName()));
            return false;
        }
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        try {
            Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
            while (iter.hasNext()) {
                Map.Entry<Value, Value> entry = iter.next();
                Value key = entry.getKey();
                Value value = entry instanceof ArrayValue.Entry ? ((ArrayValue.Entry)entry).getRawValue() : entry.getValue();
                if (value.isArray()) {
                    boolean result = ArrayModule.array_walk_recursive(env, (ArrayValue)value.toValue(), callback, extra);
                    if (result) continue;
                    return false;
                }
                callback.callArray(env, array, key, value, key, extra);
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            env.warning("An error occured while invoking the callback", e);
            return false;
        }
    }

    public static boolean array_walk(Env env, @Reference Value arrayVar, Callable callback, @Optional(value="NULL") Value userData) {
        if (callback == null || !callback.isValid(env)) {
            env.error(L.l("'{0}' is an unknown function.", (Object)callback.getCallbackName()));
            return false;
        }
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        try {
            Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
            while (iter.hasNext()) {
                Map.Entry<Value, Value> entry = iter.next();
                Value key = entry.getKey();
                Value value = entry instanceof ArrayValue.Entry ? ((ArrayValue.Entry)entry).getRawValue() : entry.getValue();
                callback.callArray(env, array, key, value, key, userData);
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            env.warning("An error occured while invoking the callback", e);
            return false;
        }
    }

    public static boolean arsort(Env env, @Reference Value arrayVar, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_REVERSE, false, false);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_REVERSE, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate().getLocale();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, -1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_VALUE_REVERSE, false, false);
            }
        }
        return true;
    }

    public static boolean asort(Env env, @Reference Value arrayVar, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_NORMAL, false, false);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_NORMAL, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate().getLocale();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, 1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_VALUE_NORMAL, false, false);
            }
        }
        return true;
    }

    @UsesSymbolTable
    public static ArrayValue compact(Env env, Value[] variables) {
        ArrayValueImpl compactArray = new ArrayValueImpl();
        for (Value variableName : variables) {
            if (variableName.isString()) {
                Var var = env.getRef(variableName.toStringValue(), false);
                if (var == null) continue;
                compactArray.put(variableName, var.toValue());
                continue;
            }
            if (!(variableName instanceof ArrayValue)) continue;
            ArrayValue array = (ArrayValue)variableName;
            ArrayValue innerArray = ArrayModule.compact(env, array.valuesToArray());
            compactArray.putAll(innerArray);
        }
        return compactArray;
    }

    public static long count(Env env, @ReadOnly Value value, @Optional int countMethod) {
        boolean isRecursive;
        boolean bl = isRecursive = countMethod == 1;
        if (!isRecursive) {
            return value.getCount(env);
        }
        return value.getCountRecursive(env);
    }

    public static Value current(@ReadOnly Value value) {
        return value.current();
    }

    public static Value each(Env env, @Reference Value value) {
        if (value instanceof Var) {
            if ((value = value.toValue()).isArray()) {
                return value.toArrayValue(env).each();
            }
            env.warning(L.l("each() requires argument to be an array"));
            return NullValue.NULL;
        }
        return env.error(L.l("each() argument must be a variable"));
    }

    public static Value end(@Reference Value value) {
        return value.end();
    }

    @UsesSymbolTable(replace=true)
    public static Value extract(Env env, ArrayValue array) {
        if (array == null) {
            return NullValue.NULL;
        }
        int completedSymbols = 0;
        for (Value entryKey : array.keySet()) {
            Value entryValue = array.get(entryKey);
            StringValue symbolName = entryKey.toStringValue();
            if (!ArrayModule.validVariableName(symbolName)) continue;
            env.setValue(symbolName, entryValue);
            ++completedSymbols;
        }
        return LongValue.create(completedSymbols);
    }

    @UsesSymbolTable
    public static Value extract(Env env, ArrayValue array, long rawType, @Optional(value="NULL") Value valuePrefix) {
        boolean extrRefs;
        if (array == null) {
            return NullValue.NULL;
        }
        long extractType = rawType & 0xFFFFFFFFFFFFFEFFL;
        boolean bl = extrRefs = (rawType & 0x100L) != 0L;
        if (extractType < 0L || extractType > 6L && extractType != 256L) {
            env.warning("Unknown extract type");
            return NullValue.NULL;
        }
        if (!(extractType < 2L || extractType > 5L || valuePrefix != null && valuePrefix.isString())) {
            env.warning("Prefix expected to be specified");
            return NullValue.NULL;
        }
        String prefix = "";
        if (valuePrefix instanceof StringValue) {
            prefix = valuePrefix.toString() + "_";
        }
        int completedSymbols = 0;
        for (Value entryKey : array.keySet()) {
            Value entryValue = extrRefs ? array.getVar(entryKey) : array.get(entryKey);
            StringValue symbolName = entryKey.toStringValue();
            Value tableValue = env.getValue(symbolName);
            switch ((int)extractType) {
                case 1: {
                    if (tableValue.isNull()) break;
                    symbolName = env.createString("");
                    break;
                }
                case 2: {
                    if (tableValue.isNull()) break;
                    symbolName = env.createString(prefix + symbolName);
                    break;
                }
                case 3: {
                    symbolName = env.createString(prefix + symbolName);
                    break;
                }
                case 4: {
                    if (ArrayModule.validVariableName(symbolName)) break;
                    symbolName = env.createString(prefix + symbolName);
                    break;
                }
                case 6: {
                    if (!tableValue.isNull()) break;
                    symbolName = env.createString("");
                    break;
                }
                case 5: {
                    if (!tableValue.isNull()) {
                        symbolName = env.createString(prefix + symbolName);
                        break;
                    }
                    symbolName = env.createString("");
                    break;
                }
            }
            if (!ArrayModule.validVariableName(symbolName)) continue;
            env.setValue(symbolName, entryValue);
            ++completedSymbols;
        }
        return LongValue.create(completedSymbols);
    }

    private static boolean validVariableName(StringValue variableName) {
        if (variableName.length() < 1) {
            return false;
        }
        char checkChar = variableName.charAt(0);
        if (!Character.isLetter(checkChar) && checkChar != '_') {
            return false;
        }
        for (int k = 1; k < variableName.length(); ++k) {
            checkChar = variableName.charAt(k);
            if (Character.isLetterOrDigit(checkChar) || checkChar == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean in_array(@ReadOnly Value needle, @ReadOnly ArrayValue stack, @Optional(value="false") boolean strict) {
        if (stack == null) {
            return false;
        }
        Value result = strict ? stack.containsStrict(needle) : stack.contains(needle);
        return !result.isNull();
    }

    public static Value key(@ReadOnly Value value) {
        return value.key();
    }

    public static boolean key_exists(Env env, @ReadOnly Value key, @ReadOnly Value searchArray) {
        return ArrayModule.array_key_exists(env, key, searchArray);
    }

    public static boolean krsort(Env env, @Reference Value arrayVar, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_KEY_REVERSE, false, false);
                break;
            }
            case 1: {
                array.sort(CN_KEY_REVERSE, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate().getLocale();
                array.sort(new CompareLocale(ArrayValue.GET_KEY, -1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_KEY_REVERSE, false, false);
            }
        }
        return true;
    }

    public static boolean ksort(Env env, @Reference Value arrayVar, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_KEY_NORMAL, false, false);
                break;
            }
            case 1: {
                array.sort(CN_KEY_NORMAL, false, false);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate().getLocale();
                array.sort(new CompareLocale(ArrayValue.GET_KEY, 1, Collator.getInstance(locale)), false, false);
                break;
            }
            default: {
                array.sort(CNO_KEY_NORMAL, false, false);
            }
        }
        return true;
    }

    public static Value natcasesort(Env env, @Reference Value arrayVar) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayModule.trimArrayStrings(array);
        array.sort(CNA_VALUE_NORMAL_INSENSITIVE, false, false);
        return BooleanValue.TRUE;
    }

    public static Value natsort(Env env, @Reference Value arrayVar) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return NullValue.NULL;
        }
        ArrayModule.trimArrayStrings(array);
        array.sort(CNA_VALUE_NORMAL_SENSITIVE, false, false);
        return BooleanValue.TRUE;
    }

    private static void trimArrayStrings(ArrayValue array) {
        if (array != null) {
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                Value entryValue = entry.getValue();
                if (!(entryValue instanceof StringValue)) continue;
                array.put(entry.getKey(), StringValue.create(entryValue.toString().trim()));
            }
        }
    }

    public static Value next(@Reference Value value) {
        return value.next();
    }

    public static Value pos(@ReadOnly Value value) {
        return ArrayModule.current(value);
    }

    public static Value prev(@Reference Value array) {
        return array.prev();
    }

    public static Value range(Env env, @ReadOnly Value startV, @ReadOnly Value endV, @Optional(value="1") long step) {
        long end;
        long start;
        if (step < 1L) {
            step *= -1L;
        }
        boolean isAppendChars = false;
        if (startV.isLongConvertible() && endV.isLongConvertible()) {
            start = startV.toLong();
            end = endV.toLong();
        } else {
            start = startV.toChar();
            end = endV.toChar();
            isAppendChars = true;
        }
        if (start != end && Math.abs(end - start) < step) {
            env.warning("steps exceeds the specified range");
            return BooleanValue.FALSE;
        }
        boolean increment = true;
        if (end < start) {
            step *= -1L;
            increment = false;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        do {
            if (isAppendChars) {
                ((ArrayValue)array).put(env.createString((char)start));
                continue;
            }
            array.put(start);
        } while (increment && (start += step) <= end || !increment && start >= end);
        return array;
    }

    public static Value reset(@Reference Value array) {
        return array.reset();
    }

    public static boolean rsort(Env env, @Reference Value arrayVar, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_REVERSE, true, true);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_REVERSE, true, true);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate().getLocale();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, -1, Collator.getInstance(locale)), true, true);
                break;
            }
            default: {
                array.sort(CNO_VALUE_REVERSE, true, true);
            }
        }
        return true;
    }

    public static Value shuffle(Env env, @Reference Value array) {
        return array.shuffle();
    }

    public static long sizeof(Env env, @ReadOnly Value value, @Optional int countMethod) {
        return ArrayModule.count(env, value, countMethod);
    }

    public static boolean sort(Env env, @Reference Value arrayVar, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        switch ((int)sortFlag) {
            case 2: {
                array.sort(CS_VALUE_NORMAL, true, true);
                break;
            }
            case 1: {
                array.sort(CN_VALUE_NORMAL, true, true);
                break;
            }
            case 5: {
                Locale locale = env.getLocaleInfo().getCollate().getLocale();
                array.sort(new CompareLocale(ArrayValue.GET_VALUE, 1, Collator.getInstance(locale)), true, true);
                break;
            }
            default: {
                array.sort(CNO_VALUE_NORMAL, true, true);
            }
        }
        return true;
    }

    public static boolean uasort(Env env, @Reference Value arrayVar, Callable func, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        if (func == null) {
            return false;
        }
        if (!func.isValid(env)) {
            env.warning(L.l("Invalid comparison function"));
            return false;
        }
        array.sort(new CompareCallBack(ArrayValue.GET_VALUE, 1, func, env), false, false);
        return true;
    }

    public static boolean uksort(Env env, @Reference Value arrayVar, Callable func, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        if (!func.isValid(env)) {
            env.warning(L.l("Invalid comparison function"));
            return false;
        }
        CompareCallBack cmp = new CompareCallBack(ArrayValue.GET_KEY, 1, func, env);
        array.sort(cmp, false, false);
        return true;
    }

    public static boolean usort(Env env, @Reference Value arrayVar, Callable func, @Optional long sortFlag) {
        ArrayValue array = arrayVar.toArrayValue(env);
        if (array == null) {
            return false;
        }
        if (func == null) {
            return false;
        }
        if (!func.isValid(env)) {
            env.warning(L.l("Invalid comparison function"));
            return false;
        }
        CompareCallBack cmp = new CompareCallBack(ArrayValue.GET_VALUE, 1, func, env);
        array.sort(cmp, true, true);
        return true;
    }

    private static class StringParser {
        private int _current;
        private int _length;
        private String _string;
        private static final int SYMBOL = 1;
        private static final int LETTER = 2;
        private static final int DIGIT = 3;

        StringParser(String string) {
            this._string = string;
            this._length = string.length();
            this._current = 0;
        }

        public boolean hasNext() {
            return this._current < this._length;
        }

        public String next() {
            try {
                char character = this._string.charAt(this._current);
                if (character == '0') {
                    ++this._current;
                    return "0";
                }
                int type = Character.isLetter(character) ? 2 : (Character.isDigit(character) ? 3 : 1);
                int start = this._current;
                while (this._current < this._length && (type == 2 && Character.isLetter(this._string.charAt(this._current)) || type == 3 && Character.isDigit(this._string.charAt(this._current)) || type == 1 && !Character.isLetterOrDigit(this._string.charAt(this._current)))) {
                    ++this._current;
                }
                return this._string.substring(start, this._current);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiSortComparator
    implements Comparator<LongValue> {
        private final Env _env;
        private final Value[] _rows;
        private final Value[] _arrays;

        public MultiSortComparator(Env env, Value[] rows, Value[] arrays) {
            this._env = env;
            this._rows = rows;
            this._arrays = arrays;
        }

        @Override
        public int compare(LongValue index1, LongValue index2) {
            for (int i = 0; i < this._arrays.length; ++i) {
                int direction = 4;
                int mode = 0;
                ArrayValue av = (ArrayValue)this._arrays[i];
                block8: while (i + 1 < this._arrays.length && this._arrays[i + 1] instanceof LongValue) {
                    int flag = this._arrays[++i].toInt();
                    switch (flag) {
                        case 4: {
                            direction = 4;
                            continue block8;
                        }
                        case 3: {
                            direction = 3;
                            continue block8;
                        }
                        case 0: {
                            mode = 0;
                            continue block8;
                        }
                        case 2: {
                            mode = 2;
                            continue block8;
                        }
                        case 1: {
                            mode = 1;
                            continue block8;
                        }
                    }
                    this._env.warning("Unknown sort flag: " + this._arrays[i]);
                }
                Value lValue = av.get(this._rows[index1.toInt()]);
                Value rValue = av.get(this._rows[index2.toInt()]);
                int cmp = mode == 2 ? lValue.toString().compareTo(rValue.toString()) : (mode == 1 ? NumberValue.compareNum(lValue, rValue) : lValue.cmp(rValue));
                if (cmp == 0) continue;
                return direction == 4 ? cmp : -1 * cmp;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareCallBack
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;
        private Callable _func;
        private Env _env;

        CompareCallBack(ArrayValue.AbstractGet getter, int order, Callable func, Env env) {
            this._getter = getter;
            this._order = order;
            this._func = func;
            this._env = env;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                Value aElement = this._getter.get(aEntry);
                Value bElement = this._getter.get(bEntry);
                return (int)this._func.call(this._env, aElement, bElement).toLong();
            }
            catch (Exception e) {
                throw new QuercusModuleException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareNatural
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;
        private boolean _isCaseSensitive;

        CompareNatural(ArrayValue.AbstractGet getter, int order, boolean isCaseSensitive) {
            this._getter = getter;
            this._order = order;
            this._isCaseSensitive = isCaseSensitive;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                String aElement = this._getter.get(aEntry).toString();
                String bElement = this._getter.get(bEntry).toString();
                if (!this._isCaseSensitive) {
                    aElement = aElement.toLowerCase(Locale.ENGLISH);
                    bElement = bElement.toLowerCase(Locale.ENGLISH);
                }
                StringParser aParser = new StringParser(aElement);
                StringParser bParser = new StringParser(bElement);
                while (aParser.hasNext() && bParser.hasNext()) {
                    int comparison;
                    String aPart = aParser.next();
                    String bPart = bParser.next();
                    try {
                        Long aLong = Long.valueOf(aPart);
                        Long bLong = Long.valueOf(bPart);
                        comparison = aLong.compareTo(bLong);
                    }
                    catch (NumberFormatException e) {
                        comparison = aPart.compareTo(bPart);
                    }
                    if (comparison < 0) {
                        return -1;
                    }
                    if (comparison <= 0) continue;
                    return 1;
                }
                if (bParser.hasNext()) {
                    return 1;
                }
                if (aParser.hasNext()) {
                    return -1;
                }
                return 0;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareNormal
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;

        CompareNormal(ArrayValue.AbstractGet getter, int order) {
            this._getter = getter;
            this._order = order;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            if (this._getter instanceof ArrayValue.GetKey) {
                ArrayValue.KeyComparator k = ArrayValue.KeyComparator.CMP;
                return k.compare(aEntry, bEntry) * this._order;
            }
            ArrayValue.ValueComparator c = ArrayValue.ValueComparator.CMP;
            return c.compare(aEntry, bEntry) * this._order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareLocale
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;
        private Collator _collator;

        CompareLocale(ArrayValue.AbstractGet getter, int order, Collator collator) {
            this._getter = getter;
            this._order = order;
            this._collator = collator;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            String aElement = this._getter.get(aEntry).toString();
            String bElement = this._getter.get(bEntry).toString();
            return this._collator.compare(aElement, bElement) * this._order;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareNumeric
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;

        CompareNumeric(ArrayValue.AbstractGet getter, int order) {
            this._getter = getter;
            this._order = order;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                double aElement = this._getter.get(aEntry).toDouble();
                double bElement = this._getter.get(bEntry).toDouble();
                if (aElement == bElement) {
                    return 0;
                }
                if (aElement < bElement) {
                    return -1 * this._order;
                }
                return this._order;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompareString
    implements Comparator<Map.Entry<Value, Value>> {
        private ArrayValue.AbstractGet _getter;
        private int _order;

        CompareString(ArrayValue.AbstractGet getter, int order) {
            this._getter = getter;
            this._order = order;
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            String aElement = this._getter.get(aEntry).toString();
            String bElement = this._getter.get(bEntry).toString();
            return aElement.compareTo(bElement) * this._order;
        }
    }
}

