/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.curl.CurlHttpConnection;
import com.caucho.quercus.lib.curl.CurlHttpRequest;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.PostBody;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

public class HttpPostRequest
extends CurlHttpRequest {
    private PostBody _body;

    public HttpPostRequest(CurlResource curlResource) {
        super(curlResource);
    }

    protected boolean init(Env env) throws ProtocolException {
        long contentLength;
        if (!super.init(env)) {
            return false;
        }
        this._body = PostBody.create(env, this.getCurlResource());
        if (this._body == null) {
            return false;
        }
        CurlHttpConnection conn = this.getHttpConnection();
        if (conn.getRequestProperty("Content-Type") == null) {
            conn.setRequestProperty("Content-Type", this._body.getContentType());
        }
        if (conn.getRequestProperty("Content-Length") == null && (contentLength = this._body.getContentLength()) >= 0L) {
            conn.setRequestProperty("Content-Length", String.valueOf(contentLength));
        }
        conn.setDoOutput(true);
        return true;
    }

    protected void transfer(Env env) throws IOException {
        super.transfer(env);
        CurlHttpConnection conn = this.getHttpConnection();
        OutputStream out = conn.getOutputStream();
        this._body.writeTo(env, out);
    }
}

