/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConnectionEntry;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcConnectionResource;
import com.caucho.quercus.lib.db.JdbcDriverContext;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.MysqlCharset;
import com.caucho.quercus.lib.db.MysqliModule;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.quercus.lib.db.MysqliStatement;
import com.caucho.quercus.lib.db.SqlParseToken;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import com.caucho.vfs.Path;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mysqli
extends JdbcConnectionResource {
    private static final Logger log = Logger.getLogger(Mysqli.class.getName());
    private static final L10N L = new L10N(Mysqli.class);
    private static MysqlMetaDataMethod _lastMetaDataMethod;
    private StringValue _charset;
    private StringValue _collation;
    private ArrayList<JdbcResultResource> _resultValues = new ArrayList();
    private int _nextResultValue = 0;
    private boolean _hasBeenUsed = true;
    private boolean _isPersistent;
    private LastSqlType _lastSql;
    private MysqlMetaDataMethod _metaDataMethod;
    private String _initQuery;

    public Mysqli(Env env, @Optional(value="localhost") StringValue host, @Optional StringValue user, @Optional StringValue password, @Optional String db, @Optional(value="-1") int port, @Optional StringValue socket) {
        super(env);
        this.connectInternal(env, host.toString(), user.toString(), password.toString(), db, port, socket.toString(), 0, null, null, true, false);
    }

    Mysqli(Env env, String host, String user, String pass, String db, int port, String socket, int flags, String driver, String url, boolean isNewLink, boolean isEmulatePrepares, String initQuery) {
        super(env);
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        this.connectInternal(env, host, user, pass, db, port, socket, flags, driver, url, isNewLink, isEmulatePrepares);
        this._initQuery = initQuery;
        if (initQuery != null) {
            this.realQuery(env, initQuery);
        }
    }

    protected Mysqli(Env env) {
        super(env);
    }

    public boolean isLastSqlDescribe() {
        return this._lastSql == LastSqlType.DESCRIBE;
    }

    @Override
    protected ConnectionEntry connectImpl(Env env, String host, String user, String pass, String dbname, int port, String socket, int flags, String driver, String url, boolean isNewLink, boolean isEmulatePrepares) {
        if (this.isConnected()) {
            env.warning(L.l("Connection is already opened to '{0}'", (Object)this));
            return null;
        }
        JdbcDriverContext driverContext = env.getQuercus().getJdbcDriverContext();
        try {
            String protocol;
            int slashPos;
            if (host == null || host.equals("")) {
                host = "localhost";
            } else if (host.startsWith("jdbc:") && (slashPos = host.indexOf("://")) > 5 && (driver = driverContext.getDriver(protocol = host.substring(5, slashPos))) != null) {
                url = host;
            }
            if (driver == null || driver.equals("")) {
                driver = env.getIniBoolean("quercus-mysql-driver") ? "com.caucho.quercus.mysql.QuercusMysqlDriver" : driverContext.getDefaultDriver();
            }
            if (url == null || url.length() == 0) {
                String encoding = this._charset != null ? this._charset.toString() : null;
                url = Mysqli.getUrl(env, host, port, dbname, encoding, (flags & 0x400) != 0, (flags & 0x20) != 0, (flags & 0x800) != 0, isEmulatePrepares);
            }
            ConnectionEntry jConn = env.getConnection(driver, url, user, pass, !isNewLink);
            Connection conn = jConn.getConnection();
            this._driver = driver;
            return jConn;
        }
        catch (SQLException e) {
            env.warning(L.l("A link to the server could not be established.\n  url={0}\n  driver={1}\n  {2}", (Object)url, (Object)driver, (Object)e.toString()), e);
            env.setSpecialValue("mysqli.connectErrno", LongValue.create(e.getErrorCode()));
            env.setSpecialValue("mysqli.connectError", env.createString(e.getMessage()));
            return null;
        }
        catch (Exception e) {
            env.warning(L.l("A link to the server could not be established.\n  url={0}\n  driver={1}\n  {2}", (Object)url, (Object)driver, (Object)e.toString()), e);
            env.setSpecialValue("mysqli.connectError", env.createString(e.toString()));
            return null;
        }
    }

    protected static String getUrl(Env env, String host, int port, String dbname, String encoding, boolean useInteractive, boolean useCompression, boolean useSsl, boolean isEmulatePrepares) {
        char sep;
        StringBuilder urlBuilder = new StringBuilder();
        JdbcDriverContext driverContext = env.getQuercus().getJdbcDriverContext();
        String jdbcUrlPrefix = driverContext.getDefaultUrlPrefix();
        urlBuilder.append(jdbcUrlPrefix);
        urlBuilder.append(host);
        if (port > 0) {
            urlBuilder.append(":");
            urlBuilder.append(port);
        }
        urlBuilder.append("/");
        if (dbname.length() > 0) {
            urlBuilder.append(dbname);
        }
        if (useInteractive) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("interactiveClient=true");
        }
        if (useCompression) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("useCompression=true");
        }
        if (useSsl) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("useSSL=true");
        }
        sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
        urlBuilder.append(sep);
        urlBuilder.append("jdbcCompliantTruncation=false");
        char c = sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
        if (encoding != null) {
            urlBuilder.append(sep);
            urlBuilder.append("characterEncoding=");
            urlBuilder.append(encoding);
        } else {
            urlBuilder.append(sep);
            urlBuilder.append("characterSetResults=ISO8859_1");
            urlBuilder.append('&');
            urlBuilder.append("characterEncoding=ISO8859_1");
        }
        if (!isEmulatePrepares) {
            sep = urlBuilder.indexOf("?") < 0 ? (char)'?' : '&';
            urlBuilder.append(sep);
            urlBuilder.append("useServerPrepStmts=true");
        }
        return urlBuilder.toString();
    }

    public int getaffected_rows(Env env) {
        return this.affected_rows(env);
    }

    public int affected_rows(Env env) {
        return this.validateConnection(env).getAffectedRows();
    }

    public boolean autocommit(Env env, boolean isAutoCommit) {
        return this.validateConnection(env).setAutoCommit(isAutoCommit);
    }

    public boolean change_user(Env env, String user, String password, String db) {
        try {
            if (this.isConnected()) {
                Connection conn = this.getJavaConnection(env);
                Class<?> cls = conn.getClass();
                Method method = cls.getMethod("changeUser", String.class, String.class);
                if (method != null) {
                    method.invoke((Object)conn, user, password);
                    this.select_db(env, db);
                    return true;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new QuercusException(e);
        }
        catch (InvocationTargetException e) {
            throw new QuercusException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusException(e);
        }
        catch (SQLException e) {
            env.warning(L.l("unable to change user to '{0}'", (Object)user));
            return false;
        }
        this.close();
        return this.connectInternal(env, this._host, user, password, db, this._port, this._socket, this._flags, this._driver, this._url, false, this._isEmulatePrepares);
    }

    public StringValue character_set_name(Env env) {
        return env.createString(this.getCharacterSetName());
    }

    public StringValue client_encoding(Env env) {
        return this.character_set_name(env);
    }

    public int geterrno() {
        return this.errno();
    }

    public int errno() {
        if (this.isConnected()) {
            return this.getErrorCode();
        }
        return 0;
    }

    public StringValue geterror(Env env) {
        return this.error(env);
    }

    public StringValue escape_string(Env env, StringValue str) {
        return this.real_escape_string(env, str);
    }

    public String getclient_info(Env env) {
        String version = this.getClientInfo(env);
        return version;
    }

    public String get_client_info(Env env) {
        return this.getclient_info(env);
    }

    protected static String getClientInfoStatic(Env env) {
        QuercusContext quercus = env.getQuercus();
        String version = quercus.getMysqlVersion();
        if (version == null) {
            try {
                JdbcDriverContext jdbcDriverContext = quercus.getJdbcDriverContext();
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cls = loader.loadClass(jdbcDriverContext.getDefaultDriver());
                Driver driver = (Driver)cls.newInstance();
                version = driver.getMajorVersion() + "." + driver.getMinorVersion() + ".00";
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (version == null) {
            version = "0.00.00";
        }
        return version;
    }

    @Override
    protected String getClientInfo(Env env) {
        return Mysqli.getClientInfoStatic(env);
    }

    public int getclient_version(Env env) {
        return MysqliModule.mysqli_get_client_version(env);
    }

    public Value get_dbname(Env env) {
        return env.createString(this.getCatalog());
    }

    public StringValue gethost_info(Env env) {
        return this.get_host_info(env);
    }

    public StringValue get_host_info(Env env) {
        return env.createString(this.getHost() + " via TCP socket");
    }

    public StringValue get_host_name(Env env) {
        return env.createString(this.getHost());
    }

    public Value getinfo(Env env) {
        return this.info(env);
    }

    Value info(Env env) {
        int matched;
        if (this.getResultResource() != null) {
            return BooleanValue.FALSE;
        }
        StringValue sb = env.createStringBuilder();
        int changed = matched = this.affected_rows(env);
        int duplicates = 0;
        int warnings = 0;
        SQLWarning warning = this.getWarnings();
        while (warning != null) {
            warning = warning.getNextWarning();
            ++warnings;
        }
        if (this._lastSql == LastSqlType.UPDATE) {
            sb.append("Rows matched: ");
        } else {
            sb.append("Records: ");
        }
        sb.append(matched);
        if (this._lastSql == LastSqlType.UPDATE) {
            sb.append("  Changed: ");
            sb.append(changed);
        } else {
            sb.append(" Duplicates: ");
            sb.append(duplicates);
        }
        if (this._lastSql == LastSqlType.UPDATE) {
            sb.append("  Warnings: ");
        } else {
            sb.append(" Warnings: ");
        }
        sb.append(warnings);
        return sb;
    }

    public int get_port_number() {
        return this.getPort();
    }

    public int getprotocol_version() {
        return this.get_proto_info();
    }

    public int get_proto_info() {
        return 10;
    }

    public StringValue getserver_info(Env env) {
        return this.get_server_info(env);
    }

    public StringValue get_server_info(Env env) {
        String version = env.getQuercus().getMysqlVersion();
        if (version != null) {
            return env.createString(version);
        }
        try {
            return env.createString(this.validateConnection(env).getServerInfo());
        }
        catch (SQLException e) {
            return env.getEmptyString();
        }
    }

    public int getserver_version(Env env) {
        return this.get_server_version(env);
    }

    public int get_server_version(Env env) {
        try {
            String info = this.validateConnection(env).getServerInfo();
            return Mysqli.infoToVersion(info);
        }
        catch (SQLException e) {
            env.warning(e);
            return 0;
        }
    }

    public int getfield_count(Env env) {
        return this.field_count(env);
    }

    public int field_count(Env env) {
        return this.validateConnection(env).getFieldCount();
    }

    public Value getinsert_id(Env env) {
        return this.insert_id(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value insert_id(Env env) {
        try {
            JdbcConnectionResource connV = this.validateConnection(env);
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT @@identity");
                if (rs.next()) {
                    LongValue longValue = LongValue.create(rs.getLong(1));
                    return longValue;
                }
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    @ReturnNullAsFalse
    public JdbcResultResource list_dbs(Env env) {
        return this.validateConnection(env).getCatalogs(env);
    }

    public boolean more_results(Env env) {
        return ((Mysqli)this.validateConnection(env)).moreResults();
    }

    public boolean multi_query(Env env, StringValue query) {
        return ((Mysqli)this.validateConnection(env)).multiQuery(env, query);
    }

    public boolean next_result(Env env) {
        return ((Mysqli)this.validateConnection(env)).nextResult();
    }

    public boolean options(Env env, int option, Value value) {
        if (option == 1) {
            Path path = env.lookupPwd(value);
            Value result = FileModule.parse_ini_file(env, path, true);
            if (result.isArray()) {
                Value charset;
                ArrayValue array = result.toArrayValue(env);
                Value clientArray = array.get(env.createString("client"));
                if (clientArray.isArray() && !(charset = clientArray.get(env.createString("default-character-set"))).isNull()) {
                    this._charset = charset.toStringValue();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Value query(Env env, StringValue sqlV, @Optional(value="MYSQLI_STORE_RESULT") int resultMode) {
        String sql = Mysqli.toBinarySafeString(sqlV);
        return this.realQuery(env, sql);
    }

    private static final String toBinarySafeString(StringValue str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch > '\u007f') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    protected Value realQuery(Env env, String sql) {
        this.clearErrors();
        this._lastSql = null;
        this.setResultResource(null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("mysql_query(" + sql + ")");
        }
        try {
            Connection conn = this.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            SqlParseToken tok = this.parseSqlToken(sql, null);
            if (tok != null) {
                switch (tok.getFirstChar()) {
                    case 'U': 
                    case 'u': {
                        if (tok.matchesToken("USE")) {
                            if ((tok = this.parseSqlToken(sql, tok)) == null) break;
                            String dbname = tok.toUnquotedString();
                            this.setCatalog(env, dbname);
                            return BooleanValue.TRUE;
                        }
                        if (tok == null || !tok.matchesToken("UPDATE")) break;
                        this._lastSql = LastSqlType.UPDATE;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (!tok.matchesToken("DESCRIBE")) break;
                        this._lastSql = LastSqlType.DESCRIBE;
                        break;
                    }
                }
            }
            return super.realQuery(env, sql);
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINER, e.toString(), e);
            return BooleanValue.FALSE;
        }
        catch (IllegalStateException e) {
            log.log(Level.FINEST, e.toString(), e);
            this.saveErrors(new SQLExceptionWrapper(e));
            return BooleanValue.FALSE;
        }
    }

    public boolean real_query(Env env, StringValue query) {
        return this.multiQuery(env, query);
    }

    public MysqliStatement prepare(Env env, String query) {
        MysqliStatement stmt = new MysqliStatement((Mysqli)this.validateConnection(env));
        boolean result = stmt.prepare(env, query);
        if (!result) {
            stmt.close();
            return null;
        }
        return stmt;
    }

    public boolean real_connect(Env env, @Optional(value="localhost") StringValue host, @Optional StringValue userName, @Optional StringValue password, @Optional StringValue dbname, @Optional(value="3306") int port, @Optional StringValue socket, @Optional int flags) {
        return this.connectInternal(env, host.toString(), userName.toString(), password.toString(), dbname.toString(), port, socket.toString(), flags, null, null, false, this._isEmulatePrepares);
    }

    public StringValue real_escape_string(Env env, StringValue str) {
        return this.realEscapeString(env, str);
    }

    @Override
    public boolean rollback() {
        return super.rollback();
    }

    public boolean select_db(Env env, String db) {
        try {
            if (this.isConnected()) {
                this.validateConnection(env).setCatalog(env, db);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean set_opt(Env env, int option, Value value) {
        return this.options(env, option, value);
    }

    public StringValue getsqlstate(Env env) {
        return this.sqlstate(env);
    }

    public StringValue sqlstate(Env env) {
        int code = this.validateConnection(env).getErrorCode();
        return env.createString(Mysqli.lookupSqlstate(code));
    }

    static String lookupSqlstate(int errno) {
        if (errno == 0) {
            return "00000";
        }
        return "HY" + errno;
    }

    @Override
    protected String getDriverName() {
        return "mysql";
    }

    public Value get_charset(Env env) {
        String collation;
        String charset;
        if (this._charset != null) {
            charset = this._charset.toString();
        } else {
            charset = "latin1";
            this._charset = env.createString(charset);
        }
        if (this._collation != null) {
            collation = this._collation.toString();
        } else {
            collation = MysqlCharset.getDefaultCollation(charset);
            this._collation = env.createString(collation);
        }
        int charsetIndex = MysqlCharset.getCollationIndex(collation);
        int maxBytes = MysqlCharset.getMaxBytes(charset);
        String description = MysqlCharset.getDescription(charset);
        ObjectValue obj = env.createObject();
        obj.putField(env, env.createString("charset"), (Value)this._charset);
        obj.putField(env, env.createString("collation"), (Value)this._collation);
        obj.putField(env, env.createString("dir"), (Value)env.getEmptyString());
        obj.putField(env, env.createString("min_length"), (Value)LongValue.ONE);
        obj.putField(env, env.createString("max_length"), (Value)LongValue.create(maxBytes));
        obj.putField(env, env.createString("number"), (Value)LongValue.create(charsetIndex));
        obj.putField(env, env.createString("state"), (Value)LongValue.ONE);
        obj.putField(env, env.createString("comment"), (Value)env.createString(description));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set_charset(Env env, StringValue charset) {
        Connection conn = this.getConnection(env);
        if (conn == null) {
            return false;
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            StringBuilder sb = new StringBuilder();
            sb.append("SET NAMES ");
            sb.append(charset);
            stmt.executeUpdate(sb.toString());
            stmt.close();
            this._charset = charset;
            stmt = conn.createStatement();
            stmt.execute("SELECT * FROM information_schema.SESSION_VARIABLES WHERE VARIABLE_NAME = 'collation_connection'");
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                String str = rs.getString(2);
                this._collation = env.createString(str);
            } else {
                this._collation = env.getEmptyString();
                env.warning(L.l("unable to retrieve collation_connection variable"));
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected Value getServerStat(Env env) {
        return this.stat(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value stat(Env env) {
        StringValue stringValue;
        block8: {
            JdbcConnectionResource connV = this.validateConnection(env);
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.execute("SHOW STATUS");
                HashMap<String, String> statusMap = new HashMap<String, String>();
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    statusMap.put(rs.getString(1), rs.getString(2));
                }
                StringValue sb = env.createStringBuilder();
                sb.append("Uptime: ");
                sb.append((String)statusMap.get("Uptime"));
                sb.append("  ");
                sb.append("Threads: ");
                sb.append((String)statusMap.get("Threads_connected"));
                sb.append("  ");
                sb.append("Questions: ");
                sb.append((String)statusMap.get("Queries"));
                sb.append("  ");
                sb.append("Slow queries: ");
                sb.append((String)statusMap.get("Slow_queries"));
                sb.append("  ");
                sb.append("Opens: ");
                sb.append((String)statusMap.get("Opened_tables"));
                sb.append("  ");
                sb.append("Flush tables: ");
                sb.append((String)statusMap.get("Flush_commands"));
                sb.append("  ");
                sb.append("Open tables: ");
                sb.append((String)statusMap.get("Open_tables"));
                sb.append("  ");
                sb.append("Queries per second avg: ");
                String totalQueriesStr = (String)statusMap.get("Queries");
                String uptimeStr = (String)statusMap.get("Uptime");
                long totalQueries = Long.valueOf(totalQueriesStr);
                long uptime = Long.valueOf(uptimeStr);
                double average = (double)totalQueries / (double)uptime;
                sb.append(String.format("%.2f", average));
                stringValue = sb;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.log(Level.FINE, e.toString(), e);
                    return BooleanValue.FALSE;
                }
            }
            stmt.close();
        }
        return stringValue;
    }

    public MysqliStatement stmt_init(Env env) {
        return new MysqliStatement((Mysqli)this.validateConnection(env));
    }

    @ReturnNullAsFalse
    public JdbcResultResource store_result(Env env) {
        return ((Mysqli)this.validateConnection(env)).storeResult();
    }

    public Value getthread_id(Env env) {
        return this.thread_id(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Value thread_id(Env env) {
        try {
            JdbcConnectionResource connV = this.validateConnection(env);
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return BooleanValue.FALSE;
            }
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT CONNECTION_ID()");
                if (rs.next()) {
                    LongValue longValue = LongValue.create(rs.getLong(1));
                    return longValue;
                }
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill(Env env, int threadId) {
        try {
            JdbcConnectionResource connV = this.validateConnection(env);
            Connection conn = connV.getConnection(env);
            if (conn == null) {
                return false;
            }
            Statement stmt = null;
            boolean result = false;
            try {
                stmt = conn.createStatement();
                this._conn.markForPoolRemoval();
                stmt.executeQuery("KILL CONNECTION " + threadId);
                result = true;
                conn.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            return result;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean thread_safe() {
        return true;
    }

    @ReturnNullAsFalse
    public JdbcResultResource use_result(Env env) {
        return ((Mysqli)this.validateConnection(env)).storeResult();
    }

    public int getwarning_count(Env env) {
        return this.warning_count(env);
    }

    public int warning_count(Env env) {
        return ((Mysqli)this.validateConnection(env)).getWarningCount(env);
    }

    @Override
    protected JdbcResultResource createResult(Statement stmt, ResultSet rs) {
        return new MysqliResult(stmt, rs, this);
    }

    private int getWarningCount(Env env) {
        MysqliResult rs = this.metaQuery(env, "SHOW WARNINGS", this.getCatalog());
        int warningCount = 0;
        if (rs != null) {
            warningCount = rs.getNumRows();
        }
        if (warningCount >= 0) {
            return warningCount;
        }
        return 0;
    }

    protected MysqliResult metaQuery(Env env, String sql, String catalog) {
        this.clearErrors();
        String currentCatalog = this.getCatalog();
        try {
            Connection conn = this.getConnection(env);
            if (conn == null) {
                return null;
            }
            conn.setCatalog(catalog);
            Statement stmt = conn.createStatement();
            stmt.setEscapeProcessing(false);
            if (stmt.execute(sql)) {
                MysqliResult result = (MysqliResult)this.createResult(stmt, stmt.getResultSet());
                conn.setCatalog(currentCatalog);
                return result;
            }
            conn.setCatalog(currentCatalog);
            return null;
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    private boolean moreResults() {
        return !this._hasBeenUsed || this._nextResultValue < this._resultValues.size() - 1;
    }

    private boolean multiQuery(Env env, StringValue sql) {
        this.clearErrors();
        this._resultValues.clear();
        ArrayList<String> splitQuery = this.splitMultiQuery(sql);
        Statement stmt = null;
        try {
            this.setResultResource(null);
            for (String s : splitQuery) {
                Connection conn = this.getConnection(env);
                if (conn == null) {
                    return false;
                }
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                if (stmt.execute(s)) {
                    this.setAffectedRows(0);
                    this.setResultResource(this.createResult(stmt, stmt.getResultSet()));
                    this._resultValues.add(this.getResultResource());
                    this.setWarnings(stmt.getWarnings());
                    continue;
                }
                this.setAffectedRows(stmt.getUpdateCount());
                this.setWarnings(stmt.getWarnings());
            }
        }
        catch (DataTruncation truncationError) {
            try {
                this.setAffectedRows(stmt.getUpdateCount());
                this.setWarnings(stmt.getWarnings());
            }
            catch (SQLException e) {
                this.saveErrors(e);
                log.log(Level.FINE, e.toString(), e);
                return false;
            }
        }
        catch (SQLException e) {
            this.saveErrors(e);
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        if (this._resultValues.size() > 0) {
            this._nextResultValue = 0;
            this._hasBeenUsed = false;
        }
        return true;
    }

    private boolean nextResult() {
        if (this._nextResultValue + 1 < this._resultValues.size()) {
            this._hasBeenUsed = false;
            ++this._nextResultValue;
            return true;
        }
        return false;
    }

    private ArrayList<String> splitMultiQuery(StringValue sqlStr) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder queryBuffer = new StringBuilder(64);
        String sql = sqlStr.toString();
        int length = sql.length();
        boolean inQuotes = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (c == '\\') {
                queryBuffer.append(c);
                if (i >= length - 1) continue;
                queryBuffer.append(sql.charAt(i + 1));
                ++i;
                continue;
            }
            if (inQuotes) {
                queryBuffer.append(c);
                if (c != '\'') continue;
                inQuotes = false;
                continue;
            }
            if (c == '\'') {
                queryBuffer.append(c);
                inQuotes = true;
                continue;
            }
            if (c == ';') {
                result.add(queryBuffer.toString().trim());
                queryBuffer = new StringBuilder(64);
                continue;
            }
            queryBuffer.append(c);
        }
        if (queryBuffer.length() > 0) {
            result.add(queryBuffer.toString().trim());
        }
        return result;
    }

    private JdbcResultResource storeResult() {
        if (!this._hasBeenUsed) {
            this._hasBeenUsed = true;
            return this._resultValues.get(this._nextResultValue);
        }
        return null;
    }

    public void setPersistent() {
        this._isPersistent = true;
    }

    Method getColumnCharacterSetMethod(Class<?> metaDataClass) {
        if (this._metaDataMethod == null) {
            MysqlMetaDataMethod metaDataMethod = _lastMetaDataMethod;
            if (metaDataMethod == null || metaDataMethod.getMetaDataClass() != metaDataClass) {
                _lastMetaDataMethod = metaDataMethod = new MysqlMetaDataMethod(metaDataClass);
            }
            this._metaDataMethod = metaDataMethod;
        }
        return this._metaDataMethod.getColumnCharacterSetMethod();
    }

    public boolean close(Env env) {
        this.close();
        return true;
    }

    @Override
    public String toString() {
        if (this._conn != null && this._conn.getConnection() != null) {
            Class<?> cls = this._conn.getConnection().getClass();
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("toString") || methods[i].getParameterTypes().length != 0) continue;
                return "Mysqli[" + this._conn.getConnection() + "]";
            }
            return "Mysqli[" + cls.getCanonicalName() + "]";
        }
        return "Mysqli[" + null + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MysqlMetaDataMethod {
        private Class<?> _resultSetMetaDataClass;
        private Method _getColumnCharacterSetMethod;

        MysqlMetaDataMethod(Class<?> resultSetMetaDataClass) {
            this._resultSetMetaDataClass = resultSetMetaDataClass;
            try {
                this._getColumnCharacterSetMethod = this._resultSetMetaDataClass.getMethod("getColumnCharacterSet", Integer.TYPE);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }

        Class<?> getMetaDataClass() {
            return this._resultSetMetaDataClass;
        }

        Method getColumnCharacterSetMethod() {
            return this._getColumnCharacterSetMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LastSqlType {
        NONE,
        UPDATE,
        DESCRIBE;

    }
}

