/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.dom;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.dom.DOMAttr;
import com.caucho.quercus.lib.dom.DOMCDATASection;
import com.caucho.quercus.lib.dom.DOMComment;
import com.caucho.quercus.lib.dom.DOMConfiguration;
import com.caucho.quercus.lib.dom.DOMDocumentFragment;
import com.caucho.quercus.lib.dom.DOMDocumentType;
import com.caucho.quercus.lib.dom.DOMElement;
import com.caucho.quercus.lib.dom.DOMEntityReference;
import com.caucho.quercus.lib.dom.DOMException;
import com.caucho.quercus.lib.dom.DOMImplementation;
import com.caucho.quercus.lib.dom.DOMNode;
import com.caucho.quercus.lib.dom.DOMNodeList;
import com.caucho.quercus.lib.dom.DOMProcessingInstruction;
import com.caucho.quercus.lib.dom.DOMText;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StringStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlPrinter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMDocument
extends DOMNode<Document> {
    private static final L10N L = new L10N(DOMDocument.class);
    private static final Logger log = Logger.getLogger(DOMDocument.class.getName());
    private String _encoding;

    DOMDocument(DOMImplementation impl, Document document) {
        super(impl, document);
    }

    public static DOMDocument __construct(Env env, @Optional(value="'1.0'") String version, @Optional String encoding) {
        DOMDocument document = DOMDocument.getImpl(env).createDocument();
        if (version != null && version.length() > 0) {
            document.setVersion(version);
        }
        if (encoding != null && encoding.length() > 0) {
            document.setEncoding(encoding);
        }
        return document;
    }

    public void setVersion(String version) {
        ((Document)this._delegate).setXmlVersion(version);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public DOMNode adoptNode(DOMNode source) throws DOMException {
        return (DOMNode)this.wrap(((Document)this._delegate).adoptNode(source.getDelegate()));
    }

    public DOMAttr createAttribute(String name) throws DOMException {
        try {
            return (DOMAttr)this.wrap(((Document)this._delegate).createAttribute(name));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMAttr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        try {
            return (DOMAttr)this.wrap(((Document)this._delegate).createAttributeNS(namespaceURI, qualifiedName));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMCDATASection createCDATASection(String data) {
        return (DOMCDATASection)this.wrap(((Document)this._delegate).createCDATASection(data));
    }

    public DOMComment createComment(String data) {
        return (DOMComment)this.wrap(((Document)this._delegate).createComment(data));
    }

    public DOMDocumentFragment createDocumentFragment() {
        return (DOMDocumentFragment)this.wrap(((Document)this._delegate).createDocumentFragment());
    }

    public DOMElement createElement(String tagName) throws DOMException {
        try {
            return (DOMElement)this.wrap(((Document)this._delegate).createElement(tagName));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMElement createElement(String tagName, String textContent) throws DOMException {
        try {
            DOMElement element = this.createElement(tagName);
            element.setTextContent(textContent);
            return element;
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMElement createElementNS(String namespaceURI, String tagName) throws DOMException {
        try {
            return (DOMElement)this.wrap(((Document)this._delegate).createElementNS(namespaceURI, tagName));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMElement createElementNS(String namespaceURI, String tagName, String textContent) throws DOMException {
        try {
            DOMElement element = this.createElementNS(namespaceURI, tagName);
            element.setTextContent(textContent);
            return element;
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMEntityReference createEntityReference(String name) throws DOMException {
        try {
            return (DOMEntityReference)this.wrap(((Document)this._delegate).createEntityReference(name));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMProcessingInstruction createProcessingInstruction(String target) throws DOMException {
        try {
            return this.createProcessingInstruction(target, null);
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        try {
            return (DOMProcessingInstruction)this.wrap(((Document)this._delegate).createProcessingInstruction(target, data));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public DOMText createTextNode(String data) {
        return (DOMText)this.wrap(((Document)this._delegate).createTextNode(data));
    }

    public DOMConfiguration getConfig() {
        throw new UnimplementedException();
    }

    public DOMDocumentType getDoctype() {
        return (DOMDocumentType)this.wrap(((Document)this._delegate).getDoctype());
    }

    public DOMElement getDocumentElement() {
        return (DOMElement)this.wrap(((Document)this._delegate).getDocumentElement());
    }

    public String getDocumentURI() {
        return ((Document)this._delegate).getDocumentURI();
    }

    public DOMConfiguration getDomConfig() {
        return (DOMConfiguration)this.wrap(((Document)this._delegate).getDomConfig());
    }

    public DOMElement getElementById(String elementId) {
        return (DOMElement)this.wrap(((Document)this._delegate).getElementById(elementId));
    }

    public DOMNodeList getElementsByTagName(String name) {
        return (DOMNodeList)this.wrap(((Document)this._delegate).getElementsByTagName(name));
    }

    public DOMNodeList getElementsByTagNameNS(String uri, String name) {
        return (DOMNodeList)this.wrap(((Document)this._delegate).getElementsByTagNameNS(uri, name));
    }

    public boolean getFormatOutput() {
        throw new UnimplementedException();
    }

    public DOMImplementation getImplementation() {
        return this.getImpl();
    }

    public String getInputEncoding() {
        return ((Document)this._delegate).getInputEncoding();
    }

    public boolean getPreserveWhiteSpace() {
        throw new UnimplementedException();
    }

    public boolean getRecover() {
        throw new UnimplementedException();
    }

    public boolean getResolveExternals() {
        throw new UnimplementedException();
    }

    public boolean getStrictErrorChecking() {
        return ((Document)this._delegate).getStrictErrorChecking();
    }

    public boolean getSubstituteEntities() {
        throw new UnimplementedException();
    }

    public boolean getValidateOnParse() {
        throw new UnimplementedException();
    }

    public String getVersion() {
        return ((Document)this._delegate).getXmlVersion();
    }

    public String getXmlEncoding() {
        return ((Document)this._delegate).getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return ((Document)this._delegate).getXmlStandalone();
    }

    public String getXmlVersion() {
        return ((Document)this._delegate).getXmlVersion();
    }

    public DOMNode importNode(DOMNode node) {
        return this.importNode(node, false);
    }

    public DOMNode importNode(DOMNode importedNode, boolean deep) throws DOMException {
        try {
            return (DOMNode)this.wrap(((Document)this._delegate).importNode(importedNode.getDelegate(), deep));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Env env, Path path, @Optional Value options) {
        if (options != null) {
            env.stub(L.l("`{0}' is ignored", (Object)"options"));
        }
        ReadStream is = null;
        try {
            is = path.openRead();
            this.getImpl().parseXMLDocument((Document)this._delegate, is, path.getPath());
        }
        catch (SAXException e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadHTML(Env env, String source) {
        ReadStream is = StringStream.open(source);
        try {
            this.getImpl().parseHTMLDocument((Document)this._delegate, is, null);
            ((Document)this._delegate).setXmlStandalone(true);
        }
        catch (SAXException e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            env.warning(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadHTMLFile(Env env, Path path) {
        ReadStream is = null;
        try {
            is = path.openRead();
            this.getImpl().parseHTMLDocument((Document)this._delegate, is, path.getPath());
            ((Document)this._delegate).setXmlStandalone(true);
        }
        catch (SAXException ex) {
            env.warning(ex);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            env.warning(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadXML(Env env, StringValue source, @Optional Value options) {
        if (options != null) {
            env.stub(L.l("loadXML 'options' is ignored"));
        }
        InputStream is = source.toInputStream();
        ReadStream in = null;
        try {
            in = Vfs.openRead(is);
            this.getImpl().parseXMLDocument((Document)this._delegate, in, null);
        }
        catch (SAXException ex) {
            env.warning(ex);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            env.warning(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtil.close(is);
            IoUtil.close(in);
        }
        return true;
    }

    public void normalizeDocument() {
        ((Document)this._delegate).normalizeDocument();
    }

    public boolean relaxNGValidate(String rngFilename) {
        throw new UnimplementedException();
    }

    public boolean relaxNGValidateSource(String rngSource) {
        throw new UnimplementedException();
    }

    public DOMNode renameNode(DOMNode node, String namespaceURI, String qualifiedName) throws DOMException {
        try {
            return (DOMNode)this.wrap(((Document)this._delegate).renameNode(node.getDelegate(), namespaceURI, qualifiedName));
        }
        catch (org.w3c.dom.DOMException ex) {
            throw this.wrap(ex);
        }
    }

    public Value save(Env env, Path path, @Optional Value options) {
        if (options != null) {
            env.stub(L.l("`{0}' is ignored", (Object)"options"));
        }
        return this.saveToFile(env, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value saveToFile(Env env, Path path, boolean isHTML) {
        WriteStream os = null;
        try {
            os = path.openWrite();
            this.saveToStream(this, os, isHTML);
        }
        catch (IOException ex) {
            env.warning(ex);
            BooleanValue booleanValue = BooleanValue.FALSE;
            return booleanValue;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception ex) {
                    log.log(Level.FINE, ex.toString(), ex);
                }
            }
        }
        return LongValue.create(path.getLength());
    }

    private void saveToStream(DOMNode delegate, WriteStream os, boolean isHTML) throws IOException {
        XmlPrinter printer = new XmlPrinter(os);
        printer.setMethod(isHTML ? "html" : "xml");
        printer.setEncoding(this._encoding);
        if (delegate._delegate instanceof Document) {
            printer.setPrintDeclaration(true);
            Document document = (Document)delegate._delegate;
            printer.setVersion(document.getXmlVersion());
            if (document.getXmlStandalone()) {
                printer.setStandalone("yes");
            }
            printer.printXml(document);
        } else {
            printer.printXml((Node)delegate._delegate);
        }
        if (this.hasChildNodes()) {
            os.println();
        }
    }

    @ReturnNullAsFalse
    public StringValue saveHTML(Env env) {
        return this.saveToString(env, this, true);
    }

    private StringValue saveToString(Env env, DOMNode node, boolean isHTML) {
        TempStream tempStream = new TempStream();
        try {
            tempStream.openWrite();
            WriteStream os = new WriteStream(tempStream);
            this.saveToStream(node, os, isHTML);
            os.close();
        }
        catch (IOException ex) {
            tempStream.discard();
            env.warning(ex);
            return null;
        }
        StringValue result = env.createBinaryString(tempStream.getHead());
        tempStream.discard();
        return result;
    }

    public Value saveHTMLFile(Env env, Path path) {
        return this.saveToFile(env, path, true);
    }

    @ReturnNullAsFalse
    public StringValue saveXML(Env env, @Optional DOMNode node, @Optional Value options) throws DOMException {
        if (options != null) {
            env.stub(L.l("`{0}' is ignored", (Object)"options"));
        }
        if (node != null) {
            if (node.getDelegate().getOwnerDocument() != this._delegate) {
                throw new DOMException(this.getImpl(), new org.w3c.dom.DOMException(4, "Wrong Document Error"));
            }
            return this.saveToString(env, node, false);
        }
        return this.saveToString(env, this, false);
    }

    public boolean schemaValidate(Env env, String schemaFilename) {
        File file = new File(schemaFilename);
        StreamSource source = new StreamSource(file);
        return this.validate(env, source);
    }

    public boolean schemaValidateSource(Env env, String schemaSource) {
        StreamSource source = new StreamSource(new StringReader(schemaSource));
        return this.validate(env, source);
    }

    private boolean validate(Env env, Source source) {
        String language = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(language);
        try {
            Schema schema = factory.newSchema(source);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(this.getDelegate()));
            return true;
        }
        catch (SAXException e) {
            env.warning(e);
            return false;
        }
        catch (IOException e) {
            env.warning(e);
            return false;
        }
        catch (Exception e) {
            env.warning(e);
            return false;
        }
    }

    public void setDocumentURI(String documentURI) {
        ((Document)this._delegate).setDocumentURI(documentURI);
    }

    public void setFormatOutput(boolean formatOutput) {
        throw new UnimplementedException();
    }

    public void setPreserveWhiteSpace(boolean preserveWhiteSpace) {
        throw new UnimplementedException();
    }

    public void setRecover(boolean recover) {
        throw new UnimplementedException();
    }

    public void setResolveExternals(boolean resolveExternals) {
        throw new UnimplementedException();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        ((Document)this._delegate).setStrictErrorChecking(strictErrorChecking);
    }

    public void setSubstituteEntities(boolean substituteEntities) {
        throw new UnimplementedException();
    }

    public void setValidateOnParse(boolean validateOnParse) {
        throw new UnimplementedException();
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        ((Document)this._delegate).setXmlStandalone(xmlStandalone);
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        ((Document)this._delegate).setXmlVersion(xmlVersion);
    }

    public boolean validate() {
        throw new UnimplementedException();
    }

    public int xinclude(Env env, @Optional Value options) {
        if (options != null) {
            env.stub(L.l("`{0}' is ignored", (Object)"options"));
        }
        return 0;
    }
}

