/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.Directory;

public class WrappedDirectory
extends Directory {
    private static final ConstStringValue DIR_CLOSEDIR = new ConstStringValue("dir_closedir");
    private static final ConstStringValue DIR_OPENDIR = new ConstStringValue("dir_opendir");
    private static final ConstStringValue DIR_READDIR = new ConstStringValue("dir_readdir");
    private static final ConstStringValue DIR_REWINDDIR = new ConstStringValue("dir_rewinddir");
    private static final UnicodeBuilderValue DIR_CLOSEDIR_U = new UnicodeBuilderValue("dir_closedir");
    private static final UnicodeBuilderValue DIR_OPENDIR_U = new UnicodeBuilderValue("dir_opendir");
    private static final UnicodeBuilderValue DIR_READDIR_U = new UnicodeBuilderValue("dir_readdir");
    private static final UnicodeBuilderValue DIR_REWINDDIR_U = new UnicodeBuilderValue("dir_rewinddir");
    private Value _wrapper;

    public WrappedDirectory(Env env, QuercusClass qClass) {
        this._wrapper = qClass.callNew(env, Value.NULL_ARGS);
    }

    public boolean open(Env env, StringValue path, LongValue flags) {
        if (env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(env, (StringValue)DIR_OPENDIR_U, path, (Value)flags).toBoolean();
        }
        return this._wrapper.callMethod(env, (StringValue)DIR_OPENDIR, path, (Value)flags).toBoolean();
    }

    public Value read(Env env) {
        if (env.isUnicodeSemantics()) {
            return this._wrapper.callMethod(env, DIR_READDIR_U);
        }
        return this._wrapper.callMethod(env, DIR_READDIR);
    }

    public void rewind(Env env) {
        if (env.isUnicodeSemantics()) {
            this._wrapper.callMethod(env, DIR_REWINDDIR_U);
        } else {
            this._wrapper.callMethod(env, DIR_REWINDDIR);
        }
    }

    public void close(Env env) {
        if (env.isUnicodeSemantics()) {
            this._wrapper.callMethod(env, DIR_CLOSEDIR_U);
        } else {
            this._wrapper.callMethod(env, DIR_CLOSEDIR);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._wrapper + "]";
    }
}

