/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.lib.pdf.PDFObject;
import com.caucho.quercus.lib.pdf.PDFWriter;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class PDFImage
extends PDFObject {
    private static final Logger log = Logger.getLogger(PDFImage.class.getName());
    private static final L10N L = new L10N(PDFImage.class);
    private Path _path;
    private ReadStream _is;
    private BufferedImage _image;
    private int _id;
    private String _type;
    private int _width;
    private int _height;
    private int _bits;
    private TempBuffer _jpegHead;

    public PDFImage(Path path) throws IOException {
        this._path = path;
        this._is = path.openRead();
        try {
            this.parseImage();
        }
        finally {
            this._is.close();
        }
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public double get_width() {
        return this._width;
    }

    public double get_height() {
        return this._height;
    }

    private boolean parseImage() throws IOException {
        this._image = ImageIO.read(this._is);
        this._width = this._image.getWidth();
        this._height = this._image.getHeight();
        TempStream ts = new TempStream();
        WriteStream os = new WriteStream(ts);
        try {
            ImageIO.write((RenderedImage)this._image, "jpeg", os);
        }
        finally {
            os.close();
        }
        return this.parseImageJpeg(ts.openRead());
    }

    private boolean parseImageJpeg(ReadStream is) throws IOException {
        int ch = is.read();
        if (ch != 255) {
            return false;
        }
        if (is.read() != 216) {
            return false;
        }
        TempStream ts = new TempStream();
        WriteStream ws = new WriteStream(ts);
        ws.write(255);
        ws.write(216);
        is.writeToStream(ws);
        ws.close();
        this._jpegHead = ts.getHead();
        is.close();
        this._is = new ReadStream();
        ts.openRead(this._is);
        this.parseJPEG();
        return true;
    }

    private boolean parseGIF() throws IOException {
        int width = (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF);
        int heigth = (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF);
        int flags = this._is.read();
        int background = this._is.read();
        int pad = this._is.read();
        int depth = (flags & 7) + 1;
        int[] colorMap = null;
        if ((flags & 0x80) == 0) {
            System.out.println("GIF: can't cope with local");
            return false;
        }
        colorMap = this.parseGIFColorMap(depth);
        int ch = this._is.read();
        if (ch != 44) {
            return false;
        }
        int imgLeft = (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF);
        int imgTop = (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF);
        int imgWidth = (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF);
        int imgHeight = (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF);
        flags = this._is.read() & 0xFF;
        if ((flags & 0x80) != 0) {
            System.out.println("GIF: can't cope with local");
            return false;
        }
        if ((flags & 0x40) != 0) {
            System.out.println("GIF: can't cope with interlaced");
            return false;
        }
        this.parseGIFData(colorMap);
        return false;
    }

    private int[] parseGIFColorMap(int depth) throws IOException {
        int[] values = new int[1 << depth];
        for (int i = 0; i < values.length; ++i) {
            int value;
            values[i] = value = 65536 * (this._is.read() & 0xFF) + 256 * (this._is.read() & 0xFF) + 1 * (this._is.read() & 0xFF);
        }
        return values;
    }

    private void parseGIFData(int[] colorMap) throws IOException {
    }

    private boolean parseJPEG() throws IOException {
        int ch;
        if (this._is.read() != 255 || this._is.read() != 216) {
            return false;
        }
        while ((ch = this._is.read()) == 255) {
            int len;
            ch = this._is.read();
            if (ch == 255) {
                this._is.unread();
                continue;
            }
            if (208 <= ch && ch <= 217 || 1 == ch) continue;
            if (ch == 192) {
                len = 256 * this._is.read() + this._is.read();
                this._bits = this._is.read();
                this._height = 256 * this._is.read() + this._is.read();
                this._width = 256 * this._is.read() + this._is.read();
                this._type = "jpeg";
                return true;
            }
            len = 256 * this._is.read() + this._is.read();
            this._is.skip(len - 2);
        }
        return false;
    }

    String getResourceName() {
        return "/XObject";
    }

    String getResource() {
        return "<< /I" + this._id + " " + this._id + " 0 R >>";
    }

    public void writeObjectNew(PDFWriter out) throws IOException {
        int sublen;
        long length = this._path.getLength();
        out.println("<< /Type /XObject");
        out.println("   /Subtype /Image");
        out.println("   /Width " + this._width);
        out.println("   /Height " + this._height);
        out.println("   /ColorSpace /DeviceRGB");
        out.println("   /BitsPerComponent " + this._bits);
        out.println("   /Length " + length);
        out.println(">>");
        out.println("stream");
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        ReadStream is = this._path.openRead();
        while ((sublen = ((InputStream)is).read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, sublen);
        }
        out.println();
        out.println("endstream");
    }

    public void writeObject(PDFWriter out) throws IOException {
        TempBuffer ptr;
        int length = 0;
        for (ptr = this._jpegHead; ptr != null; ptr = ptr.getNext()) {
            length += ptr.getLength();
        }
        out.println("<< /Type /XObject");
        out.println("   /Subtype /Image");
        out.println("   /Width " + this._width);
        out.println("   /Height " + this._height);
        out.println("   /ColorSpace /DeviceRGB");
        out.println("   /BitsPerComponent " + this._bits);
        out.println("   /Filter /DCTDecode");
        out.println("   /Length " + length);
        out.println(">>");
        out.println("stream");
        for (ptr = this._jpegHead; ptr != null; ptr = ptr.getNext()) {
            out.write(ptr.getBuffer(), 0, ptr.getLength());
        }
        out.println();
        out.println("endstream");
    }

    static class GIFDecode {
        private final int _codeSize;
        private final int _clearCode;
        private final int _endOfCode;
        private ReadStream _is;
        private int _blockSize;

        GIFDecode(ReadStream is) throws IOException {
            this._is = is;
            this._codeSize = this._is.read();
            this._clearCode = 1 << this._codeSize;
            this._endOfCode = this._clearCode + 1;
        }

        int readByte() throws IOException {
            if (this._blockSize < 0) {
                return -1;
            }
            if (this._blockSize == 0) {
                this._blockSize = this._is.read();
                if (this._blockSize == 0) {
                    this._blockSize = -1;
                    return -1;
                }
            }
            --this._blockSize;
            return this._is.read();
        }
    }
}

