/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.AttributeListView;
import com.caucho.quercus.lib.simplexml.AttributeView;
import com.caucho.quercus.lib.simplexml.ChildrenView;
import com.caucho.quercus.lib.simplexml.IteratorIndex;
import com.caucho.quercus.lib.simplexml.SelectedView;
import com.caucho.quercus.lib.simplexml.SimpleNamespaceContext;
import com.caucho.quercus.lib.simplexml.SimpleUtil;
import com.caucho.quercus.lib.simplexml.SimpleView;
import com.caucho.quercus.lib.simplexml.SimpleXMLElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementView
extends SimpleView {
    private static final Logger log = Logger.getLogger(ElementView.class.getName());
    private final Node _node;

    public ElementView(Node node) {
        super(node.getOwnerDocument());
        this._node = node;
    }

    @Override
    public String getNodeName() {
        String name = this._node.getNodeName();
        int i = name.indexOf(58);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    @Override
    public ChildrenView getChildren(String namespace, String prefix) {
        ArrayList<SimpleView> childList = new ArrayList<SimpleView>();
        Node node = this.getNode();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childName = child.getNodeName();
            if (child.getNodeType() != 1 || namespace != null && !SimpleUtil.isSameNamespace(child, namespace) || prefix != null && !prefix.equals(SimpleUtil.getPrefix(childName))) continue;
            ElementView view = new ElementView((Element)child);
            childList.add(view);
        }
        ArrayList<AttributeView> attrList = new ArrayList<AttributeView>();
        NamedNodeMap attrMap = this._node.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Attr attr = (Attr)attrMap.item(i);
            AttributeView view = new AttributeView(attr);
            attrList.add(view);
        }
        return new ChildrenView(this, childList, attrList);
    }

    @Override
    public AttributeListView getAttributes(String namespace) {
        ArrayList<AttributeView> attrList = new ArrayList<AttributeView>();
        NamedNodeMap attrMap = this._node.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            String nsAttrName;
            String attrNamespace;
            Attr attr = (Attr)attrMap.item(i);
            String name = attr.getNodeName();
            String prefix = SimpleUtil.getPrefix(name);
            if ("xmlns".equals(name) || "xmlns".equals(prefix) || (namespace != null || prefix != null) && (namespace == null || prefix == null || !namespace.equals(attrNamespace = this.getNamespace(nsAttrName = "xmlns:" + prefix)))) continue;
            AttributeView view = new AttributeView(attr);
            attrList.add(view);
        }
        AttributeListView view = new AttributeListView(this.getOwnerDocument(), attrList);
        return view;
    }

    private String getNamespace(String nsAttrName) {
        NamedNodeMap attrMap;
        for (Node node = this._node; node != null && (attrMap = node.getAttributes()) != null; node = node.getParentNode()) {
            Attr attr = (Attr)attrMap.getNamedItem(nsAttrName);
            if (attr == null) continue;
            return attr.getNodeValue();
        }
        return null;
    }

    @Override
    public SimpleView addChild(Env env, String name, String value, String namespace) {
        Document doc = this._node.getOwnerDocument();
        int i = name.indexOf(58);
        String prefix = null;
        if (i >= 0) {
            if (namespace != null) {
                prefix = name.substring(0, i);
            } else {
                name = name.substring(i + 1);
            }
        }
        Element e = prefix != null && namespace != null ? doc.createElementNS(namespace, name) : doc.createElement(name);
        this._node.appendChild(e);
        if (namespace != null && !SimpleUtil.hasNamespace(this._node, prefix, namespace)) {
            Attr attr = prefix != null ? doc.createAttribute("xmlns:" + prefix) : doc.createAttribute("xmlns");
            attr.setNodeValue(namespace);
            ElementView.addAttribute(e, attr);
        }
        if (value != null) {
            e.setTextContent(value);
        }
        ElementView view = new ElementView(e);
        return view;
    }

    @Override
    public void addAttribute(Env env, String name, String value, String namespace) {
        Document doc = this.getOwnerDocument();
        String prefix = SimpleUtil.getPrefix(name);
        if (namespace != null && !SimpleUtil.hasNamespace(this._node, prefix, namespace)) {
            Attr namespaceAttr = prefix != null ? doc.createAttribute("xmlns:" + prefix) : doc.createAttribute("xmlns");
            namespaceAttr.setNodeValue(namespace);
            ElementView.addAttribute(this._node, namespaceAttr);
        }
        Attr attr = doc.createAttribute(name);
        attr.setNodeValue(value);
        ElementView.addAttribute(this._node, attr);
    }

    private static void addAttribute(Node node, Attr attr) {
        NamedNodeMap attrMap = node.getAttributes();
        attrMap.setNamedItem(attr);
    }

    @Override
    public HashMap<String, String> getNamespaces(boolean isRecursive, boolean isFromRoot, boolean isCheckUsage) {
        LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> usedMap = new LinkedHashMap<String, String>();
        Node node = isFromRoot ? this.getOwnerDocument().getDocumentElement() : this._node;
        this.getNamespaces(newMap, usedMap, node, isRecursive, isCheckUsage, true);
        if (!isCheckUsage) {
            usedMap = newMap;
        }
        return usedMap;
    }

    private void getNamespaces(HashMap<String, String> newMap, HashMap<String, String> usedMap, Node node, boolean isRecursive, boolean isCheckUsage, boolean isTop) {
        String prefix;
        String namespace;
        String nodeName;
        int i;
        NamedNodeMap attrMap = node.getAttributes();
        if ((isTop || isRecursive) && attrMap != null) {
            for (int i2 = 0; i2 < attrMap.getLength(); ++i2) {
                Attr attr = (Attr)attrMap.item(i2);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:")) continue;
                String prefix2 = "";
                int j = attrName.indexOf(58);
                if (j >= 0) {
                    prefix2 = attrName.substring(j + 1);
                }
                newMap.put(prefix2, attr.getNodeValue());
            }
        }
        if (isCheckUsage && (i = (nodeName = node.getNodeName()).indexOf(58)) >= 0 && (namespace = newMap.get(prefix = nodeName.substring(0, i))) != null) {
            usedMap.put(prefix, namespace);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.getNamespaces(newMap, usedMap, child, isRecursive, isCheckUsage, false);
        }
    }

    @Override
    public List<SimpleView> xpath(Env env, SimpleNamespaceContext context, String expression) {
        try {
            return SimpleView.xpath(this._node, context, expression);
        }
        catch (XPathExpressionException e) {
            log.log(Level.FINE, e.getMessage());
            env.warning(e);
            return null;
        }
    }

    @Override
    protected Node getNode() {
        return this._node;
    }

    @Override
    public SimpleView getIndex(Env env, Value indexV) {
        if (indexV.isString()) {
            String name = indexV.toString();
            Attr attr = this.getAttribute(name);
            if (attr == null) {
                return null;
            }
            AttributeView view = new AttributeView(attr);
            return view;
        }
        if (indexV.isLongConvertible()) {
            int i = indexV.toInt();
            if (i == 0) {
                return this;
            }
            for (Node next = this._node.getNextSibling(); next != null && i >= 0; next = next.getNextSibling()) {
                if (!next.getNodeName().equals(this._node.getNodeName()) || --i != 0) continue;
                ElementView view = new ElementView(next);
                return view;
            }
            return null;
        }
        return null;
    }

    @Override
    public SimpleView setIndex(Env env, Value indexV, Value value) {
        String str = value.toString();
        Node node = this._node;
        Document doc = node.getOwnerDocument();
        if (indexV.isLongConvertible()) {
            node.setTextContent(str);
        } else {
            Attr attr = doc.createAttribute(indexV.toString());
            attr.setValue(str);
            NamedNodeMap attrMap = node.getAttributes();
            attrMap.setNamedItem(attr);
        }
        return this;
    }

    @Override
    public SimpleView getField(Env env, Value indexV) {
        SimpleView view;
        String nodeName = indexV.toStringValue(env).toString();
        ArrayList<SimpleView> childList = new ArrayList<SimpleView>();
        for (Node child = this.getNode().getFirstChild(); child != null; child = child.getNextSibling()) {
            String childName;
            if (child.getNodeType() != 1 || !nodeName.equals(childName = child.getNodeName())) continue;
            view = new ElementView(child);
            childList.add(view);
        }
        ArrayList<AttributeView> attrList = new ArrayList<AttributeView>();
        view = new SelectedView(this, nodeName, childList, attrList);
        return view;
    }

    private Node getChild(String name) {
        for (Node child = this._node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private Attr getAttribute(String name) {
        NamedNodeMap map = this._node.getAttributes();
        Attr attr = (Attr)map.getNamedItem(name);
        return attr;
    }

    @Override
    public SimpleView setField(Env env, Value indexV, Value value) {
        String name = indexV.toString();
        Node child = this.getChild(name);
        if (child == null) {
            Document doc = this._node.getOwnerDocument();
            Element e = doc.createElement(name);
            e.setTextContent(value.toString());
            this._node.appendChild(e);
        } else {
            child.setTextContent(value.toString());
        }
        return this;
    }

    @Override
    public int getCount() {
        int count = 0;
        for (Node child = this._node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String toString(Env env) {
        StringBuilder sb = new StringBuilder();
        for (Node child = this._node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                sb.append(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() != 5) continue;
            String name = child.getNodeName();
            int ch = SimpleUtil.fromEntity(name);
            if (ch >= 0) {
                sb.append((char)ch);
                continue;
            }
            sb.append('&');
            sb.append(name);
            sb.append(';');
        }
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<IteratorIndex, SimpleView>> getIterator() {
        ChildrenView view = this.getChildren(null, null);
        return view.getIterator();
    }

    @Override
    public Set<Map.Entry<Value, Value>> getEntrySet(Env env, QuercusClass cls) {
        LinkedHashMap<Value, Value> map = new LinkedHashMap<Value, Value>();
        NamedNodeMap attrMap = this._node.getAttributes();
        if (attrMap.getLength() > 0) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                String value = attr.getNodeValue();
                array.put(env.createString(attr.getNodeName()), env.createString(value));
            }
            map.put(env.createString("@attributes"), array);
        }
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (Node child = this._node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            elementList.add((Element)child);
        }
        if (elementList.size() == 0) {
            String text = this.toString(env);
            if (text != null) {
                map.put(LongValue.ZERO, env.createString(text));
            }
        } else if (elementList.size() == 1) {
            Element node = (Element)elementList.get(0);
            StringValue name = env.createString(node.getNodeName());
            ElementView view = new ElementView(node);
            SimpleXMLElement e = new SimpleXMLElement(cls, view);
            Value value = e.wrapJava(env);
            map.put(name, value);
        } else if (elementList.size() > 1) {
            for (Element node : elementList) {
                StringValue name = env.createString(node.getNodeName());
                ElementView view = new ElementView(node);
                SimpleXMLElement e = new SimpleXMLElement(cls, view);
                Value value = e.wrapJava(env);
                Value oldValue = (Value)map.get(name);
                if (oldValue == null) {
                    map.put(name, value);
                    continue;
                }
                if (oldValue.isArray()) {
                    oldValue.toArrayValue(env).append(value);
                    continue;
                }
                ArrayValueImpl array = new ArrayValueImpl();
                array.append(oldValue);
                array.append(value);
                map.put(name, array);
            }
        }
        return map.entrySet();
    }

    @Override
    public boolean toXml(Env env, StringBuilder sb) {
        SimpleUtil.toXml(env, sb, this._node);
        return true;
    }

    @Override
    public Value toDumpValue(Env env, QuercusClass cls, boolean isChildren) {
        ArrayList<ElementView> elementList = new ArrayList<ElementView>();
        ArrayList<AttributeView> attrList = new ArrayList<AttributeView>();
        for (Node child = this._node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ElementView view = new ElementView((Element)child);
            elementList.add(view);
        }
        NamedNodeMap attrMap = this._node.getAttributes();
        if (attrMap.getLength() > 0) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                AttributeView attributeView = new AttributeView(attr);
                attrList.add(attributeView);
            }
        }
        ObjectValue obj = env.createObject();
        obj.setClassName(cls.getName());
        if (attrList.size() > 0) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (AttributeView attributeView : attrList) {
                StringValue attrName = env.createString(attributeView.getNodeName());
                StringValue attrValue = env.createString(attributeView.getNodeValue());
                ((ArrayValue)array).append(attrName, attrValue);
            }
            obj.putField(env, env.createString("@attributes"), (Value)array);
        }
        if (elementList.size() == 0) {
            String text = this.toString(env);
            if (text != null && text.length() > 0) {
                if (isChildren) {
                    StringValue stringValue = env.createString(text);
                    obj.putField(env, env.createString("0"), (Value)stringValue);
                    return obj;
                }
                return env.createString(text);
            }
            return obj;
        }
        for (ElementView elementView : elementList) {
            StringValue stringValue = env.createString(elementView.getNodeName());
            SimpleXMLElement e = new SimpleXMLElement(cls, elementView);
            Value value = e.wrapJava(env);
            Value oldValue = obj.getField(env, stringValue);
            if (oldValue == UnsetValue.UNSET) {
                obj.putField(env, stringValue, value);
                continue;
            }
            if (oldValue.isArray()) {
                oldValue.toArrayValue(env).append(value);
                continue;
            }
            ArrayValueImpl array = new ArrayValueImpl();
            array.append(oldValue);
            array.append(value);
            obj.putField(env, stringValue, (Value)array);
        }
        return obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Node child = this._node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue().trim();
            text = text.replace("\n", " ");
            sb.append(text);
        }
        if (sb.length() > 0) {
            return this.getClass().getSimpleName() + "[name=" + this._node.getNodeName() + ",text=" + sb + ",hash=" + this._node.hashCode() + "]";
        }
        return this.getClass().getSimpleName() + "[name=" + this._node.getNodeName() + ",hash=" + this._node.hashCode() + "]";
    }
}

