/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.marshal.StringMarshal;

public class RegexpArrayMarshal
extends StringMarshal {
    public static final RegexpArrayMarshal MARSHAL = new RegexpArrayMarshal();

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        value = value.toValue();
        return RegexpModule.createRegexpArray(value);
    }

    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isArray()) {
            return 0;
        }
        if (argValue.isString()) {
            return 100;
        }
        return 0x3FFFFFF;
    }

    public int getMarshalingCost(Expr expr) {
        if (expr.isArray()) {
            return 0;
        }
        return 100;
    }

    public Class getExpectedClass() {
        return Regexp[].class;
    }
}

