/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.config.ConfigException;
import com.caucho.quercus.annotation.Hide;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.JavaInvoker;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInfo {
    private static L10N L = new L10N(ModuleInfo.class);
    private static final Logger log = Logger.getLogger(ModuleInfo.class.getName());
    private final String _name;
    private final QuercusModule _module;
    private HashSet<String> _extensionSet = new HashSet();
    private HashMap<StringValue, Value> _constMap = new HashMap();
    private HashMap<StringValue, Value> _unicodeConstMap = new HashMap();
    private HashMap<String, Method[]> _staticFunctions = new HashMap();
    private IniDefinitions _iniDefinitions = new IniDefinitions();
    private HashSet<String> _extensionClassMap = new HashSet();

    public ModuleInfo(String name, QuercusModule module) throws ConfigException {
        this._name = name;
        this._module = module;
        this.init();
    }

    private void init() throws ConfigException {
        try {
            this.introspectPhpModuleClass(this._module.getClass());
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public String getName() {
        return this._name;
    }

    public void addExtensionClass(String name) {
        this._extensionClassMap.add(name);
    }

    public QuercusModule getModule() {
        return this._module;
    }

    public HashSet<String> getLoadedExtensions() {
        return this._extensionSet;
    }

    public HashMap<StringValue, Value> getConstMap() {
        return this._constMap;
    }

    public HashMap<StringValue, Value> getUnicodeConstMap() {
        return this._unicodeConstMap;
    }

    public Value getConstant(StringValue name) {
        return this._constMap.get(name);
    }

    public HashMap<String, Method[]> getFunctions() {
        return this._staticFunctions;
    }

    public IniDefinitions getIniDefinitions() {
        return this._iniDefinitions;
    }

    private void introspectPhpModuleClass(Class<?> cl) throws IllegalAccessException, InstantiationException {
        for (String ext : this._module.getLoadedExtensions()) {
            this._extensionSet.add(ext);
        }
        Map<StringValue, Value> map = this._module.getConstMap();
        if (map != null) {
            this._constMap.putAll(map);
            this._unicodeConstMap.putAll(map);
        }
        for (Field field : cl.getFields()) {
            Object obj;
            Value value;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (value = ModuleInfo.objectToValue(obj = field.get(null))) == null) continue;
            this._constMap.put(new ConstStringValue(field.getName()), value);
            this._unicodeConstMap.put(new UnicodeBuilderValue(field.getName()), value);
        }
        IniDefinitions iniDefinitions = this._module.getIniDefinitions();
        if (map != null) {
            this._iniDefinitions.addAll(iniDefinitions);
        }
        for (Method method : cl.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().isAssignableFrom(AbstractQuercusModule.class) || !Modifier.isPublic(method.getModifiers()) || method.getAnnotation(Hide.class) != null || "getLoadedExtensions".equals(method.getName())) continue;
            if (ModuleInfo.hasCheckedException(method)) {
                log.warning(L.l("Module method '{0}.{1}' may not throw checked exceptions", (Object)method.getDeclaringClass().getName(), (Object)method.getName()));
                continue;
            }
            try {
                if (method.getName().startsWith("quercus_")) {
                    throw new UnsupportedOperationException(L.l("{0}: use @Name instead", (Object)method));
                }
                String functionName = JavaInvoker.getFunctionName(method);
                Method[] methods = this._staticFunctions.get(functionName);
                if (methods != null) {
                    Method[] oldMethods = methods;
                    methods = new Method[oldMethods.length + 1];
                    System.arraycopy(oldMethods, 0, methods, 0, oldMethods.length);
                    methods[oldMethods.length] = method;
                } else {
                    methods = new Method[]{method};
                }
                this._staticFunctions.put(functionName, methods);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private static boolean hasCheckedException(Method method) {
        for (Class<?> exnCl : method.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exnCl)) continue;
            return true;
        }
        return false;
    }

    public static Value objectToValue(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        Class<?> cls = obj.getClass();
        if (Byte.class.equals(cls) || Short.class.equals(cls) || Integer.class.equals(cls) || Long.class.equals(cls)) {
            return LongValue.create(((Number)obj).longValue());
        }
        if (Float.class.equals(cls) || Double.class.equals(cls)) {
            return DoubleValue.create(((Number)obj).doubleValue());
        }
        if (String.class.equals(cls)) {
            return new StringBuilderValue((String)obj);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

