/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.java.WorkDir;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusLineRuntimeException;
import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusValueException;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequestImpl;
import com.caucho.quercus.servlet.api.QuercusHttpServletResponseImpl;
import com.caucho.quercus.servlet.api.QuercusServletContextImpl;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QuercusServletImpl
extends HttpServlet {
    private static final L10N L = new L10N(QuercusServletImpl.class);
    private static final Logger log = Logger.getLogger(QuercusServletImpl.class.getName());
    protected QuercusContext _quercus;
    protected ServletConfig _config;
    protected ServletContext _servletContext;

    public final void init(ServletConfig config) throws ServletException {
        this._config = config;
        this._servletContext = config.getServletContext();
        this.checkServletAPIVersion();
        FilePath pwd = new FilePath(this._servletContext.getRealPath("/"));
        FilePath webInfDir = new FilePath(this._servletContext.getRealPath("/WEB-INF"));
        this.getQuercus().setPwd(pwd);
        this.getQuercus().setWebInfDir(webInfDir);
        if (!CurrentTime.isTest() && !this.getQuercus().isResin()) {
            Vfs.setPwd(pwd);
            WorkDir.setLocalWorkDir(webInfDir.lookup("work"));
        }
        this.initImpl(config);
        this.getQuercus().init();
        this.getQuercus().start();
    }

    protected void initImpl(ServletConfig config) throws ServletException {
    }

    public void setProfileProbability(double probability) {
    }

    protected void checkServletAPIVersion() {
        int major = this._servletContext.getMajorVersion();
        int minor = this._servletContext.getMinorVersion();
        if (major < 2 || major == 2 && minor < 4) {
            throw new QuercusRuntimeException(L.l("Quercus requires Servlet API 2.4+."));
        }
    }

    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Env env = null;
        WriteStream ws = null;
        QuercusHttpServletRequestImpl req = new QuercusHttpServletRequestImpl(request);
        QuercusHttpServletResponseImpl res = new QuercusHttpServletResponseImpl(response);
        try {
            QuercusPage page;
            Path path = this.getPath(req);
            try {
                page = this.getQuercus().parse(path);
            }
            catch (FileNotFoundException e) {
                log.log(Level.FINER, e.toString(), e);
                response.sendError(404);
                return;
            }
            ws = this.openWrite(response);
            ws.setDisableCloseSource(true);
            ws.setNewlineString("\n");
            QuercusContext quercus = this.getQuercus();
            env = quercus.createEnv(page, ws, req, res);
            env.setPwd(path.getParent());
            quercus.setServletContext(new QuercusServletContextImpl(this._servletContext));
            try {
                env.start();
                StringValue prepend = quercus.getIniValue("auto_prepend_file").toStringValue(env);
                if (prepend.length() > 0) {
                    Path prependPath = env.lookup(prepend);
                    if (prependPath == null) {
                        env.error(L.l("auto_prepend_file '{0}' not found.", (Object)prepend));
                    } else {
                        QuercusPage prependPage = this.getQuercus().parse(prependPath);
                        prependPage.executeTop(env);
                    }
                }
                env.executeTop();
                StringValue append = quercus.getIniValue("auto_append_file").toStringValue(env);
                if (append.length() > 0) {
                    Path appendPath = env.lookup(append);
                    if (appendPath == null) {
                        env.error(L.l("auto_append_file '{0}' not found.", (Object)append));
                    } else {
                        QuercusPage appendPage = this.getQuercus().parse(appendPath);
                        appendPage.executeTop(env);
                    }
                }
            }
            catch (QuercusExitException e) {
                throw e;
            }
            catch (QuercusErrorException e) {
                throw e;
            }
            catch (QuercusLineRuntimeException e) {
                log.log(Level.FINE, e.toString(), e);
                ws.println(e.getMessage());
            }
            catch (QuercusValueException e) {
                log.log(Level.FINE, e.toString(), e);
                ws.println(e.toString());
            }
            catch (StackOverflowError e) {
                RuntimeException myException = new RuntimeException(L.l("StackOverflowError at {0}", (Object)env.getLocation()), e);
                throw myException;
            }
            catch (Throwable e) {
                if (response.isCommitted()) {
                    e.printStackTrace(ws.getPrintWriter());
                }
                ws = null;
                throw e;
            }
            finally {
                if (env != null) {
                    env.close();
                }
                if (ws != null && env.getDuplex() == null) {
                    ws.close();
                }
            }
        }
        catch (QuercusDieException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (QuercusExitException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusErrorException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleThrowable(response, e);
        }
    }

    protected void handleThrowable(HttpServletResponse response, Throwable e) throws IOException, ServletException {
        throw new ServletException(e);
    }

    protected WriteStream openWrite(HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        WriteStream ws = Vfs.openWrite((OutputStream)out);
        return ws;
    }

    protected Path getPath(QuercusHttpServletRequest req) {
        Path path;
        Path pwd = this.getQuercus().getPwd().copy();
        String servletPath = QuercusRequestAdapter.getPageServletPath(req);
        if (servletPath.startsWith("/")) {
            servletPath = servletPath.substring(1);
        }
        if ((path = pwd.lookupChild(servletPath)).isFile()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(servletPath);
        String pathInfo = QuercusRequestAdapter.getPagePathInfo(req);
        if (pathInfo != null) {
            sb.append(pathInfo);
        }
        String scriptPath = sb.toString();
        path = pwd.lookupChild(scriptPath);
        return path;
    }

    protected QuercusContext getQuercus() {
        if (this._quercus == null) {
            this._quercus = new QuercusContext();
        }
        return this._quercus;
    }

    public void destroy() {
        this._quercus.close();
    }
}

