/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.statement.Statement;
import java.util.ArrayList;

public class TryStatement
extends Statement {
    protected final Statement _block;
    protected final ArrayList<Catch> _catchList = new ArrayList();

    public TryStatement(Location location, Statement block) {
        super(location);
        this._block = block;
        block.setParent(this);
    }

    public void addCatch(StringValue id, AbstractVarExpr lhs, Statement block) {
        this._catchList.add(new Catch(id, lhs, block));
        block.setParent(this);
    }

    public Value execute(Env env) {
        try {
            return this._block.execute(env);
        }
        catch (QuercusLanguageException e) {
            Value value = null;
            try {
                value = e.toValue(env);
            }
            catch (Throwable e1) {
                throw new QuercusRuntimeException(e1);
            }
            for (int i = 0; i < this._catchList.size(); ++i) {
                Catch item = this._catchList.get(i);
                if ((value == null || !value.isA(env, item.getId())) && !item.getId().equalsString("Exception")) continue;
                if (value != null) {
                    item.getExpr().evalAssignValue(env, value);
                } else {
                    item.getExpr().evalAssignValue(env, NullValue.NULL);
                }
                return item.getBlock().execute(env);
            }
            throw e;
        }
        catch (QuercusDieException e) {
            for (int i = 0; i < this._catchList.size(); ++i) {
                Catch item = this._catchList.get(i);
                if (!item.getId().equalsString("QuercusDieException")) continue;
                item.getExpr().evalAssignValue(env, env.createException(e));
                return item.getBlock().execute(env);
            }
            throw e;
        }
        catch (QuercusExitException e) {
            for (int i = 0; i < this._catchList.size(); ++i) {
                Catch item = this._catchList.get(i);
                if (!item.getId().equalsString("QuercusExitException")) continue;
                item.getExpr().evalAssignValue(env, env.createException(e));
                return item.getBlock().execute(env);
            }
            throw e;
        }
        catch (Exception e) {
            for (int i = 0; i < this._catchList.size(); ++i) {
                Catch item = this._catchList.get(i);
                if (!item.getId().equalsString("Exception")) continue;
                Exception cause = e;
                item.getExpr().evalAssignValue(env, env.createException(cause));
                return item.getBlock().execute(env);
            }
            if (e instanceof QuercusException) {
                throw (QuercusException)e;
            }
            throw new QuercusException(e);
        }
    }

    public static class Catch {
        private final StringValue _id;
        private final AbstractVarExpr _lhs;
        private final Statement _block;

        Catch(StringValue id, AbstractVarExpr lhs, Statement block) {
            this._id = id;
            this._lhs = lhs;
            this._block = block;
            if (id == null) {
                throw new NullPointerException();
            }
        }

        public StringValue getId() {
            return this._id;
        }

        public AbstractVarExpr getExpr() {
            return this._lhs;
        }

        public Statement getBlock() {
            return this._block;
        }
    }
}

