/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.env.thread.TaskWorker;
import com.caucho.util.AbstractActorQueue;
import com.caucho.util.L10N;
import com.caucho.util.RingBlocker;
import com.caucho.util.RingBlockerBasic;
import com.caucho.util.RingValueArray;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RingValueQueue<M>
extends AbstractActorQueue<M> {
    private static final L10N L = new L10N(RingValueQueue.class);
    private final RingValueArray<M> _ring;
    private final int _capacity;
    private final AtomicLong _headAlloc = new AtomicLong();
    private final AtomicLong _tail = new AtomicLong();
    private final RingBlocker _blocker;
    private volatile boolean _isWriteClosed;

    public RingValueQueue(int capacity) {
        this(capacity, new RingBlockerBasic());
    }

    public RingValueQueue(int capacity, RingBlocker blocker) {
        if (Integer.bitCount(capacity) != 1 || capacity < 2) {
            throw new IllegalArgumentException(L.l("Invalid ring capacity {0}", (Object)Long.toHexString(capacity)));
        }
        if (blocker == null) {
            throw new NullPointerException(L.l("RingBlocker is required"));
        }
        this._capacity = capacity;
        this._ring = new RingValueArray(capacity);
        this._blocker = blocker;
    }

    public int getCapacity() {
        return this._capacity;
    }

    @Override
    public int getOfferReserve() {
        return this._capacity / 2;
    }

    @Override
    public int remainingCapacity() {
        return this._capacity - this.size() - 1;
    }

    @Override
    public final boolean isEmpty() {
        return this._headAlloc.get() == this._tail.get();
    }

    @Override
    public final int size() {
        long head = this._headAlloc.get();
        long tail = this._tail.get();
        return (int)(head - tail);
    }

    public final long getHead() {
        return this._headAlloc.get();
    }

    public final long getHeadAlloc() {
        return this._headAlloc.get();
    }

    public final long getTail() {
        return this._tail.get();
    }

    @Override
    public TaskWorker getOfferTask() {
        return this._blocker;
    }

    public final M getValue(long ptr) {
        return this.get(ptr);
    }

    private final M get(long ptr) {
        return this._ring.get(ptr);
    }

    @Override
    public final boolean offer(M value, long timeout, TimeUnit unit) {
        return this.offer(value, timeout, unit, 0);
    }

    @Override
    public final boolean offer(M value, long timeout, TimeUnit unit, int reservedSpace) {
        long head;
        if (value == null) {
            throw new NullPointerException();
        }
        AtomicLong headRef = this._headAlloc;
        AtomicLong tailRef = this._tail;
        int capacity = this._capacity;
        while (true) {
            long tail = tailRef.get();
            head = headRef.get();
            long nextHead = head + 1L;
            if ((long)capacity <= nextHead - tail + (long)reservedSpace) {
                this.wake();
                if (this._blocker.offerWait(tail, tailRef, reservedSpace, timeout, unit)) continue;
                return false;
            }
            if (headRef.compareAndSet(head, nextHead)) break;
        }
        this._ring.set(head, value);
        return true;
    }

    @Override
    public final M poll(long timeout, TimeUnit unit) {
        AtomicLong headRef = this._headAlloc;
        AtomicLong tailRef = this._tail;
        RingValueArray<M> ring = this._ring;
        RingBlocker blocker = this._blocker;
        while (true) {
            long head;
            long tail;
            if ((tail = tailRef.get()) == (head = headRef.get())) {
                blocker.offerWake();
                if (timeout > 0L && blocker.pollWait(timeout, unit)) continue;
                return null;
            }
            M value = ring.pollAndClear(tail);
            if (value == null) continue;
            if (tailRef.compareAndSet(tail, tail + 1L)) {
                blocker.offerWake();
                return value;
            }
            ring.set(tail, value);
        }
    }

    @Override
    public final M peek() {
        long tail;
        M value;
        do {
            long head;
            if ((head = this._headAlloc.get()) > (tail = this._tail.get())) continue;
            return null;
        } while ((value = this.get(tail)) == null);
        return value;
    }

    public void wake() {
    }

    public final boolean isWriteClosed() {
        return this._isWriteClosed;
    }

    public final void closeWrite() {
        this._isWriteClosed = true;
        this._blocker.offerWake();
        this._blocker.pollWake();
    }

    public final void close() {
        this.closeWrite();
        this._blocker.close();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getCapacity() + "]";
    }
}

