/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CurrentTime;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.logging.Logger;

public class BasicDependencyContainer
implements Dependency {
    private static Logger _log;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private boolean _isModified;
    private long _checkInterval = 2000L;
    private long _lastCheckTime = 0L;
    private volatile boolean _isChecking;

    public BasicDependencyContainer add(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public BasicDependencyContainer remove(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval < 0L || checkInterval > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : checkInterval;
        this._lastCheckTime = 0L;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public void setModified(boolean isModified) {
        this._isModified = isModified;
        this._lastCheckTime = 0L;
    }

    public void resetDependencyCheckInterval() {
        this._lastCheckTime = 0L;
    }

    public void clearModified() {
        this._isModified = false;
        this._lastCheckTime = CurrentTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isModified() {
        boolean bl;
        block8: {
            boolean bl2;
            block7: {
                BasicDependencyContainer basicDependencyContainer = this;
                synchronized (basicDependencyContainer) {
                    if (this._isChecking) return this._isModified;
                    if (this._isModified) {
                        return this._isModified;
                    }
                    this._isChecking = true;
                }
                try {
                    long now = CurrentTime.getCurrentTime();
                    if (now < this._lastCheckTime + this._checkInterval) {
                        boolean bl3 = this._isModified;
                        Object var7_5 = null;
                        this._isChecking = false;
                        return bl3;
                    }
                    this._lastCheckTime = now;
                    for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
                        Dependency dependency = this._dependencyList.get(i);
                        if (!dependency.isModified()) continue;
                        dependency.logModified(this.log());
                        bl2 = this._isModified = true;
                        break block7;
                    }
                    bl = this._isModified;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this._isChecking = false;
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this._isChecking = false;
            return bl2;
        }
        Object var7_7 = null;
        this._isChecking = false;
        return bl;
    }

    public boolean logModified(Logger log) {
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.logModified(log)) continue;
            return true;
        }
        return false;
    }

    public boolean isModifiedNow() {
        this._lastCheckTime = 0L;
        return this.isModified();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(BasicDependencyContainer.class.getName());
        }
        return _log;
    }

    public String toString() {
        return "BasicDependencyContainer" + this._dependencyList;
    }
}

