/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.DatastoreFile;
import java.io.IOException;

public class DatastoreRandomAccessFile {
    private int _position;
    private DatastoreFile _file;

    public DatastoreRandomAccessFile(DatastoreFile file) {
        this._file = file;
    }

    public long getLength() throws IOException {
        return this._file.getLength();
    }

    public long getFilePointer() {
        return this._position;
    }

    public boolean seek(long offset) throws IOException {
        this._position = (int)offset;
        return true;
    }

    public long skip(long offset) throws IOException {
        this._position += (int)offset;
        return offset;
    }

    public void setPosition(long position) throws IOException {
        this._position = (int)position;
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        if (this.read(buffer, 0, 1) <= 0) {
            return -1;
        }
        return buffer[0];
    }

    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)(b & 0xFF)};
        this.write(buffer, 0, 1);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int len = this._file.read(this._position, buffer, offset, length);
        this._position += len;
        return len;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._file.write(this._position, buffer, offset, length);
        this._position += length;
    }

    public void close() throws IOException {
    }
}

