/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.GoogleInodeService;
import com.caucho.vfs.GooglePath;
import com.caucho.vfs.GoogleStorePath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.google.appengine.api.files.FileService;
import com.google.appengine.api.files.FileServiceFactory;
import java.util.ArrayList;

public class GoogleMergePath
extends MergePath {
    private GooglePath _googlePath;

    public GoogleMergePath(Path pwd, String bucket, boolean isGooglePathPrimary) {
        String namespace = "quercus_" + bucket;
        FileService fileService = FileServiceFactory.getFileService();
        GoogleInodeService inodeService = new GoogleInodeService(namespace);
        GoogleStorePath gsPath = new GoogleStorePath(fileService, inodeService, bucket);
        gsPath.init();
        this._googlePath = gsPath;
        if (isGooglePathPrimary) {
            this.addMergePath(gsPath);
            this.addMergePath(pwd);
        } else {
            this.addMergePath(pwd);
            this.addMergePath(gsPath);
        }
    }

    private GoogleMergePath(GoogleMergePath mergePath) {
        this._googlePath = mergePath._googlePath;
        ArrayList<Path> list = mergePath.getPathList();
        for (Path path : list) {
            this.addMergePath(path.copy());
        }
    }

    public GooglePath getGooglePath() {
        return this._googlePath;
    }

    public Path copy() {
        GoogleMergePath copy = new GoogleMergePath(this);
        return copy;
    }
}

