/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdExpr
extends Expr {
    private Expr _expr;
    private ExprEnvironment _lastEnv;
    private int _lastUseCount;
    private Node _lastContext;
    private ArrayList _lastList;

    public IdExpr(ArrayList<Expr> args) {
        if (args.size() > 0) {
            this._expr = args.get(0);
        }
    }

    @Override
    public boolean isNodeSet() {
        return true;
    }

    @Override
    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        String string = this.evalString(node, env);
        return IdExpr.stringToNumber(string);
    }

    @Override
    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return this.id(node, env).size() > 0;
    }

    @Override
    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator iter = this.evalNodeSet(node, env);
        if (!iter.hasNext()) {
            return "";
        }
        Node qNode = iter.next();
        return XmlUtil.textValue(qNode);
    }

    @Override
    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        ArrayList<Element> list = this.id(node, env);
        return list;
    }

    private ArrayList<Element> id(Node context, ExprEnvironment env) throws XPathException {
        ArrayList<String> idList = this.getIdList(context, env);
        ArrayList<Element> list = new ArrayList<Element>();
        if (idList == null || idList.size() == 0) {
            return list;
        }
        Node ptr = context instanceof Document ? context : context.getOwnerDocument();
        while ((ptr = XmlUtil.getNext(ptr)) != null) {
            String idValue;
            if (!(ptr instanceof Element)) continue;
            Element elt = (Element)ptr;
            QDocumentType dtd = (QDocumentType)elt.getOwnerDocument().getDoctype();
            String id = null;
            if (dtd != null) {
                id = dtd.getElementId(elt.getNodeName());
            }
            if (id == null || !idList.contains(idValue = elt.getAttribute(id)) || list.contains(elt)) continue;
            list.add(elt);
        }
        return list;
    }

    private ArrayList<String> getIdList(Node node, ExprEnvironment env) throws XPathException {
        ArrayList<String> idList = new ArrayList<String>();
        Object obj = this._expr.evalObject(node, env);
        if (obj instanceof NodeList) {
            NodeList list = (NodeList)obj;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Node value = list.item(i);
                this.addText(idList, XmlUtil.textValue(value));
            }
        } else if (obj instanceof ArrayList) {
            ArrayList list = (ArrayList)obj;
            for (int i = 0; i < list.size(); ++i) {
                Node value = (Node)list.get(i);
                this.addText(idList, XmlUtil.textValue(value));
            }
        } else if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Node value = (Node)iter.next();
                this.addText(idList, XmlUtil.textValue(value));
            }
        } else {
            this.addText(idList, IdExpr.toString(obj));
        }
        return idList;
    }

    private void addText(ArrayList<String> idList, String text) {
        int i;
        int len = text.length();
        CharBuffer cb = new CharBuffer();
        boolean ch = false;
        for (i = 0; i < len && XmlChar.isWhitespace(text.charAt(i)); ++i) {
        }
        if (i == len) {
            return;
        }
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(text.charAt(i))) {
                cb.append(text.charAt(i));
                ++i;
            }
            idList.add(cb.toString());
            while (i < len && XmlChar.isWhitespace(text.charAt(i))) {
                ++i;
            }
        }
    }

    public String toString() {
        if (this._expr != null) {
            return "id(" + this._expr + ")";
        }
        return "id()";
    }
}

