/*
 * Decompiled with CFR 0.152.
 */
package org.structr.crawler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.EndNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.crawler.SourcePage;
import org.structr.crawler.SourcePageUSESourcePattern;
import org.structr.crawler.SourcePatternSUBPAGESourcePage;
import org.structr.crawler.SourcePatternSUBSourcePattern;
import org.structr.crawler.SourceSite;
import org.structr.rest.common.HttpHelper;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;

public class SourcePattern
extends AbstractNode {
    private static final Logger logger = LoggerFactory.getLogger((String)SourcePattern.class.getName());
    public static final Property<List<SourcePattern>> subPatternsProperty = new EndNodes("subPatterns", SourcePatternSUBSourcePattern.class);
    public static final Property<SourcePage> subPageProperty = new EndNode("subPage", SourcePatternSUBPAGESourcePage.class);
    public static final Property<SourcePage> sourcePageProperty = new StartNode("sourcePage", SourcePageUSESourcePattern.class);
    public static final Property<SourcePattern> parentPatternProperty = new StartNode("parentPattern", SourcePatternSUBSourcePattern.class);
    public static final Property<Long> fromProperty = new LongProperty("from");
    public static final Property<Long> toProperty = new LongProperty("to");
    public static final Property<String> selectorProperty = new StringProperty("selector").indexed();
    public static final Property<String> mappedTypeProperty = new StringProperty("mappedType").indexed();
    public static final Property<String> mappedAttributeProperty = new StringProperty("mappedAttribute").indexed();
    public static final Property<String> mappedAttributeFunctionProperty = new StringProperty("mappedAttributeFunction");
    public static final Property<String> inputValue = new StringProperty("inputValue").indexed();
    public static final View uiView = new View(SourcePattern.class, "ui", new Property[]{subPatternsProperty, subPageProperty, sourcePageProperty, parentPatternProperty, fromProperty, toProperty, selectorProperty, mappedTypeProperty, mappedAttributeProperty, mappedAttributeFunctionProperty, inputValue});

    private Class type(String typeString) throws FrameworkException {
        Class type = null;
        ConfigurationProvider config = StructrApp.getConfiguration();
        if (typeString != null) {
            type = config.getNodeEntityClass(typeString);
        }
        if (type == null) {
            throw new FrameworkException(422, "Unknown type '" + typeString + "'");
        }
        return type;
    }

    private NodeInterface create(String typeString) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        return app.create(this.type(typeString), new NodeAttribute[0]);
    }

    private SourceSite getSite() {
        SourcePattern pattern = this;
        SourcePage page = (SourcePage)((Object)pattern.getProperty((PropertyKey)sourcePageProperty));
        while (page == null) {
            if ((pattern = (SourcePattern)((Object)pattern.getProperty((PropertyKey)parentPatternProperty))) == null) continue;
            page = (SourcePage)((Object)pattern.getProperty((PropertyKey)sourcePageProperty));
        }
        return (SourceSite)((Object)page.getProperty((PropertyKey)SourcePage.site));
    }

    private String getContent(String urlString) throws FrameworkException {
        SourceSite site = this.getSite();
        String proxyUrl = (String)site.getProperty((PropertyKey)SourceSite.proxyUrl);
        String proxyUsername = (String)site.getProperty((PropertyKey)SourceSite.proxyUsername);
        String proxyPassword = (String)site.getProperty((PropertyKey)SourceSite.proxyPassword);
        Principal user = this.securityContext.getCachedUser();
        if (user != null & StringUtils.isBlank((CharSequence)proxyUrl)) {
            proxyUrl = (String)user.getProperty((PropertyKey)Principal.proxyUrl);
            proxyUsername = (String)user.getProperty((PropertyKey)Principal.proxyUsername);
            proxyPassword = (String)user.getProperty((PropertyKey)Principal.proxyPassword);
        }
        String cookie = (String)site.getProperty((PropertyKey)SourceSite.cookie);
        return HttpHelper.get((String)urlString, (String)proxyUrl, (String)proxyUsername, (String)proxyPassword, (String)cookie, (Map)Collections.EMPTY_MAP).replace("<head>", "<head>\n  <base href=\"" + urlString + "\">");
    }

    private void extractAndSetValue(NodeInterface obj, Document doc, String selector, String mappedType, String mappedAttribute, String mappedAttributeFunction, SourcePage subPage) throws FrameworkException {
        if (StringUtils.isNotEmpty((CharSequence)mappedAttribute)) {
            String ex = doc.select(selector).text();
            ConfigurationProvider config = StructrApp.getConfiguration();
            PropertyKey key = config.getPropertyKeyForJSONName(this.type(mappedType), mappedAttribute);
            if (StringUtils.isNotBlank((CharSequence)ex) && key != null) {
                PropertyConverter inputConverter;
                Object convertedValue = ex;
                if (StringUtils.isNotBlank((CharSequence)mappedAttributeFunction)) {
                    ActionContext ctx = new ActionContext(this.securityContext);
                    ctx.setConstant("input", convertedValue);
                    convertedValue = Scripting.evaluate((ActionContext)ctx, null, (String)("${" + mappedAttributeFunction + "}"), (String)(" virtual property " + mappedAttribute));
                }
                if ((inputConverter = key.inputConverter(this.securityContext)) != null) {
                    convertedValue = inputConverter.convert(convertedValue);
                }
                obj.setProperty(key, convertedValue);
            }
        } else if (subPage != null) {
            URI uri;
            String pageUrl = (String)subPage.getProperty((PropertyKey)SourcePage.url);
            try {
                uri = new URI(pageUrl);
            }
            catch (URISyntaxException ex) {
                throw new FrameworkException(422, "Unable to parse sub page url: " + pageUrl);
            }
            String subUrl = uri.getScheme() + "://" + uri.getAuthority() + doc.select(selector).attr("href");
            String subContent = this.getContent(subUrl);
            Document subDoc = Jsoup.parse((String)subContent);
            List subPagePatterns = (List)subPage.getProperty((PropertyKey)SourcePage.patterns);
            for (SourcePattern subPagePattern : subPagePatterns) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("document", subDoc);
                params.put("object", obj);
                subPagePattern.extract(params);
            }
        }
    }

    @Export
    public void extract(Map<String, Object> parameters) throws FrameworkException {
        SourcePage page = (SourcePage)((Object)this.getProperty((PropertyKey)sourcePageProperty));
        if (page == null) {
            throw new FrameworkException(422, "Pattern has no source page, exiting.");
        }
        String selector = (String)this.getProperty((PropertyKey)selectorProperty);
        if (selector == null) {
            throw new FrameworkException(422, "Pattern has no selector, exiting.");
        }
        Long from = (Long)this.getProperty((PropertyKey)fromProperty);
        Long to = (Long)this.getProperty((PropertyKey)toProperty);
        List subPatterns = (List)this.getProperty((PropertyKey)subPatternsProperty);
        Document doc = null;
        NodeInterface parentObj = null;
        if (parameters.containsKey("object")) {
            parentObj = (NodeInterface)parameters.get("object");
        }
        if (parameters.containsKey("document")) {
            doc = (Document)parameters.get("document");
        } else {
            String url = (String)page.getProperty((PropertyKey)SourcePage.url);
            if (url == null) {
                throw new FrameworkException(422, "This pattern's source page has no URL, exiting.");
            }
            String content = this.getContent(url);
            doc = Jsoup.parse((String)content);
        }
        String mappedType = (String)this.getProperty((PropertyKey)mappedTypeProperty);
        if (mappedType == null) {
            throw new FrameworkException(422, "No mapped type given, exiting.");
        }
        Elements parts = doc.select(selector);
        int i = from != null ? from.intValue() : 1;
        while ((long)i <= (to != null ? to : (long)parts.size())) {
            NodeInterface obj;
            NodeInterface nodeInterface = obj = parentObj == null ? this.create(mappedType) : parentObj;
            if (subPatterns.size() > 0) {
                for (SourcePattern subPattern : subPatterns) {
                    String subSelector = selector + ":nth-child(" + i + ") > " + (String)subPattern.getProperty((PropertyKey)selectorProperty);
                    String subPatternMappedAttribute = (String)subPattern.getProperty((PropertyKey)mappedAttributeProperty);
                    String subPatternMappedAttributeFunction = (String)subPattern.getProperty((PropertyKey)mappedAttributeFunctionProperty);
                    SourcePage subPatternSubPage = (SourcePage)((Object)subPattern.getProperty((PropertyKey)subPageProperty));
                    this.extractAndSetValue(obj, doc, subSelector, mappedType, subPatternMappedAttribute, subPatternMappedAttributeFunction, subPatternSubPage);
                }
            } else {
                String mappedAttribute = (String)this.getProperty((PropertyKey)mappedAttributeProperty);
                String mappedAttributeFunction = (String)this.getProperty((PropertyKey)mappedAttributeFunctionProperty);
                this.extractAndSetValue(obj, doc, selector, mappedType, mappedAttribute, mappedAttributeFunction, null);
            }
            ++i;
        }
    }
}

