/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";
    private Iterator<String> passwords;
    private String current;

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.passwords = PasswordIdentityProvider.Utils.iteratorOf(session);
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        if (this.passwords == null || !this.passwords.hasNext()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest({})[{}] no more passwords to send", (Object)session, (Object)service);
            }
            return false;
        }
        this.current = this.passwords.next();
        String username = session.getUsername();
        Buffer buffer = session.createBuffer((byte)50, username.length() + service.length() + this.getName().length() + this.current.length() + 32);
        this.sendPassword(buffer, session, this.current, this.current);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        String password;
        boolean interactive;
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "]" + " received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        String prompt = buffer.getString();
        String lang = buffer.getString();
        UserInteraction ui = session.getUserInteraction();
        try {
            interactive = ui != null && ui.isInteractionAllowed(session);
            password = interactive ? ui.getUpdatedPassword(session, prompt, lang) : null;
        }
        catch (Error e) {
            this.log.warn("processAuthDataRequest({})[{}] failed ({}) to consult interaction: {}", new Object[]{session, service, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("processAuthDataRequest(" + session + ")[" + service + "] interaction consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException(e);
        }
        if (interactive) {
            if (GenericUtils.isEmpty(password)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("processAuthDataRequest({})[{}] No updated password for prompt={}, lang={}", new Object[]{session, service, prompt, lang});
                }
                return false;
            }
            this.sendPassword(buffer, session, password, password);
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processAuthDataRequest({})[{}] no UI for password change request for prompt={}, lang={}", new Object[]{session, service, prompt, lang});
        }
        return false;
    }

    protected IoWriteFuture sendPassword(Buffer buffer, ClientSession session, String oldPassword, String newPassword) throws IOException {
        boolean modified;
        String username = session.getUsername();
        String service = this.getService();
        String name = this.getName();
        boolean bl = modified = !Objects.equals(oldPassword, newPassword);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendPassword({})[{}] send SSH_MSG_USERAUTH_REQUEST for {} - modified={}", new Object[]{session, service, name, modified});
        }
        buffer = session.createBuffer((byte)50, GenericUtils.length(username) + GenericUtils.length(service) + GenericUtils.length(name) + GenericUtils.length(oldPassword) + (modified ? GenericUtils.length(newPassword) : 0) + 64);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(modified);
        buffer.putString(oldPassword);
        if (modified) {
            buffer.putString(newPassword);
        }
        return session.writePacket(buffer);
    }
}

