/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;

public interface AttributeStore {
    public <T> T getAttribute(AttributeKey<T> var1);

    public <T> T setAttribute(AttributeKey<T> var1, T var2);

    public <T> T removeAttribute(AttributeKey<T> var1);

    public <T> T resolveAttribute(AttributeKey<T> var1);

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static <T> T resolveAttribute(FactoryManager manager, AttributeKey<T> key) {
            ValidateUtils.checkNotNull(key, "No key");
            return manager == null ? null : (T)manager.getAttribute(key);
        }

        public static <T> T resolveAttribute(Session session, AttributeKey<T> key) {
            ValidateUtils.checkNotNull(key, "No key");
            if (session == null) {
                return null;
            }
            T value = session.getAttribute(key);
            return value != null ? value : Utils.resolveAttribute(session.getFactoryManager(), key);
        }

        public static <T> T resolveAttribute(Channel channel, AttributeKey<T> key) {
            ValidateUtils.checkNotNull(key, "No key");
            if (channel == null) {
                return null;
            }
            T value = channel.getAttribute(key);
            return value != null ? value : Utils.resolveAttribute(channel.getSession(), key);
        }
    }

    public static class AttributeKey<T> {
    }
}

