/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.ForwardingFilter;

public class StaticDecisionForwardingFilter
extends AbstractLoggingBean
implements ForwardingFilter {
    private final boolean acceptance;

    public StaticDecisionForwardingFilter(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public boolean canForwardAgent(Session session) {
        return this.checkAcceptance("auth-agent-req@openssh.com", session, SshdSocketAddress.LOCALHOST_ADDRESS);
    }

    @Override
    public boolean canForwardX11(Session session) {
        return this.checkAcceptance("x11-req", session, SshdSocketAddress.LOCALHOST_ADDRESS);
    }

    @Override
    public boolean canListen(SshdSocketAddress address, Session session) {
        return this.checkAcceptance("tcpip-forward", session, address);
    }

    @Override
    public boolean canConnect(ForwardingFilter.Type type, SshdSocketAddress address, Session session) {
        return this.checkAcceptance(type.getName(), session, address);
    }

    protected boolean checkAcceptance(String request, Session session, SshdSocketAddress target) {
        boolean accepted = this.isAccepted();
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkAcceptance(" + request + ")[" + session + "] acceptance for target=" + target + " is " + accepted);
        }
        return accepted;
    }
}

