/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.server.x11.ChannelForwardedX11;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class DefaultX11ForwardSupport
extends AbstractInnerCloseable
implements X11ForwardSupport {
    private final ConnectionService service;
    private IoAcceptor acceptor;

    public DefaultX11ForwardSupport(ConnectionService service) {
        this.service = ValidateUtils.checkNotNull(service, "No connection service");
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.acceptor).build();
    }

    @Override
    public synchronized String createDisplay(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("X11ForwardSupport is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("X11ForwardSupport is closing");
        }
        if (OsUtils.isWin32()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) Windows O/S N/A", new Object[]{authenticationProtocol, authenticationCookie, screen});
            }
            return null;
        }
        Session session = ValidateUtils.checkNotNull(this.service.getSession(), "No session");
        if (this.acceptor == null) {
            FactoryManager manager = ValidateUtils.checkNotNull(session.getFactoryManager(), "No factory manager");
            IoServiceFactory factory = ValidateUtils.checkNotNull(manager.getIoServiceFactory(), "No I/O service factory");
            this.acceptor = factory.createAcceptor(this);
        }
        int minDisplayNumber = PropertyResolverUtils.getIntProperty(session, "x11-fwd-display-offset", 10);
        int maxDisplayNumber = PropertyResolverUtils.getIntProperty(session, "x11-fwd-max-display", 1000);
        int basePort = PropertyResolverUtils.getIntProperty(session, "x11-fwd-base-port", 6000);
        String bindHost = PropertyResolverUtils.getStringProperty(session, "x11-fwd-bind-host", "127.0.0.1");
        InetSocketAddress addr = null;
        for (int displayNumber = minDisplayNumber; displayNumber < maxDisplayNumber; ++displayNumber) {
            int port = basePort + displayNumber;
            addr = new InetSocketAddress(bindHost, port);
            try {
                this.acceptor.bind(addr);
                break;
            }
            catch (BindException bindErr) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) failed ({}) to bind to address={}: {}", new Object[]{authenticationProtocol, authenticationCookie, screen, bindErr.getClass().getSimpleName(), addr, bindErr.getMessage()});
                }
                addr = null;
                continue;
            }
        }
        if (addr == null) {
            this.log.warn("createDisplay(auth={}, cookie={}, screen={}) failed to allocate internet-domain X11 display socket in range {}-{}", new Object[]{authenticationProtocol, authenticationCookie, screen, minDisplayNumber, maxDisplayNumber});
            Set<SocketAddress> boundAddressess = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(boundAddressess)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - no more bound addresses", new Object[]{authenticationProtocol, authenticationCookie, screen});
                }
                this.close();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - remaining bound addresses: {}", new Object[]{authenticationProtocol, authenticationCookie, screen, boundAddressess});
            }
            return null;
        }
        int port = addr.getPort();
        int displayNumber = port - basePort;
        String authDisplay = "unix:" + displayNumber + "." + screen;
        try {
            Process p = new ProcessBuilder(XAUTH_COMMAND, "remove", authDisplay).start();
            int result = p.waitFor();
            if (this.log.isDebugEnabled()) {
                this.log.debug("createDisplay({}) {} remove result={}", new Object[]{authDisplay, XAUTH_COMMAND, result});
            }
            if (result == 0) {
                p = new ProcessBuilder(XAUTH_COMMAND, "add", authDisplay, authenticationProtocol, authenticationCookie).start();
                result = p.waitFor();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("createDisplay({}) {} add result={}", new Object[]{authDisplay, XAUTH_COMMAND, result});
                }
            }
            if (result != 0) {
                throw new IllegalStateException("Bad " + XAUTH_COMMAND + " invocation result: " + result);
            }
            return bindHost + ":" + displayNumber + "." + screen;
        }
        catch (Throwable e) {
            this.log.warn("createDisplay({}) failed ({}) run xauth: {}", new Object[]{authDisplay, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("createDisplay(" + authDisplay + ") xauth failure details", e);
            }
            return null;
        }
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        ChannelForwardedX11 channel = new ChannelForwardedX11(session);
        session.setAttribute(ChannelForwardedX11.class, channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sessionCreated({}) channel{}", (Object)session, (Object)channel);
        }
        this.service.registerChannel(channel);
        channel.open().verify(PropertyResolverUtils.getLongProperty(channel, "x11-fwd-open-timeout", DEFAULT_CHANNEL_OPEN_TIMEOUT));
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        if (channel != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) close channel={}", (Object)session, (Object)channel);
            }
            channel.close(false);
        }
    }

    @Override
    public void messageReceived(IoSession session, Readable message) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        if (this.log.isTraceEnabled()) {
            this.log.trace("messageReceived({}) channel={}, len={}", new Object[]{session, channel, buffer.available()});
        }
        OutputStream outputStream = channel.getInvertedIn();
        outputStream.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
        outputStream.flush();
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("exceptionCaught({}) {}: {}", new Object[]{session, cause.getClass().getSimpleName(), cause.getMessage()});
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("exceptionCaught(" + session + ") caught exception details", cause);
        }
        session.close(false);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.service.getClass();
    }
}

